<?php

namespace App\Controllers;

class Chart extends BaseController
{
  public function render($template="pie")
  {
    $form = json_decode(file_get_contents('php://input'),true);

    $models = [];
    $i=0;
    $diff = 0;
    $count_errors = 0;

    switch ($template) {
      case 'pie':
        $query = $this->db->query($form['data'][0]['source']);
        if ($query) {
          foreach ($query->getResultArray() as $item) {
            $models['legend'][] = $item['label'];
          }
        }else{
          $error = $this->db->error();
          $count_errors+=1;
        }
        foreach ($form['data'] as $serie) {
          $x=($i+1)*10;
          $y=($i+1)*10;
          $query = $this->db->query($serie['source']);
          if($query){
            $models['series'][$i]['name'] = $serie['title'];
            $models['series'][$i]['type'] = 'pie';
            if ($i==0) {
              $models['series'][$i]['radius'] = count($form['data'])>1?[0,($y*2).'%']:'55%';
              $diff = ($y*2);
            }else{
              $models['series'][$i]['radius'] = [(($i+1)*$diff)-($diff-2).'%',(($i+1)*$diff).'%'];
            }
            $models['series'][$i]['center'] = ['50%','60%'];
            foreach ($query->getResultArray() as $item) {
              $models['series'][$i]['data'][] = [
                'value'=>intval($item['value']),
                'name'=>$item['label']
              ];
            }
            if ($i<count($form['data'])-1) {
              $models['series'][$i]['label']['position'] = 'inner';
              $models['series'][$i]['label']['fontSize'] = 10;
            }
            if ($form['attr']['label']['formatter']) {
              $models['series'][$i]['label']['formatter'] = $form['attr']['label']['formatter'];
            }
            $models['series'][$i]['emphasis']['itemStyle']['shadowBlur'] = 10;
            $models['series'][$i]['emphasis']['itemStyle']['shadowOffsetX'] = 0;
            $models['series'][$i]['emphasis']['itemStyle']['shadowColor'] = 'rgba(0,0,0,0.5)';
    
            $i++;
          } else {
            $error = $this->db->error();
            $count_errors+=1;
          }
    
        }
      break;
      case 'bar':
        $models['xAxis']['type'] = 'category';
        $models['yAxis']['type'] = 'value';
        $query = $this->db->query($form['data'][0]['source']);
        if ($query) {
          foreach ($query->getResultArray() as $item) {
            $models['xAxis']['data'][] = $item['label'];
          }
        }else{
          $error = $this->db->error();
          $count_errors+=1;
        }
        $i=0;
        foreach ($form['data'] as $serie) {
          $query = $this->db->query($serie['source']);
          if($query){
            $models['series'][$i]['type'] = 'bar';
            $models['series'][$i]['name'] = $serie['title'];
            $models['series'][$i]['stack'] = 'bar';
            $models['series'][$i]['label']['show'] = true;
            $models['series'][$i]['emphasis']['focus'] = 'series';
            if (count($form['data'])>1) {
              $models['series'][$i]['itemStyle'] = [
                'color' => $serie['color']
              ];
            }
            foreach ($query->getResultArray() as $item) {
              $models['series'][$i]['data'][] = intval($item['value']);
            }
          } else {
            $error = $this->db->error();
            $count_errors+=1;
          }
          $i++;
        }
      break;
      case 'line':
        $models['xAxis']['type'] = 'category';
        $models['xAxis']['boundaryGap'] = false;
        $models['yAxis']['type'] = 'value';
        $query = $this->db->query($form['data'][0]['source']);
        if ($query) {
          $label = $query->getResultArray();
          if ($label[0]['label'] && $label[0]['value']) {
            foreach ($query->getResultArray() as $item) {
              $models['xAxis']['data'][] = $item['label'];
            }
          } else {
            foreach ($query->getRowArray() as $kv => $vv) {
              $models['xAxis']['data'][] = $kv;
            }
          }
        }else{
          $error = $this->db->error();
          $count_errors+=1;
        }
        $i=0;
        foreach ($form['data'] as $serie) {
          $query = $this->db->query($serie['source']);
          if($query){
            $models['series'][$i]['type'] = 'line';
            $models['series'][$i]['name'] = $serie['title'];
            $models['series'][$i]['smooth'] = true;
            $models['series'][$i]['itemStyle'] =[
              'color' => $serie['color']
            ];
            $models['series'][$i]['lineStyle'] =[
              'color' => $serie['color']
            ];
            $label = $query->getResultArray();
            if ($label[0]['label'] && $label[0]['value']) {
              foreach ($query->getResultArray() as $item) {
                $models['series'][$i]['data'][] = round(floatval($item['value']),2);
              }
            } else {
              foreach ($query->getRowArray() as $kv => $vv) {
                $models['series'][$i]['data'][] = round(floatval($vv),2);
              }
            }
          } else {
            $error = $this->db->error();
            $count_errors+=1;
          }
          $i++;
        }
      break;
      case 'area':
        $models['xAxis']['type'] = 'category';
        $models['xAxis']['boundaryGap'] = false;
        $models['yAxis']['type'] = 'value';
        $query = $this->db->query($form['data'][0]['source']);
        if ($query) {
          foreach ($query->getResultArray() as $item) {
            $models['xAxis']['data'][] = $item['label'];
          }
        }else{
          $error = $this->db->error();
          $count_errors+=1;
        }
        $i=0;
        foreach ($form['data'] as $serie) {
          $query = $this->db->query($serie['source']);
          if($query){
            $models['series'][$i]['type'] = 'line';
            $models['series'][$i]['name'] = $serie['title'];
            $models['series'][$i]['smooth'] = true;
            $models['series'][$i]['itemStyle'] =[
              'color' => $serie['color']
            ];
            $models['series'][$i]['lineStyle'] =[
              'color' => $serie['color']
            ];
            $models['series'][$i]['areaStyle'] = '{}';
            foreach ($query->getResultArray() as $item) {
              $models['series'][$i]['data'][] = intval($item['value']);
            }
          } else {
            $error = $this->db->error();
            $count_errors+=1;
          }
          $i++;
        }
      break;
      default:
        $query = $this->db->query($form['data'][0]['source']);
        if ($query) {
          foreach ($query->getResultArray() as $item) {
            $models['legend'][] = $item['label'];
          }
        }else{
          $error = $this->db->error();
          $count_errors+=1;
        }
        foreach ($form['data'] as $serie) {
          $x=($i+1)*10;
          $y=($i+1)*10;
          $query = $this->db->query($serie['source']);
          if($query){
            $models['series'][$i]['name'] = $serie['title'];
            $models['series'][$i]['type'] = 'pie';
            if ($i==0) {
              $models['series'][$i]['radius'] = count($form['data'])>1?[0,($y*2).'%']:'55%';
              $diff = ($y*2);
            }else{
              $models['series'][$i]['radius'] = [(($i+1)*$diff)-($diff-2).'%',(($i+1)*$diff).'%'];
            }
            $models['series'][$i]['center'] = ['50%','60%'];
            foreach ($query->getResultArray() as $item) {
              $models['series'][$i]['data'][] = [
                'value'=>intval($item['value']),
                'name'=>$item['label']
              ];
            }
            if ($i<count($form['data'])-1) {
              $models['series'][$i]['label']['position'] = 'inner';
              $models['series'][$i]['label']['fontSize'] = 10;
            }
            if ($form['attr']['label']['formatter']) {
              $models['series'][$i]['label']['formatter'] = $form['attr']['label']['formatter'];
            }
            $models['series'][$i]['emphasis']['itemStyle']['shadowBlur'] = 10;
            $models['series'][$i]['emphasis']['itemStyle']['shadowOffsetX'] = 0;
            $models['series'][$i]['emphasis']['itemStyle']['shadowColor'] = 'rgba(0,0,0,0.5)';
    
            $i++;
          } else {
            $error = $this->db->error();
            $count_errors+=1;
          }
    
        }
      break;
    }

    $response['status'] = $count_errors>0?500:200;
    $response['dataset'] = $models;

    echo json_encode($response);
  }
}
