<?php

namespace App\Controllers;

class Menu extends BaseController
{
  public function get($type="left",$source="shop")
  {
    $session = $this->session->get();
    $menu_finish = [];
    if ($source=="web") {
      $ret = $this->menu->where(['type'=>$type,'source'=>$source])->first();
    } else {
      if (!empty($session['role'])) {
        $ret = $this->menu->where(['role'=>$this->session->role,'type'=>$type,'source'=>$source])->first();
      }else{
        $ret = $this->menu->where(['role'=>'admin','type'=>'nav','source'=>$source])->first();
      }
    }
    $menu_finish = $ret['modules'];
    echo $menu_finish;
  }
  public function get_list($type="left")
  {
    $ret = [
      'menu' => json($this->db->table('sys_menu')->get()->getResultArray()),
      'modules' => json($this->db->table('sys_modules')->get()->getResultArray())
    ];
    echo json($ret,true,false);
  }
  public function set($key)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];

    $sql = $this->db->table('sys_menu')
      ->set(['modules' => is_array($form['data']['modules'])?json_encode($form['data']['modules']):$form['data']['modules']])
      ->where('ID', $key)
      ->update();

    if ($sql) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
      $response['message'] = $this->db->error();
    }
    echo json_encode($response);
  }
  public function permission($controller=null,$type="nav",$source="admin")
  {
    $session = $this->session->get();
    if (!empty($session['role'])) {
      $ret = $this->menu->where(['role'=>$this->session->role,'type'=>$type,'source'=>$source])->first();
    }else{
      $ret = $this->menu->where(['role'=>'admin','type'=>'nav','source'=>'admin'])->first();
    }

    $dec = json_decode($ret['modules'],true);
    foreach ($dec as $item) {
      if ($controller == $item['controller']) {
        echo json_encode($item['action']);
      }
    }
  }
}
