<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class Settings extends Seeder
{
  public function run()
  {
    $this->db = db_connect();
    $data = [
      [
        'key' => 'contact',
        'icon' => 'ri-mail-line',
        'name' => 'Ajustes de Mensajeria',
        'value' => 'false',
        'config' => '{"table":"usuario","fields":{"name":"nombre","user":"usuario","email":"correo","password":"clave"}}'
      ],
      [
        'key' => 'interface',
        'icon' => 'ri-side-bar-line',
        'name' => 'Ajustes de la Interface',
        'value' => 'false',
        'config' => '{"nav":{"color":"purple darken-4","style":[],"dark":true},"sidebar":{"color":"purple lighten-4","style":[],"dark":false},"session":{"color":"purple darken-4","style":{"background":"linear-gradient(135deg, #9C27B0 0%,#009688 100%)"},"dark":true}}'
      ],
      [
        'key' => 'security',
        'icon' => 'ri-shield-keyhole-line',
        'name' => 'Ajustes de Seguridad',
        'value' => 'false',
        'config' => '{"table":"usuario","allow_register":true,"fields":{"id":"COD","role":"rol","name":"nombre","user":"usuario","email":"correo","password":"clave"}}'
      ],
      [
        'key' => 'main-screen',
        'icon' => 'bx-home',
        'name' => 'Pantalla de Inicio',
        'value' => 'false',
        'config' => '[]'
      ]
    ];
    $this->db->table('sys_settings')->insertBatch($data);
  }
}