<?php
if(!function_exists("create_table")){
  function create_table($name=null,$fields=[],$index=[],$keys=[]){
    $db  = \Config\Database::connect();
    $tables = count($db->listTables());

    $name = empty($name)?"table_{$tables}":$name;
    $sql_start = "CREATE TABLE `{$name}`(";
    $sql = [];
    $f=0;
    foreach ($fields as $field) {
      $fieldname = url_title($field['name'],'_');
      $type = !empty($field['length'])?"{$field['type']}({$field['length']})":"{$field['type']}";
      $unsigned = $field['unsigned']?"UNSIGNED":"";
      if ($field['nullable']) {
        if ($field['auto_increment']) {
          $nullable = "NOT NULL";
        }else{
          $nullable = "NULL";
        }
      } else{
        $nullable = "NOT NULL";
      }
      $auto_increment = $field['auto_increment']?"AUTO_INCREMENT":"";
      if ($field['default']) {
        if (str_contains($field['type'],'TEXT')) {
          $default = "";
        } else {
          $default = $field['default'];
        }
        if ($field['auto_increment']) {
          $default = "";
        } else {
          $default = $field['default'];
        }
      }else{
        $default = "";
      }

      $sql[] = "`{$fieldname}` {$type} {$unsigned} {$nullable} {$auto_increment} {$default}";
      $f++;
    }
    foreach ($index as $key => $value) {
      $v_esc = [];
      $v_nor = [];
      foreach ($value as $v) {
        $v_esc[$key][] = "`{$v}`";
        $v_nor[$key][] = "{$v}";
      }
      if ($key=='primary') {
        if (!empty($index[$key])) {
          $val_esc = implode(',',$v_esc[$key]);
          $val_name = implode('_',$v_nor[$key]);
          $sql[] = "PRIMARY KEY ({$val_esc}) USING BTREE";
        }
      }
      if ($key=='key') {
        if (!empty($index[$key])) {
          $val_esc = implode(',',$v_esc[$key]);
          $val_name = implode('_',$v_nor[$key]);
          $sql[] = "INDEX `{$name}_{$key}_{$val_name}` ({$val_esc})";
        }
      }
      if ($key=='unique') {
        if (!empty($index[$key])) {
          $val_esc = implode(',',$v_esc[$key]);
          $val_name = implode('_',$v_nor[$key]);
          $sql[] = "UNIQUE INDEX `{$name}_{$key}_{$val_name}` ({$val_esc})";
        }
      }
    }
    foreach ($keys as $key) {
      $v_esc = [];
      $f_esc = [];
      foreach ($key['fields'] as $v) {
        $v_esc[] = "`{$v}`";
      }
      foreach ($key['foreign_fields'] as $f) {
        $f_esc[] = "`{$f}`";
      }
      $val_esc = implode(',', $v_esc);
      $for_esc = implode(',', $f_esc);
      $sql[] = "CONSTRAINT `fk_{$name}_{$key['table']}` FOREIGN KEY ({$val_esc}) REFERENCES `{$key['table']}` ({$for_esc})";
    }
    return $sql_start.implode(',', $sql).") ENGINE=InnoDB";
    //return json_encode($index);
  }
}
?>