<?php
  $this->uri = service('uri');
  $pk = '';
  $map_type = [];
  $methods = [];
  $created = [];
  $card_titled = false;

  $created[] = 'this.Data()';
  $models['title'] = $response['name'];
  $models['to_remove'] = false;
  $models['remove_item'] = null;
  $models['list'] = [];
  $models['headers'] = [];
  $models['export']['headers'] = [];
  $models['query'] = $response['query'];
  $width_action = 10;

  foreach ($response['data'] as $field) {
    $main_table = explode('.',$field['name']);
    if ($field['type'] == 'marker') {
      $latlng = $field['name'];
      $map_type[] = [
        'name'=>$field['name'],
        'label'=>$field['label'],
        'field'=>$field['field'],
        'type'=>$field['type']
      ];
    }
    if ($field['type'] == 'polygon') {
      $latlng = $field['name'];
      $map_type[] = [
        'name'=>$field['name'],
        'label'=>$field['label'],
        'field'=>$field['field'],
        'type'=>$field['type']
      ];
    }

    if ($main_table[0] == $response['table'] and $field['primary_key'] == '1') {
      $pk = $field['name'];
      $models['query']['select'][] = $field['name'];
    }
    if ($field['visible']==true) {
      $pre_width = ($field['width']/12)*100;
      $width = ($pre_width*(100-$width_action))/100;
      $models['headers'][] = [
        'text'=>"{$field['label']}",
        'sortable'=>true,
        'value'=>str_replace('.','_',$field['name'])
        //'width'=>"{$width}%"
      ];
      $models['export']['headers'][] = [
        'title'=>"{$field['label']}",
        'dataKey'=>str_replace('.','_',$field['name'])
      ];
      $models['query']['select'][] = $field['name'];
    }
  }
  $models['headers'][] = [
    'text'=>"...",
    'width'=>"{$width_action}%"
  ];

  $props['props'] = [];

  foreach ($response['props'] as $key => $value) {
    $props['props'][] = $key;
  }
?>

Vue.component('<?=$response['codename']?>',{template: `
  <div>
    <v-data-iterator :items="list">
      <template v-slot:header>
        <v-toolbar flat>
          <v-toolbar-title>{{title}}</v-toolbar-title>
          <v-divider class="mx-4" inset vertical></v-divider>
          <v-spacer></v-spacer>
          <v-tooltip bottom color="primary">
            <template v-slot:activator="{ on, attrs }">
              <v-btn
                color="primary"
                dark
                v-bind="attrs"
                v-on="on"
                fab
                x-small
                @click="generate()"
              >
                <v-icon>bi-file-earmark-pdf</v-icon>
              </v-btn>
            </template>
            <span>Generar PDF</span>
          </v-tooltip>
        </v-toolbar>
      </template>
      <template v-slot:default="props">
        <v-row>
          <v-col v-for="(row,r) in list" cols="12" :md="md">
            <v-card>
              <v-card-text>
                <v-row>
                  <?php foreach ($response['data'] as $field): ?>
                    <?php if ($field['visible']==true): ?>
                      <?php
                        $pre_width = ($field['width']/12)*100;
                        $width = round($pre_width,0);
                        if ($field['filter']==''){
                          $filter = '';
                        }elseif($field['filter']==null){
                          $filter = '';
                        }else {
                          $filter = " | {$field['filter']}";
                        }
                      ?>
                      <?php if ($field['type']=='checkbox'): ?>
                        <v-col cols="12" :md="<?= $field['width'] ?>">
                          <dt><strong><?=$field['label']?></strong></dt>
                          <v-icon :color="row.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">
                            {{row.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}
                          </v-icon>
                        </v-col>
                      <?php elseif ($field['type']=='image'): ?>
                        <v-col cols="12" :md="<?= $field['width'] ?>">
                          <div v-if="typeof row.<?=str_replace('.','_',$field['name'])?> === 'string'">
                            <v-img v-if="row.<?=str_replace('.','_',$field['name'])?>" :src="row.<?=str_replace('.','_',$field['name'])?>" max-width="150" contain></v-img>
                          </div>
                          <div v-else=""></div>
                        </v-col>
                      <?php elseif ($field['type']=='file'): ?>
                        <v-col cols="12" :md="<?= $field['width'] ?>">
                          <v-icon :color="row.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">
                            {{row.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}
                          </v-icon>
                        </v-col>
                      <?php else: ?>
                        <v-col cols="12" :md="<?= $field['width'] ?>">
                          <dt><strong><?=$field['label']?></strong></dt>
                          <dd>{{row.<?=str_replace('.','_',$field['name'])?><?=$filter?>}}</dd>
                        </v-col>
                      <?php endif ?>
                    <?php endif ?>
                  <?php endforeach ?>
                </v-row>
              </v-card-text>
              <v-card-actions class="justify-space-between">
                <v-tooltip bottom color="teal" v-if="view">
                  <template v-slot:activator="{ on, attrs }">
                    <v-btn
                      @click="$root.Url($root.url.c+'-'+view,row.<?=str_replace('.','_',$pk)?>,'page')"
                      color="teal"
                      v-bind="attrs"
                      v-on="on"
                      fab
                      x-small
                      dark
                    >
                      <v-icon>bi bi-eye</v-icon>
                    </v-btn>
                  </template>
                  <span>Ver Detalles</span>
                </v-tooltip>

                <v-tooltip bottom color="indigo" v-if="update">
                  <template v-slot:activator="{ on, attrs }">
                    <v-btn
                      @click="$root.Url($root.url.c+'-'+update,row.<?=str_replace('.','_',$pk)?>,'page')"
                      color="indigo"
                      v-bind="attrs"
                      v-on="on"
                      fab
                      x-small
                      dark
                    >
                      <v-icon>bi-pencil-square</v-icon>
                    </v-btn>
                  </template>
                  <span>Editar</span>
                </v-tooltip>

                <v-tooltip bottom color="red" v-if="remove">
                  <template v-slot:activator="{ on, attrs }">
                    <v-btn
                      @click="setUrl('remove',row.<?=str_replace('.','_',$pk)?>)"
                      color="red"
                      v-bind="attrs"
                      v-on="on"
                      fab
                      x-small
                      dark
                    >
                      <v-icon>bi-trash</v-icon>
                    </v-btn>
                  </template>
                  <span>Eliminar</span>
                </v-tooltip>
              </v-card-actions>
            </v-card>
          </v-col>
        </v-row>
      </template>
    </v-data-iterator>
    <v-dialog v-model="to_remove" transition="dialog-bottom-transition" max-width="300" persistent>
      <template v-slot:default="dialog">
        <v-card>
          <v-card-title class="text-center text-h5">
            <v-icon color="red">bi-trash</v-icon><v-divider class="mx-4" inset vertical></v-divider> Eliminar Registro
          </v-card-title>
          <v-card-text>
            Este registro sera eliminado de forma permanente
          </v-card-text>
          <v-card-actions class="justify-space-between">
            <v-btn text color="success" @click="to_remove=false,remove_item=null"><v-icon>bi-check</v-icon> Eliminar</v-btn>
            <v-btn text @click="to_remove=false,remove_item=null"><v-icon>bi-x</v-icon> Cerrar</v-btn>
          </v-card-actions>
        </v-card>
      </template>
    </v-dialog>
  </div>
  `,
  data:()=>{return <?= json_encode($models) ?>},
  props:<?= json_encode($props['props']) ?>,
  methods:{
    Data:function(){
      axios.post('Database/render_<?=$response['template']?>/<?=$response['table']?>',{
        data:this.query,
        props:router.history.current.query
      }).then((response)=>{
        this.list = response.data
        this.$emit('loading-screen','<?=$response['codename']?>')
      })
    },
    setUrl:function(act,id){
      if(act=='remove'){
        this.to_remove = true
        this.remove_item = id
      } else {
        if(this.$root.page.active==null){
          this.$root.GetPage(this.$root.p,act,id,'page')
        } else {
          this.$root.GetPage(this.$root.p,act,id,'page')
        }
      }
    },
    generate:function(type='pdf'){
      var cols = this.export.headers;
      var doc = new jsPDF({
        orientation:'portrait',
        unit:'in',
        format:'letter'
      });
      doc.setFontSize(16).text(this.title,0.5,1.0);
      doc.setLineWidth(0.01).line(0.5,1.1,8.0,1.1);

      doc.autoTable({
        cols,
        body:this.list,
        margin:{left:0.5,top:1.25}
      });

      doc
        .setFont('times')
        .setFontSize(11)
        .setFontStyle('italic')
        .setTextColor(0,0,255)
        .text("Pie de pagina",0.5,doc.internal.pageSize.height-0.5)
        .save(this.title+'.pdf')
    },
    <?= implode(',', $methods) ?>
  },
  created(){
    document.title = this.title
    <?= implode(',', $created) ?>
  }
})