<?php
  $this->uri = service('uri');
  $pk = '';
  $map_type = [];
  $methods = [];
  $created = [];
  $card_titled = false;

  $created[] = 'this.Data()';
  $models['title'] = $response['name'];
  $models['to_remove'] = false;
  $models['remove_item'] = null;
  $models['visible'] = true;
  $models['list'] = [];
  $models['geojson'] = [];
  $models['headers'] = [];
  $models['export']['headers'] = [];
  $models['query'] = $response['query'];
  $width_action = 10;
  foreach ($response['data'] as $field) {
    $main_table = explode('.',$field['name']);
    if ($field['type'] == 'marker') {
      $latlng = $field['name'];
      $map_type[] = [
        'name'=>str_replace('.','_',$field['name']),
        'label'=>$field['label'],
        //'field'=>$field['field'],
        'type'=>$field['type']
      ];
    }
    if ($field['type'] == 'polygon') {
      $latlng = $field['name'];
      $map_type[] = [
        'name'=>str_replace('.','_',$field['name']),
        'label'=>$field['label'],
        //'field'=>$field['field'],
        'type'=>$field['type']
      ];
    }
    if ($main_table[0] == $response['table'] and $field['primary_key'] == '1') {
      $pk = $field['name'];
      $models['query']['select'][] = $field['name'];
    }
    if ($field['visible']==true) {
      $pre_width = ($field['width']/12)*100;
      $width = ($pre_width*(100-$width_action))/100;
      $models['headers'][] = [
        'text'=>"{$field['label']}",
        'sortable'=>true,
        'value'=>str_replace('.','_',$field['name'])
        //'width'=>"{$width}%"
      ];
      $models['export']['headers'][] = [
        'title'=>"{$field['label']}",
        'dataKey'=>str_replace('.','_',$field['name'])
      ];
      $models['query']['select'][] = $field['name'];
    }
  }
  $models['headers'][] = [
    'text'=>"...",
    'width'=>"{$width_action}%"
  ];

  $props['props'] = [];

  foreach ($response['props'] as $key => $value) {
    $props['props'][] = $key;
  }
?>

Vue.component('<?=$response['codename']?>',{template: `
  <div>
    <?php foreach ($map_type as $item): ?>
      <l-control position="topright" >
        <v-btn x-small color="primary" @click="visible=!visible">
          <v-icon>{{visible?'bi-eye':'bi-eye-slash'}}</v-icon>&nbsp;&nbsp;<?=$response['name']?>
        </v-btn>
      </l-control>
      <?php if ($item['type']=='marker'): ?>
        <l-marker v-for="(row,r) in list" :lat-lng="row.<?= $item['name'] ?>" v-if="row.<?= $item['name'] ?>.length>0 && visible==true" :icon="null">
          <?php foreach ($response['data'] as $fi): ?>
            <?php foreach ($response['props']['maps']['icons'] as $icon): ?>
              <?php if ($icon['field']===$fi['name']): ?>
                <l-icon v-if="row.<?= str_replace('.','_',$icon['field']) ?>==<?= $icon['value'] ?>" icon-url="<?= $icon['icon']?>"></l-icon>
              <?php endif ?>
            <?php endforeach ?>
          <?php endforeach ?>

          <l-popup :options={maxWidth:500,minWidth:350}>
            <v-row>
              <v-col cols="12" md="12">
                <v-card>
                  <?php foreach ($response['data'] as $key=>$field): ?>
                    <?php if ($field['visible']==true and $card_titled==false): ?>
                      <?php if ($field['type']=='checkbox'): ?>
                        <v-card-title>
                          <v-icon :color="row.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">
                            {{row.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}
                          </v-icon> <?=$field['label']?>
                        </v-card-title>
                      <?php elseif ($field['type']=='image'): ?>
                        <v-img :src="row.<?=str_replace('.','_',$field['name'])?>[0]?row.<?=str_replace('.','_',$field['name'])?>[0]:row.<?=str_replace('.','_',$field['name'])?>" max-width="150" contain></v-img>
                      <?php elseif ($field['type']=='file'): ?>
                        <v-card-title>
                          <v-btn color="success" fab small>
                            <v-icon>bi-download</v-icon>
                          </v-btn> <?=$field['label']?>
                        </v-card-title>
                      <?php else: ?>
                        <v-card-title>
                          {{row.<?=str_replace('.','_',$field['name'])?>}}
                        </v-card-title>
                      <?php endif ?>
                      <?php 
                        $card_titled=true;
                        unset($response['data'][$key]);
                      ?>
                    <?php endif ?>
                  <?php endforeach ?>
                  <v-card-text>
                    <v-row>
                      <?php foreach ($response['data'] as $field): ?>
                        <?php if ($field['visible']==true and $field['hidden']==false): ?>
                          <?php
                            $pre_width = ($field['width']/12)*100;
                            $width = round($pre_width,0);
                            if ($field['filter']==''){
                              $filter = '';
                            }elseif($field['filter']==null){
                              $filter = '';
                            }else {
                              $filter = " | {$field['filter']}";
                            }
                          ?>
                          <?php if ($field['type']=='checkbox'): ?>
                            <v-col cols="12" :md="<?= $field['width'] ?>">
                              <v-icon :color="row.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">
                                {{row.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}
                              </v-icon>
                            </v-col>
                          <?php elseif ($field['type']=='image'): ?>
                            <v-col cols="12" :md="<?= $field['width'] ?>">
                              <v-img :src="row.<?=str_replace('.','_',$field['name'])?>[0]?row.<?=str_replace('.','_',$field['name'])?>[0]:row.<?=str_replace('.','_',$field['name'])?>" max-width="150" contain></v-img>
                            </v-col>
                          <?php elseif ($field['type']=='file'): ?>
                            <v-col cols="12" :md="<?= $field['width'] ?>">
                              <v-icon :color="row.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">
                                {{row.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}
                              </v-icon>
                            </v-col>
                          <?php else: ?>
                            <v-col cols="12" :md="<?= $field['width'] ?>">
                              <dt><strong><?=$field['label']?><?= $field['hidden']?></strong></dt>
                              <dd>{{row.<?=str_replace('.','_',$field['name'])?><?=$filter?>}}</dd>
                            </v-col>
                          <?php endif ?>
                        <?php endif ?>
                      <?php endforeach ?>
                    </v-row>
                  </v-card-text>
                  <v-card-actions class="justify-space-between">
                    <v-tooltip bottom color="teal" v-if="view">
                      <template v-slot:activator="{ on, attrs }">
                        <v-btn
                          @click="$root.Url($root.url.c+'-'+view,row.<?=str_replace('.','_',$pk)?>,'page')"
                          color="teal"
                          v-bind="attrs"
                          v-on="on"
                          fab
                          x-small
                          dark
                        >
                          <v-icon>bi bi-eye</v-icon>
                        </v-btn>
                      </template>
                      <span>Ver Detalles</span>
                    </v-tooltip>

                    <v-tooltip bottom color="indigo" v-if="update">
                      <template v-slot:activator="{ on, attrs }">
                        <v-btn
                          @click="$root.Url($root.url.c+'-'+update,row.<?=str_replace('.','_',$pk)?>,'page')"
                          color="indigo"
                          v-bind="attrs"
                          v-on="on"
                          fab
                          x-small
                          dark
                        >
                          <v-icon>bi-pencil-square</v-icon>
                        </v-btn>
                      </template>
                      <span>Editar</span>
                    </v-tooltip>

                    <v-tooltip bottom color="red" v-if="remove">
                      <template v-slot:activator="{ on, attrs }">
                        <v-btn
                          @click="$root.Url($root.url.c+'-'+'remove',row.<?=str_replace('.','_',$pk)?>,'page')"
                          color="red"
                          v-bind="attrs"
                          v-on="on"
                          fab
                          x-small
                          dark
                        >
                          <v-icon>bi-trash</v-icon>
                        </v-btn>
                      </template>
                      <span>Eliminar</span>
                    </v-tooltip>
                  </v-card-actions>
                </v-card>
              </v-col>
            </v-row>
          </l-popup>
        </l-marker>
      <?php endif ?>
      <?php if ($item['type']=='polygon'): ?>
        <l-polygon v-for="(row,r) in list" :lat-lngs="row.<?= $item['name'] ?>" v-if="row.<?= $item['name'] ?>.length>0 && visible==true" :fill-color="$root.randomColor(row.<?= $item['name'] ?>)" :color="$root.randomColor(row.<?= $item['name'] ?>)" :fill-opacity="0.4">
          <l-popup :options={maxWidth:500,minWidth:350}>
            <v-row>
              <v-col cols="12" md="12">
                <v-card>
                  <?php foreach ($response['data'] as $key=>$field): ?>
                    <?php if ($field['visible']==true and $card_titled==false): ?>
                      <?php if ($field['type']=='checkbox'): ?>
                        <v-card-title>
                          <v-icon :color="row.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">
                            {{row.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}
                          </v-icon> <?=$field['label']?>
                        </v-card-title>
                      <?php elseif ($field['type']=='image'): ?>
                        <v-img :src="row.<?=str_replace('.','_',$field['name'])?>[0]?row.<?=str_replace('.','_',$field['name'])?>[0]:row.<?=str_replace('.','_',$field['name'])?>" max-width="150" contain></v-img>
                      <?php elseif ($field['type']=='file'): ?>
                        <v-card-title>
                          <v-btn color="success" fab small>
                            <v-icon>bi-download</v-icon>
                          </v-btn> <?=$field['label']?>
                        </v-card-title>
                      <?php else: ?>
                        <v-card-title>
                          {{row.<?=str_replace('.','_',$field['name'])?><?=$filter?>}}
                        </v-card-title>
                      <?php endif ?>
                      <?php 
                        $card_titled=true;
                        unset($response['data'][$key]);
                      ?>
                    <?php endif ?>
                  <?php endforeach ?>
                  <v-card-text>
                    <v-row>
                      <?php foreach ($response['data'] as $field): ?>
                        <?php if ($field['visible']==true && $field['hidden']==false): ?>
                          <?php
                            $pre_width = ($field['width']/12)*100;
                            $width = round($pre_width,0);
                            if ($field['filter']==''){
                              $filter = '';
                            }elseif($field['filter']==null){
                              $filter = '';
                            }else {
                              $filter = " | {$field['filter']}";
                            }
                          ?>
                          <?php if ($field['type']=='checkbox'): ?>
                            <v-col cols="12" :md="<?= $field['width'] ?>">
                              <v-icon :color="row.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">
                                {{row.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}
                              </v-icon>
                            </v-col>
                          <?php elseif ($field['type']=='image'): ?>
                            <v-col cols="12" :md="<?= $field['width'] ?>">
                              <v-img :src="row.<?=str_replace('.','_',$field['name'])?>[0]?row.<?=str_replace('.','_',$field['name'])?>[0]:row.<?=str_replace('.','_',$field['name'])?>" max-width="150" contain></v-img>
                            </v-col>
                          <?php elseif ($field['type']=='file'): ?>
                            <v-col cols="12" :md="<?= $field['width'] ?>">
                              <v-icon :color="row.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">
                                {{row.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}
                              </v-icon>
                            </v-col>
                          <?php else: ?>
                            <v-col cols="12" :md="<?= $field['width'] ?>">
                              <dt><strong><?=$field['label']?> </strong></dt>
                              <dd>{{row.<?=str_replace('.','_',$field['name'])?><?=$filter?>}}</dd>
                            </v-col>
                          <?php endif ?>
                        <?php endif ?>
                      <?php endforeach ?>
                    </v-row>
                  </v-card-text>
                  <v-card-actions class="justify-space-between">
                    <v-tooltip bottom color="teal" v-if="view">
                      <template v-slot:activator="{ on, attrs }">
                        <v-btn
                          @click="$root.Url($root.url.c+'-'+view,row.<?=str_replace('.','_',$pk)?>,'page')"
                          color="teal"
                          v-bind="attrs"
                          v-on="on"
                          fab
                          x-small
                          dark
                        >
                          <v-icon>bi bi-eye</v-icon>
                        </v-btn>
                      </template>
                      <span>Ver Detalles</span>
                    </v-tooltip>

                    <v-tooltip bottom color="indigo" v-if="update">
                      <template v-slot:activator="{ on, attrs }">
                        <v-btn
                          @click="$root.Url($root.url.c+'-'+update,row.<?=str_replace('.','_',$pk)?>,'page')"
                          color="indigo"
                          v-bind="attrs"
                          v-on="on"
                          fab
                          x-small
                          dark
                        >
                          <v-icon>bi-pencil-square</v-icon>
                        </v-btn>
                      </template>
                      <span>Editar</span>
                    </v-tooltip>

                    <v-tooltip bottom color="red" v-if="remove">
                      <template v-slot:activator="{ on, attrs }">
                        <v-btn
                          @click="$root.Url($root.url.c+'-'+'remove',row.<?=str_replace('.','_',$pk)?>,'page')"
                          color="red"
                          v-bind="attrs"
                          v-on="on"
                          fab
                          x-small
                          dark
                        >
                          <v-icon>bi-trash</v-icon>
                        </v-btn>
                      </template>
                      <span>Eliminar</span>
                    </v-tooltip>
                  </v-card-actions>
                </v-card>
              </v-col>
            </v-row>
          </l-popup>
        </l-polygon>
      <?php endif ?>
    <?php endforeach ?>
    <v-dialog v-model="to_remove" transition="dialog-bottom-transition" max-width="300" persistent>
      <template v-slot:default="dialog">
        <v-card>
          <v-card-title class="text-center text-h5">
            <v-icon color="red">bi-trash</v-icon><v-divider class="mx-4" inset vertical></v-divider> Eliminar Registro
          </v-card-title>
          <v-card-text>
            Este registro sera eliminado de forma permanente
          </v-card-text>
          <v-card-actions class="justify-space-between">
            <v-btn text color="success" @click="to_remove=false,remove_item=null"><v-icon>bi-check</v-icon> Eliminar</v-btn>
            <v-btn text @click="to_remove=false,remove_item=null"><v-icon>bi-x</v-icon> Cerrar</v-btn>
          </v-card-actions>
        </v-card>
      </template>
    </v-dialog>
  </div>
  `,
  data:()=>{return <?= json_encode($models) ?>},
  props:<?= json_encode($props['props']) ?>,
  computed: {
    geojsonOptions:function(props=null){
      return {
        onEachFeature: (feature, layer) => {
          let props = Object.keys(feature.properties)
          let template = ''
          if(props.length>0){
            props.forEach((prop)=>{
            template += `<div><strong>${prop}:</strong> ${feature.properties[prop]}</div>`
            })
            layer.on('click', function (e) {
              console.log(e.target.feature.properties)
            });
            layer.bindTooltip(template,{ permanent: false, sticky: true });
          }
        }
      };
    }
  },
  methods:{
    Data:function(){
      axios.post('Database/render_<?=$response['template']?>/<?=$response['table']?>',{
        data:this.query,
        props:router.history.current.query
      }).then((response)=>{
        this.list = response.data
        this.$emit('loading-screen','<?=$response['codename']?>')
      })
    },
    setUrl:function(act,id){
      if(act=='remove'){
        this.to_remove = true
        this.remove_item = id
      } else {
        if(this.$root.page.active==null){
          this.$root.GetPage(this.$root.p,act,id,'page')
        } else {
          this.$root.GetPage(this.$root.p,act,id,'page')
        }
      }
    },
    RenderIcon:function(){
      var self = this
      this.maps.icons.forEach(function(icon){
        self.list.forEach(function(field){
          if(eval(field[icon.field.replace(/\./g,'_')]+'=='+icon.value)==true){
            return icon.icon
          }
          return 'public/theme/images/image-default.svg'
        })
      })
    },
    geojsonOption:function(main_props){
      var self = this 
      return {
        style: (feature) => {
          return {
            fillColor: main_props.color?main_props.color:this.$root.randomColor(feature.properties.id),
            weight: 2,
            opacity: 1,
            color: '#3b3b3b',
            dashArray: '3',
            fillOpacity: 0.7
          }
        },
        onEachFeature: (feature, layer) => {
          let props = Object.keys(feature.properties)
          let template = ''
          if(props.length>0 && main_props.tooltip){
            props.forEach((prop)=>{
            template += `<div><strong>${prop}:</strong> ${feature.properties[prop]}</div>`
            })
            layer.on('click', function (e) {
              self.$root.GetPage(self.$root.p,main_props.screen,feature.properties[main_props.id],'page')
            });
            layer.bindTooltip(template,{ permanent: false, sticky: true });
          }
        }
      };
    },
    generate:function(type='pdf'){
      var cols = this.export.headers;
      var doc = new jsPDF({
        orientation:'portrait',
        unit:'in',
        format:'letter'
      });
      doc.setFontSize(16).text(this.title,0.5,1.0);
      doc.setLineWidth(0.01).line(0.5,1.1,8.0,1.1);

      doc.autoTable({
        cols,
        body:this.list,
        margin:{left:0.5,top:1.25}
      });

      doc
        .setFont('times')
        .setFontSize(11)
        .setFontStyle('italic')
        .setTextColor(0,0,255)
        .text("Pie de pagina",0.5,doc.internal.pageSize.height-0.5)
        .save(this.title+'.pdf')
    },
    <?= implode(',', $methods) ?>
  },
  created(){
    document.title = this.title
    this.json_data = null
    this.maps.geojson.forEach((value,index)=>{
      this.json_props = {
        color: value.color,
        id: value.id,
        screen: value.screen,
        tooltip: value.tooltip,
      }
      axios.get(value.path).then((response)=>{
        this.geojson.push({... {data:response.data,props:this.json_props} })
      })
    })

    if(!this.maps){
      this.maps = {"center":{"lat":6.795535,"lng":-64.379883},"zoom":5,"layers":["https:\/\/{s}.tile.openstreetmap.org\/{z}\/{x}\/{y}.png"]}
    }
    <?= implode(',', $created) ?>
  }
})