<?php
$db = db_connect();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title><?=env('APP_NAME')?></title>
  <meta name="description" content="The small framework with powerful features">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
  <link rel="shortcut icon" type="image/png" href="/favicon.ico" />
  <!-- Favicons -->
  <link href="<?= base_url('public/theme') ?>/assets/img/favicon.png" rel="icon">
  <link href="<?= base_url('public/theme') ?>/assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Vendor CSS Files -->
  <link href="<?= base_url('public/theme') ?>/assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/css/icon-ui.css" rel="stylesheet">

  <!--link href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900" rel="stylesheet"-->
  <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.x/css/materialdesignicons.min.css" rel="stylesheet">
  <link href="<?= base_url('public/theme/vue') ?>/css/vuetify.min.css" rel="stylesheet">
  <link rel="stylesheet" href="<?= base_url('public/theme/leaflet') ?>/leaflet.css" />
  <script src="<?= base_url('public/theme/leaflet') ?>/leaflet.js"></script>


  <script src="<?= base_url('public/theme/vue/vue.js') ?>"></script>
  <script src="<?= base_url('public/theme/vue/axios.min.js') ?>"></script>

  <script src="<?= base_url('public/plugins/jspdf.min.js') ?>"></script>
  <script src="<?= base_url('public/plugins/jspdf.plugin.autotable.js') ?>"></script>

  <script src="<?= base_url('public/plugins/echart.js') ?>"></script>
  <script src="<?= base_url('public/plugins/vue-echarts.js') ?>"></script>

  <?php
  $js_folder = "public/theme/vue/js";
  $files = array_diff(scandir(FCPATH . "/{$js_folder}"), array('.', '..'));
  ?>
  <?php foreach ($files as $filename): ?>
  <script src="<?= base_url("{$js_folder}/{$filename}") ?>"></script>
  <?php endforeach ?>

  <script src="<?= base_url('public/node_modules/ckeditor4/ckeditor.js') ?>"></script>
  <script src="<?= base_url('public/node_modules/ckeditor4-vue/dist/ckeditor.js') ?>"></script>
  <script>
    const router = new VueRouter({
      mode: 'history',
      base: '',
      routes: []
    })
    //window.Vue2Transitions
    //Vue.use(Vue2Transitions)
  </script>
  <?php
    $components_folder = FCPATH . "/public/components";
    $files = array_diff(scandir($components_folder), array('.', '..'));
    $components = [];
    $components['security'] = 'security';
  ?>
  <?php foreach ($files as $filename): ?>
  <script src="<?= base_url("public/components/{$filename}") ?>"></script>
  <?php endforeach ?>
  <?php
    $security = $db->table('sys_settings')->where('key','security')->get()->getRowArray();
    $dec_security = json_decode($security['config'], true);
    unset($dec_security['table']);
    $files = $db->table('sys_component')->get()->getResultArray();
    $files_el = $db->table('sys_element')->get()->getResultArray();
  ?>
  <?php foreach ($files as $filename): ?>
  <?php $components[$filename['codename']] = $filename['codename'] ?>
  <?php endforeach ?>
  <script src="<?= base_url("Module/render_global") ?>"></script>

  <?php foreach ($files_el as $filename): ?>
  <?php $components[$filename['codename']] = $filename['codename'] ?>
  <?php endforeach ?>
  <script src="<?= base_url("Module/render_global/element") ?>"></script>

  <!-- Template Main CSS File -->
</head>

<body>
  <div id="app">
    <v-app>
      <v-navigation-drawer :color="settings.interface.config.sidebar.color" :dark="settings.interface.config.sidebar.dark" :light="!settings.interface.config.sidebar.dark" v-model="sidebar" app>
        <v-list-item>
          <v-list-item-content>
            <v-list-item-title class="text-h6">
              {{title}}
            </v-list-item-title>
            <v-list-item-subtitle>
              MENU
            </v-list-item-subtitle>
          </v-list-item-content>
        </v-list-item>
        <v-divider></v-divider>
        <v-list dense nav>
          <div v-for="item in modules">
            <v-list-group v-if="item.slug==''" :key="item.title" v-model="item.active" :prepend-icon="item.icon" active-class="white--text" no-action>
              <template v-slot:activator>
                <v-list-item-content>{{item.title}}</v-list-item-content>
              </template>

              <v-list-item v-for="child in item.items" :key="child.title" @click="Url(child.slug+'-'+child.active,null,'page')">
                <v-list-item-icon>
                  <v-icon>{{child.icon}}</v-icon>
                </v-list-item-icon>
                <v-list-item-content>
                  {{child.title}}
                </v-list-item-content>
              </v-list-item>
            </v-list-group>
            <v-list-item v-else link @click="Url(item.slug+'-'+item.active,null,'page')">
              <v-list-item-icon>
                <v-icon>{{item.icon}}</v-icon>
              </v-list-item-icon>
              <v-list-item-content>{{item.title}}</v-list-item-content>
            </v-list-item>
          </div>
        </v-list>
        <!--template v-slot:append>
          <div class="pa-2">
            <v-btn block outlined color="teal" @click="RefreshDatabase()">
              REFRESH DATABASE
            </v-btn>
          </div>
        </template-->
      </v-navigation-drawer>

      <v-main app class="mb-5">
        <v-toolbar :color="settings.interface.config.nav.color" :dark="settings.interface.config.nav.dark" :light="!settings.interface.config.nav.dark">
          <v-app-bar-nav-icon @click="sidebar = !sidebar" app></v-app-bar-nav-icon>
          <v-img :src="settings.interface.config.logo.file" contain :width="settings.interface.config.logo.width" :height="settings.interface.config.logo.height"></v-img>
          <v-toolbar-title>
            {{title}}
          </v-toolbar-title>
          <v-spacer></v-spacer>
          <v-btn icon v-for="(item,i) in menu" :key="item.slug" @click="Url(item.slug);loader.component=item.slug==url.c?false:true">
            <v-icon>{{ item.icon }}</v-icon>
          </v-btn>
          <v-menu top>
            <template v-slot:activator="{ on, attrs }">
              <v-btn fab small color="primary" v-bind="attrs" v-on="on">
                {{i18n.locale}}
              </v-btn>
            </template>
            <v-list>
              <v-list-item v-for="language in settings.languages" link @click="$i18n.locale=language.value">
                <list-item-title>
                  {{language.label}}
                  </v-list-item-title>
              </v-list-item>
            </v-list>
          </v-menu>
          <?php if($security['value']=='true'): ?>
            <!--message-button :current_setting="settings.security.config.fields" :current_session="session"></message-button-->
            <v-menu bottom origin="center center" transition="scale-transition">
              <template v-slot:activator="{ on, attrs }">
                <v-btn fab small color="cyan" v-bind="attrs" v-on="on" class="ml-2">
                  <v-icon>ri-user-3-line</v-icon>
                </v-btn>
              </template>
              <v-card
                  class="mx-auto"
                  tile
                >
                <v-list nav dense>
                  <v-list-item>
                    <v-list-item-content>
                      <v-list-item-title class="text-h6" v-if="session.<?= $dec_security['fields']['name'] ?>">
                        {{session.<?= $dec_security['fields']['name'] ?>}}
                        <?php $dec_security['fields']['name'] ?>
                      </v-list-item-title>
                      <v-list-item-subtitle v-if="session.<?= $dec_security['fields']['email'] ?>">
                        {{session.<?= $dec_security['fields']['email'] ?>}}
                      </v-list-item-subtitle>
                      <v-list-item-subtitle v-if="session.<?= $dec_security['fields']['role'] ?>">
                      <?= ucfirst($dec_security['fields']['role']) ?>: {{session.<?= $dec_security['fields']['role'] ?>}}
                      </v-list-item-subtitle>
                    </v-list-item-content>
                    <v-list-item-action>
                    <v-btn fab x-small color="primary">
                      <v-icon>ri-user-settings-line</v-icon>
                    </v-btn>
                    </v-list-item-action>
                  </v-list-item>
                </v-list>
                <v-divider></v-divider>
                <v-list nav dense>
                  <v-list-item-group color="error">
                    <v-list-item link @click="CloseSession()">
                      <v-list-item-icon>
                        <v-icon>ri-shut-down-line</v-icon>
                      </v-list-item-icon>

                      <v-list-item-content>
                        <v-list-item-title>CERRAR SESION</v-list-item-title>
                      </v-list-item-content>
                    </v-list-item>
                  </v-list-item-group>
                </v-list>
                </v-card>
            </v-menu>
          <?php endif ?>
        </v-toolbar>
        <v-container fluid class="mb-5" v-if="url.t==''">
          <component :is="url.c" @loading-screen="showLoader" v-show="!loader.component"></component>
          <v-row v-show="loader.component">
            <v-col cols="12">
              <v-skeleton-loader type="card-avatar, article, actions"></v-skeleton-loader>
            </v-col>
          </v-row>
        </v-container>
        <v-container  v-if="url.t=='page'" fluid class="mb-5">
          <component is="render-post" :page="url.content"></component>
        </v-container>
        <v-toast ref="toast"/>
      </v-main>
    </v-app>
  </div>

  <script>
    Vue.filter('capitalize', function (value) {
      if (!value) return ''
      value = value.toString()
      return value.charAt(0).toUpperCase() + value.slice(1)
    })
    Vue.filter('decimals', function (value) {
      if (!value) return ''
      return Number(value).toFixed(2)
    })
    Vue.filter('filesize', function (value) {
      if (value < 1024) return value + ' B'
      let i = Math.floor(Math.log(value) / Math.log(1024))
      let num = (value / Math.pow(1024, i))
      let round = Math.round(num)
      num = round < 10 ? num.toFixed(2) : round < 100 ? num.toFixed(1) : round
      return `${num} ${'KMGTPEZY'[i - 1]}B`
    })
    Vue.filter('date', function (value) {
      if (!value) return ''
      let date_time = value.split(' ');
      let date = date_time[0]
      let time = date_time[1]
      let new_date = date.split('-')
      return new_date[2] + '/' + new_date[1] + '/' + new_date[0]
    })
    Vue.filter('truncate', function (value, length, suffix) {
      if (!value) return ''
      if (value.length > length) {
        return value.substring(0, length) + suffix;
      } else {
        return value
      }
    })

    Vue.component('l-map', window.Vue2Leaflet.LMap);
    Vue.component('l-tile-layer', window.Vue2Leaflet.LTileLayer);
    Vue.component('l-marker', window.Vue2Leaflet.LMarker);
    Vue.component('l-icon', window.Vue2Leaflet.LIcon);
    Vue.component('l-popup', window.Vue2Leaflet.LPopup);
    Vue.component('l-tooltip', window.Vue2Leaflet.LTooltip);
    Vue.component('l-polygon', window.Vue2Leaflet.LPolygon);
    Vue.component('l-geo-json', window.Vue2Leaflet.LGeoJson);
    Vue.component('l-control', window.Vue2Leaflet.LControl);
    Vue.component('l-control-layers', window.Vue2Leaflet.LControlLayers);
    Vue.component('v-chart', window.VueECharts);
    Vue.use(VueGoogleMaps, {
      load: {
        region: 'PE',
        language: 'es',
        key: 'AIzaSyAb0HPDY2-MrV4K_CtjvIfBkAfBldMPdJE',
        libraries: 'places'
      }
    })

    Vue.use(CKEditor);
    //CKEDITOR.config.fullPage = true;
    CKEDITOR.config.allowedContent = true;
    CKEDITOR.config.extraPlugins = 'base64image';
    CKEDITOR.config.removePlugins = 'about,image';
  </script>
  <script>
    const messages = {
      en: {
        action: {
          create: 'Create',
          list: 'List',
          add: 'Add',
          read:'List',
          view: 'Details',
          delete: 'Delete',
          update: 'Update',
          open: 'Open',
          close: 'Close',
          save: 'Save',
          search: 'Search',
          setting: 'Setting',
          loading: 'Loading',
        },
        section: {
          module: 'Module',
          component: 'Component',
          element: 'Element',
          record: 'Record',
          section: 'Section'
        },
        module:{
          database:'Database',
          component:'Components',
          module:'Modules',
          settings:'Settings',
          importer:'Importer',
        },
        form: {
          response:{
            success:"Success!"
          }
        },
        status:{
          active:"Active",
          inactive:"Inactive"
        },
        alert: {
          delete: "This {el} will be permanently removed"
        }
      },
      es: {
        action: {
          create: 'Crear',
          list:'Listado',
          add: 'Agregar',
          read:'Listado',
          view: 'Detalles',
          delete: 'Eliminar',
          update: 'Actualizar',
          open: 'Abrir',
          close: 'Cerrar',
          save: 'Guardar',
          search: 'Buscar',
          setting: 'Ajuste',
          loading: 'Cargando',
        },
        section: {
          module: 'Modulo',
          component: 'Componente',
          element: 'Elemento',
          record: 'Registro',
          section: 'Seccion'
        },
        module:{
          database:'Base de Datos',
          component:'Componentes',
          module:'Modulos',
          settings:'Ajustes',
          importer:'Importar Data',
        },
        form: {
          response:{
            success:"Éxito!"
          }
        },
        status:{
          active:"Activo",
          inactive:"Inactivo"
        },
        alert: {
          delete: "Este {el} sera eliminado de forma permanente"
        }
      }
    }
    const i18n = new VueI18n({
      locale: 'es',
      messages
    })
  </script>
  <script>
    var app = new Vue({
      router,
      i18n,
      el: "#app",
      vuetify: new Vuetify(),
      data: {
        title: "<?=env('APP_NAME')?>",
        session: '',
        menu: [],
        modules: [],
        url:{
          c:'',
          d:false,
          id:'',
          t:'',
          content:'',
          permission:[]
        },
        page:{
          active:''
        },
        loader:{
          page:true,
          component:true
        },
        sidebar: false,
        footerbar: false,
        settings: {
          languages: [
            {
              label: 'English',
              value: 'en'
            },
            {
              label: 'Spanish',
              value: 'es'
            }
          ],
          interface:{
            value:false,
            config:{"nav":{"color":"purple darken-4","style":[],"dark":true},"sidebar":{"color":"purple lighten-4","style":[],"dark":true},"logo":{"file":"", "width":null, "height":null },"session":{"color":"purple darken-4","style":{"background":"linear-gradient(135deg, #9C27B0 0%,#009688 100%)"},"dark":true}}
          },
          security:{
            value:false,
            config:{"table":null,"allow_register":true,"fields":{"id":null,"role":null,"name":null,"user":null,"email":null,"password":null}}
          }
        },
        dark_mode: true,
        t_key: 1
      },
      watch: {
        $route(to, from) {
          if (to.hash) {
            var hash = to.hash.replace('#','')
            var hash_split = hash.split('-')
            if (hash_split[hash_split.length-1]=='page') {
              this.url.t = hash_split[hash_split.length-1]
              hash_split.pop()
              if (hash_split[hash_split.length-1]=='ID') {
                hash_split.pop()
                this.url.id = hash_split[hash_split.length-1]
                hash_split.pop()
              } else if(!isNaN(hash_split[hash_split.length-1])) {
                this.url.id = hash_split[hash_split.length-1]
                hash_split.pop()
              } else {
                this.url.id=''
              }
              this.page.active = hash_split[hash_split.length-1]
              hash_split.pop()

            } else {
              this.url.t = ''
              if (hash_split[hash_split.length-1]=='ID') {
                hash_split.pop()
                this.url.id = hash_split[hash_split.length-1]
                hash_split.pop()
              } else if(!isNaN(hash_split[hash_split.length-1])) {
                this.url.id = hash_split[hash_split.length-1]
                hash_split.pop()
              } else {
                this.url.id=''
              }
            }

            this.url.c = hash_split.join('-')
          } else {
            this.url.c = 'home'
          }
          if (this.url.t) {
            this.Page(this.url.c)
          } else {
            this.loader.component = true
          }
          this.Permission(this.url.c)
        }
      },
      methods: {
        GetSession: function () {
          axios.post('Session').then((response) => {
            this.session = response.data
          })
        },
        CloseSession: function () {
          axios.post('Session/LogOut')
          .then((res) => {
            window.location = '<?=site_url()?>'
          })
        },
        GenerateID: function (type = 'alnum', len = 8) {
          var charset = "";
          if (type == "alpha") {
            charset += "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
          }
          if (type == "alnum") {
            charset += "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            charset += "0123456789";
          }
          if (type == "numeric") {
            charset += "0123456789";
          }
          var ret = "";
          for (var i = 0, n = charset.length; i < len; ++i) {
            ret += charset.charAt(Math.floor(Math.random() * n));
          }
          return ret;
        },
        randomColor:function(seed=1,b=50) {
          Math.seedrandom(seed)
          var color
          do {
            var red = Math.floor(Math.random()*256)
            var green = Math.floor(Math.random()*256)
            var blue = Math.floor(Math.random()*256)

            var brightness = Math.sqrt((red*red*0.299)+(green*green*0.587)+(blue*blue*0.114))
          } while (brightness<b) {

          }
          var hexCode = red.toString(16)+green.toString(16)+blue.toString(16)
          hexCode = hexCode.padStart(6,'0')
          return '#'+hexCode
        },
        GetMenu: function(){
          axios.post('Menu/get/nav/admin').then((response) => {
            this.menu = response.data
          })
          axios.post('Menu/get/left/admin').then((response) => {
            this.modules = response.data
          })
        },
        DarkMode: function (onoff) {
          this.$vuetify.theme.dark = onoff
        },
        Url: function (c, id, t) {
          var path_init = {}
          var segments = []
          if (c) {
            segments.push(c)
          }
          if (id) {
            segments.push(id)
            if (isNaN(id)) {
              segments.push('ID')
            }
          }
          if (t) {
            segments.push(t)
          }

          var hash = segments.join('-')
          this.t_key = hash
          router.push({ query: path_init,hash:hash }).catch(() => { })
        },
        Page: function (c, id, t) {
          axios.post('Post/get',{
            where:{
              slug:this.url.c
            },
            result:'row'
          }).then((res) => {
            this.url.content = res.data
            this.title = res.data.title
          })
        },
        RefreshDatabase: function () {
          axios.post('Database/refresh_database').then((res) => {
            this.toast.show({
              message:res.status==200?"DDBB restaurada.":"No se pudo restaurar la DDBB.",
              color:res.status==200?'success':'orange',
              icon:'bi-info-circle',
              system:true
            })
            this.GetSession();
            this.GetMenu();
            this.Permission();
            axios.post('Settings/get/interface').then((response) => {
              this.settings.interface = response.data
            })
          })
        },
        Permission: function (p) {
          axios.post('Menu/permission/'+p+'').then((res) => {
            this.url.permission = res.data
          })
        },
        showLoader:function(t){
          if (t==false) {
            this.loader.component = false
          } else {
            this.loader.component = true
          }
          if (this.$refs.toast) {
            this.$root.toast.show({
              message:this.loader.component?"Cargando, Por favor espere.":"Carga completada.",
              color:this.loader.component?'orange':'success',
              icon:'bi-info-circle',
              system:true
            })
          }
        },
      },
      created: function () {
        this.GetSession()
        this.$vuetify.theme.dark = this.settings.interface.value
        this.GetMenu()
        var to = this.$route;
        if (to.hash) {
          var hash = to.hash.replace('#','')
          var hash_split = hash.split('-')
          if (hash_split[hash_split.length-1]=='page') {
            this.url.t = hash_split[hash_split.length-1]
            hash_split.pop()
            if (hash_split[hash_split.length-1]=='ID') {
              hash_split.pop()
              this.url.id = hash_split[hash_split.length-1]
              hash_split.pop()
            } else if(!isNaN(hash_split[hash_split.length-1])) {
              this.url.id = hash_split[hash_split.length-1]
              hash_split.pop()
            } else {
              this.url.id=''
            }
            this.page.active = hash_split[hash_split.length-1]
            hash_split.pop()

          } else {
            this.url.t = ''
            if (hash_split[hash_split.length-1]=='ID') {
              hash_split.pop()
              this.url.id = hash_split[hash_split.length-1]
              hash_split.pop()
            } else if(!isNaN(hash_split[hash_split.length-1])) {
              this.url.id = hash_split[hash_split.length-1]
              hash_split.pop()
            } else {
              this.url.id=''
            }
          }

          this.url.c = hash_split.join('-')
        } else {
          this.url.c = 'home'
        }
        if (this.url.t) {
          this.Page(this.url.c)
        }
        this.Permission(this.url.c)
        axios.post('Settings/get/interface').then((response) => {
          this.settings.interface = response.data
        })
        axios.post('Settings/get/security').then((response) => {
          this.settings.security = response.data
        })
        document.title = this.title
      },
      mounted() {
        this.toast = this.$refs.toast
      },
    })
  </script>
</body>

</html>