<?php
$db = db_connect();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title><?=env('APP_NAME')?></title>
  <meta name="description" content="The small framework with powerful features">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
  <!--link rel="shortcut icon" type="image/png" href="/favicon.ico" /-->
  <!-- Favicons -->
  <!--link href="<?= base_url('public/theme') ?>/assets/img/favicon.png" rel="icon"-->
  <!--link href="<?= base_url('public/theme') ?>/assets/img/apple-touch-icon.png" rel="apple-touch-icon"-->

  <!-- Vendor CSS Files -->
  <link href="<?= base_url('public/theme') ?>/assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/vendor/remixicon/remixicon.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/css/icon-ui.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/assets/css/custom-css.css" rel="stylesheet">

  <!--link href="https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900" rel="stylesheet"-->
  <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.x/css/materialdesignicons.min.css" rel="stylesheet">
  <link href="<?= base_url('public/theme') ?>/vue/css/vuetify.min.css" rel="stylesheet">
  <link rel="stylesheet" href="<?= base_url('public/theme/leaflet') ?>/leaflet.css" />
  <script src="<?= base_url('public/theme/leaflet') ?>/leaflet.js"></script>

  <!-- Favicon -->
  <link href="<?= base_url('public/theme') ?>/web_assets/img/favicon.ico" rel="shortcut icon">



  <!-- Icon Font Stylesheet -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

  <script src="<?= base_url('public/theme/vue/vue.js') ?>"></script>
  <script src="<?= base_url('public/theme/vue/axios.min.js') ?>"></script>

  <script src="<?= base_url('public/plugins/jspdf.min.js') ?>"></script>
  <script src="<?= base_url('public/plugins/jspdf.plugin.autotable.js') ?>"></script>

  <script src="<?= base_url('public/plugins/echart.js') ?>"></script>
  <script src="<?= base_url('public/plugins/vue-echarts.js') ?>"></script>

  <?php
  $js_folder = "public/theme/vue/js";
  $files = array_diff(scandir(FCPATH . "/{$js_folder}"), array('.', '..'));
  ?>
  <?php foreach ($files as $filename): ?>
  <script src="<?= base_url("{$js_folder}/{$filename}") ?>"></script>
  <?php endforeach ?>

  <script src="<?= base_url('public/node_modules/ckeditor4/ckeditor.js') ?>"></script>
  <script src="<?= base_url('public/node_modules/ckeditor4-vue/dist/ckeditor.js') ?>"></script>
  <script>
    const router = new VueRouter({
      mode: 'history',
      base: '',
      routes: []
    })
    //window.Vue2Transitions
    //Vue.use(Vue2Transitions)
  </script>
  <?php
    $components_folder = FCPATH . "/public/components";
    $files = array_diff(scandir($components_folder), array('.', '..'));
    $components = [];
    $components['security'] = 'security';
  ?>
  <?php foreach ($files as $filename): ?>
  <script src="<?= base_url("public/components/{$filename}") ?>"></script>
  <?php endforeach ?>
  <?php
    $security = $db->table('sys_settings')->where('key','security')->get()->getRowArray();
    $dec_security = json_decode($security['config'], true);
    unset($dec_security['table']);
    $files = $db->table('sys_component')->get()->getResultArray();
    $files_el = $db->table('sys_element')->get()->getResultArray();
  ?>
  <?php foreach ($files as $filename): ?>
    <?php $components[$filename['codename']] = $filename['codename'] ?>
  <?php endforeach ?>
  <script src="<?= base_url("Module/render_global") ?>"></script>

  <?php foreach ($files_el as $filename): ?>
    <?php $components[$filename['codename']] = $filename['codename'] ?>
  <?php endforeach ?>
  <script src="<?= base_url("Module/render_global/element") ?>"></script>

  <style>

    .bounce {
      animation: bounce2 2s ease infinite;
    }
    @keyframes bounce2 {
      0%, 20%, 50%, 80%, 100% {transform: translateY(0);}
      40% {transform: translateY(-30px);}
      60% {transform: translateY(-15px);}
    }

    .pattern-wave{
      background-color: #fff;
      opacity: 0.8;
      background-image:  repeating-radial-gradient( circle at 0 0, transparent 0, #fff 10px ), repeating-linear-gradient( #f2f2f255, #f2f2f2 );
    }
  </style>
  <!-- Template Main CSS File -->
</head>

<body>
  <div id="app">
    <v-app>
      <v-fade-transition>
        <v-app-bar fixed :color="loader.scroll>0?'rgb(255,255,255)':'transparent'" :height="100" tile flat :dark="loader.scroll>0 || url.c!=='home'?false:true">

          <v-scale-transition leave-absolute="true" v-if="settings.interface.config.logo.file">
            <img v-show="loader.scroll==0" :src="url.c=='home'?settings.interface.config.logo.file:settings.interface.config.logo.variant" height="35vh" @click="Url('home')">
          </v-scale-transition>
          <v-scale-transition v-if="settings.interface.config.logo.variant">
            <img v-show="loader.scroll>0" :src="settings.interface.config.logo.variant" height="45vh" @click="Url('home')">
          </v-scale-transition>

          <v-spacer></v-spacer>

          <v-btn plain flat v-for="(item, i) in menu.menu" :key="i" link @click="Url((!item.active?'':'!')+item.slug)" class="text-capitalize font-weight-bold d-none d-sm-none d-md-flex">
            <v-icon class="d-flex d-sm-none">{{item.icon}}</v-icon>
            <span class="d-none d-sm-none d-md-flex">{{item.title}}</span>
          </v-btn>

          <v-dialog v-model="sidebar" fullscreen hide-overlay transition="dialog-bottom-transition">
            <template v-slot:activator="{ on, attrs }">
              <v-btn plain tile v-bind="attrs" v-on="on" class="d-flex d-sm-none">
                <v-icon>mdi-menu</v-icon>
              </v-btn>
            </template>
            <v-card class="pa-0">
              <v-card-title>
                <v-toolbar elevation="0" dense>
                  <v-spacer></v-spacer>
                  <v-toolbar-items>
                    <v-btn text @click="sidebar = false">
                      <v-icon>mdi-close</v-icon>
                    </v-btn>
                  </v-toolbar-items>
                </v-toolbar>
              </v-card-title>
              <v-card-text>
                <v-row class="fill-height" justify="center">
                  <v-col cols="12" md="6">
                    <v-card flat>
                      <v-card-text>
                        <v-list dense flat>
                          <v-list-item link @click="Url('home'),sidebar = false">
                            <v-list-item-icon>
                              <v-icon color="rgb(243, 118, 29)">mdi-home-outline</v-icon>
                            </v-list-item-icon>
                            <v-list-item-content>
                              Inicio
                            </v-list-item-content>
                          </v-list-item>
                          <v-list-item v-for="(item, i) in menu.menu" :key="i" link @click="Url((!item.active?'':'!')+item.slug),sidebar = false">
                            <v-list-item-icon>
                              <v-icon color="rgb(243, 118, 29)">{{item.icon}}</v-icon>
                            </v-list-item-icon>
                            <v-list-item-content>
                              {{item.title}}
                            </v-list-item-content>
                          </v-list-item>
                        </v-list>
                      </v-card-text>
                    </v-card>
                  </v-col>
                </v-row>
              </v-card-text>
            </v-card>
          </v-dialog>
        </v-app-bar>
      </v-fade-transition>
      <component v-if="url.t=='!'" :is="'render-page'" :slug="url.c" :key="url.c"></component>
      <component v-else :is="'page-'+url.c" :key="'page-'+url.c"></component>
      <v-divider class="py-5"></v-divider>
      <v-btn v-for="(item,i) in content.socials"
        :key="item.title"
        color="secondary"
        :href="item.link?item.link:undefined" target="_blank"
        fab
        small
        right
        fixed
        :style="{bottom: (36+(i*7))+'vh',margin: '0 0 16px 16px'}"
      >
        <v-icon v-if="!item.picture">{{item.subtitle}}</v-icon>
      </v-btn>
      <v-footer padless v-if="content.footer.length > 0">
        <v-card class="flex" flat tile class="pa-0">
          <v-card-text class="py-2">
            <v-row>
              <v-col cols="12" md="3" class="d-flex align-start" v-for="(item,i) in content.footer">
                <span>
                  <v-img :src="item.picture" width="50vh" contain v-if="item.picture" class="mb-2"></v-img>
                  <dt v-if="item.title" class="text-h5 mb-2">{{item.title}}</dt>
                  <dd v-if="item.subtitle" class="text-h6 mb-2">{{item.subtitle}}</dd>
                  <p v-if="item.description" class="my-2">{{item.description}}</p>
                  <p v-if="item.content" v-html="item.content"></p>
                </span>
              </v-col>
            </v-row>
            <v-row>
              <v-col cols="12" md="3" class="d-flex align-start" v-for="(item,i) in content.links">
                <v-btn small class="text-capitalize" text :href="item.link?item.link:undefined" target="_blank" block>{{item.title}}</v-btn>
              </v-col>
            </v-row>
          </v-card-text>
        </v-card>
      </v-footer>
    </v-app>
  </div>

  <script>
    Vue.filter('lorem', function (value) {
      if (!value) return ''
      let text = []
      for (var i = 0; i < value; i++) {
        text.push('Lorem ipsum dolor sit amet consectetur adipiscing elit Nullam et luctus justo, in iaculis est Praesent lacinia.')
      }
      value = text.join(' ')
      return value
    })
    Vue.filter('capitalize', function (value) {
      if (!value) return ''
      value = value.toString()
      return value.charAt(0).toUpperCase() + value.slice(1)
    })
    Vue.filter('decimals', function (value) {
      if (!value) return ''
      return Number(value).toFixed(2)
    })
    Vue.filter('filesize', function (value) {
      if (value < 1024) return value + ' B'
      let i = Math.floor(Math.log(value) / Math.log(1024))
      let num = (value / Math.pow(1024, i))
      let round = Math.round(num)
      num = round < 10 ? num.toFixed(2) : round < 100 ? num.toFixed(1) : round
      return `${num} ${'KMGTPEZY'[i - 1]}B`
    })
    Vue.filter('date', function (value) {
      if (!value) return ''
      let date_time = value.split(' ');
      let date = date_time[0]
      let time = date_time[1]
      let new_date = date.split('-')
      return new_date[2] + '/' + new_date[1] + '/' + new_date[0]
    })
    Vue.filter('time', function (value) {
      if (!value) return ''
      let time = value
      let new_time = time.split(':')
      let hour = parseInt(new_time[0],10)
      let minute = parseInt(new_time[1],10)

      let period = hour >= 12?"PM":"AM"

      hour = hour % 12 || 12
      minute = minute.toString().padStart(2,'0')

      return `${hour}:${minute} ${period}`
    })
    Vue.filter('timespan', function (value) {
      if (!value) return ''
      let date_time = value.split(' ');
      let date = date_time[0]
      let new_date = date.split('-')
      let day = new_date[2]
      let month = new_date[1]
      let year = new_date[0]

      let time = date_time[1]
      let new_time = time.split(':')
      let hour = parseInt(new_time[0],10)
      let minute = parseInt(new_time[1],10)

      let period = hour >= 12?"PM":"AM"

      hour = hour % 12 || 12
      minute = minute.toString().padStart(2,'0')

      return `${day}/${month}/${year} ${hour}:${minute} ${period}`
    })
    Vue.filter('truncate', function (value, length, suffix) {
      if (!value) return ''
      if (value.length > length) {
        return value.substring(0, length) + suffix;
      } else {
        return value
      }
    })
    Vue.filter('money', function (value, suffix="$") {
      if (!value) return ''
      value = value.toString();
      var pattern = /(-?\d+)(\d{3})/;
      while (pattern.test(value))
        value = value.replace(pattern, "$1,$2");
      return value+suffix
    })

    Vue.component('l-map', window.Vue2Leaflet.LMap);
    Vue.component('l-tile-layer', window.Vue2Leaflet.LTileLayer);
    Vue.component('l-marker', window.Vue2Leaflet.LMarker);
    Vue.component('l-icon', window.Vue2Leaflet.LIcon);
    Vue.component('l-popup', window.Vue2Leaflet.LPopup);
    Vue.component('l-tooltip', window.Vue2Leaflet.LTooltip);
    Vue.component('l-polygon', window.Vue2Leaflet.LPolygon);
    Vue.component('l-geo-json', window.Vue2Leaflet.LGeoJson);
    Vue.component('l-control', window.Vue2Leaflet.LControl);
    Vue.component('l-control-layers', window.Vue2Leaflet.LControlLayers);
    Vue.component('v-chart', window.VueECharts);
    Vue.use(VueGoogleMaps, {
      load: {
        region: 'PE',
        language: 'es',
        key: 'AIzaSyAb0HPDY2-MrV4K_CtjvIfBkAfBldMPdJE',
        libraries: 'places'
      }
    })

    Vue.use(CKEditor);
    CKEDITOR.config.extraPlugins = 'base64image';
    CKEDITOR.config.removePlugins = 'about,image';
  </script>
  <script>
    const messages = {
      en: {
        action: {
          create: 'Create',
          list: 'List',
          add: 'Add',
          read:'List',
          view: 'Details',
          delete: 'Delete',
          update: 'Update',
          open: 'Open',
          close: 'Close',
          save: 'Save',
          search: 'Search',
          setting: 'Setting',
          loading: 'Loading',
        },
        section: {
          module: 'Module',
          component: 'Component',
          element: 'Element',
          record: 'Record',
          section: 'Section'
        },
        module:{
          database:'Database',
          component:'Components',
          module:'Modules',
          settings:'Settings',
          importer:'Importer',
        },
        form: {
          response:{
            success:"Success!"
          }
        },
        status:{
          active:"Active",
          inactive:"Inactive"
        },
        alert: {
          delete: "This {el} will be permanently removed"
        }
      },
      es: {
        action: {
          create: 'Crear',
          list:'Listado',
          add: 'Agregar',
          read:'Listado',
          view: 'Detalles',
          delete: 'Eliminar',
          update: 'Actualizar',
          open: 'Abrir',
          close: 'Cerrar',
          save: 'Guardar',
          search: 'Buscar',
          setting: 'Ajuste',
          loading: 'Cargando',
        },
        section: {
          module: 'Modulo',
          component: 'Componente',
          element: 'Elemento',
          record: 'Registro',
          section: 'Seccion'
        },
        module:{
          database:'Base de Datos',
          component:'Componentes',
          module:'Modulos',
          settings:'Ajustes',
          importer:'Importar Data',
        },
        form: {
          response:{
            success:"Éxito!"
          }
        },
        status:{
          active:"Activo",
          inactive:"Inactivo"
        },
        alert: {
          delete: "Este {el} sera eliminado de forma permanente"
        }
      }
    }
    const i18n = new VueI18n({
      locale: 'es',
      messages
    })
  </script>
  <script>
    var app = new Vue({
      router,
      i18n,
      el: "#app",
      vuetify: new Vuetify(),
      data: {
        title: "<?=env('APP_NAME')?>",
        session: '',
        menu: {
          menu:[],
          footer:[],
          links:[],
          social:[]
        },
        content:{
          footer:[],
          links:[],
          socials:[],
        },
        modules: [],
        global:{
          filter:{
            charter:{
              name:null,
              date_start:null,
              date_end:null,
              location:null,
              guest:null,
              cabins:null,
              charter_rate:[0,20000000],
              length:[0,300],
              year_built:[1927,2025],
            }
          }
        },
        url:{
          c:'',
          d:false,
          id:'',
          t:'',
          content:'',
          permission:[],
          main:'home',
          type:'!',
        },
        page:{
          active:''
        },
        loader:{
          page:true,
          component:true,
          scroll:0,
          size:{
            x:self.innerWidth,
            y:self.innerHeight
          },
        },
        sidebar: false,
        footerbar: false,
        settings: {
          languages: [
            {
              label: 'English',
              value: 'en'
            },
            {
              label: 'Spanish',
              value: 'es'
            }
          ],
          interface:{
            value:false,
            config:{"nav":{"color":"purple darken-4","style":[],"dark":true},"sidebar":{"color":"purple lighten-4","style":[],"dark":true},"logo":{"file":"","variant":"", "width":null, "height":null },"session":{"color":"purple darken-4","style":{"background":"linear-gradient(135deg, #9C27B0 0%,#009688 100%)"},"dark":true}}
          },
          security:{
            value:false,
            config:{"table":null,"allow_register":true,"fields":{"id":null,"role":null,"name":null,"user":null,"email":null,"password":null}}
          },
          contact:{
            value:false,
            config:[]
          }
        },
        dark_mode: true,
        t_key: 1
      },
      watch: {
        $route(to, from) {
          if (to.hash) {
            var n_hash = to.hash.replace('#','')
            var c
            if (/-/.test(n_hash)) {            
              var hash_split = n_hash.split('-')
              if (hash_split.length>1) {
                if (/!/.test(hash_split[hash_split.length-1])) {
                  var hash = hash_split[hash_split.length-1].replace(/!/g,"")
                  hash_split.pop()
                  this.url.id = hash
                } else {
                  this.url.id=''
                }
              }

              c = hash_split.join('-')
            } else {
              c = n_hash
            }
            if (/!/.test(c)) {
              this.url.t = this.url.type
            }else{
              this.url.t = ''
            }
            this.url.c = c.replace(/!/g,"")
            router.push({ query: {},hash:n_hash }).catch(() => { })
          } else {
            this.url.c = this.url.main
            this.url.t = this.url.type
            router.push({ query: {},hash:this.url.main }).catch(() => { })
          }
        }
      },
      methods: {
        handleScroll: function() {
          this.loader.scroll = window.scrollY
        },
        handleSize: function() {
          this.loader.size.x = self.innerWidth
          this.loader.size.y = self.innerHeight
        },
        GetSession: function () {
          axios.post('Session').then((response) => {
            this.session = response.data
          })
        },
        CloseSession: function () {
          axios.post('Session/LogOut')
          .then((res) => {
            window.location = '<?=site_url()?>'
          })
        },
        GenerateID: function (type = 'alnum', len = 8) {
          var charset = "";
          if (type == "alpha") {
            charset += "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
          }
          if (type == "alnum") {
            charset += "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            charset += "0123456789";
          }
          if (type == "numeric") {
            charset += "0123456789";
          }
          var ret = "";
          for (var i = 0, n = charset.length; i < len; ++i) {
            ret += charset.charAt(Math.floor(Math.random() * n));
          }
          return ret;
        },
        GetMenu: function(){
          axios.post('Menu/get/menu/web').then((response) => {
            this.menu.menu = response.data
          })
          axios.post('Menu/get/footer/web').then((response) => {
            this.menu.footer = response.data
          })
          axios.post('Menu/get/links/web').then((response) => {
            this.menu.links = response.data
          })
          axios.post('Post/get', {
            where: {
              is_visible: 1
            }
          }).then((response) => {
            this.modules = response.data
          })
        },
        GetFooter: function(){
          axios.post('API/get/web_content',{like:{code:'footer'}}).then((response) => {
            this.content.footer = response.data
          })
          axios.post('API/get/web_content',{like:{code:'link'}}).then((response) => {
            this.content.links = response.data
          })
          axios.post('API/get/web_content',{like:{code:'social'}}).then((response) => {
            this.content.socials = response.data
          })
        },
        DarkMode: function (onoff) {
          this.$vuetify.theme.dark = onoff
        },
        clampCss: function (s,b=4) {
          let sd = s*0.25
          let min = s-sd
          let max = s+sd
          return 'clamp('+min+'rem,'+(b+s)+'vw,'+max+'rem)'
        },
        Url: function (c, id, t) {
          var path_init = {}
          var segments = []
          if (c) {
            segments.push(c)
          }
          if (id) {
            segments.push(this.url.type+id)
          }
          if (t) {
            segments.push(t)
          }

          var hash = segments.join('-')
          this.t_key = hash
          window.scrollTo(0, 0)
          router.push({ query: path_init,hash:hash }).catch(() => { })
        },
        Page: function (c, id, t) {
          axios.post('Post/get',{
            where:{
              slug:this.url.c
            },
            result:'row'
          }).then((res) => {
            this.url.content = res.data
            this.title = res.data.title
          })
        },
        RefreshDatabase: function () {
          axios.post('Database/refresh_database').then((res) => {
            this.toast.show({
              message:res.status==200?"DDBB restaurada.":"No se pudo restaurar la DDBB.",
              color:res.status==200?'success':'orange',
              icon:'bi-info-circle',
              system:true
            })
            this.GetSession();
            this.GetMenu();
            this.Permission();
            axios.post('Settings/get/interface').then((response) => {
              this.settings.interface = response.data
            })
          })
        },
        Permission: function (p) {
          axios.post('Menu/permission/'+p+'').then((res) => {
            this.url.permission = res.data
          })
        },
        showLoader:function(t){
          if (t==false) {
            this.loader.component = false
          } else {
            this.loader.component = true
          }
          if (this.$refs.toast) {
            this.$root.toast.show({
              message:this.loader.component?"Cargando, Por favor espere.":"Carga completada.",
              color:this.loader.component?'orange':'success',
              icon:'bi-info-circle',
              system:true
            })
          }
        },
      },
      created: function () {
        window.addEventListener('scroll', this.handleScroll);
        window.addEventListener("resize", this.handleSize);
        this.GetSession()
        this.$vuetify.theme.dark = this.settings.interface.value
        this.GetMenu()
        this.GetFooter()
        var to = this.$route;
        if (to.hash) {
          var n_hash = to.hash.replace('#','')
          var c
          if (/-/.test(n_hash)) {            
            var hash_split = n_hash.split('-')
            if (hash_split.length>1) {
              if (/!/.test(hash_split[hash_split.length-1])) {
                var hash = hash_split[hash_split.length-1].replace(/!/g,"")
                hash_split.pop()
                this.url.id = hash
              } else {
                this.url.id=''
              }
            }

            c = hash_split.join('-')
          } else {
            c = n_hash
          }
          if (/!/.test(c)) {
            this.url.t = this.url.type
          }
          this.url.c = c.replace(/!/g,"")
          router.push({ query: {},hash:n_hash }).catch(() => { })
        } else {
          this.url.c = this.url.main
          this.url.t = this.url.type
          router.push({ query: {},hash:this.url.main }).catch(() => { })
        }
        axios.post('Settings/get/contact').then((response) => {
          this.settings.contact = response.data
        })
        axios.post('Settings/get/interface').then((response) => {
          this.settings.interface = response.data
        })
        axios.post('Settings/get/security').then((response) => {
          this.settings.security = response.data
        })
        document.title = this.title
      },
      mounted() {
        this.toast = this.$refs.toast
      },
      destroyed () {
        window.removeEventListener('scroll', this.handleScroll);
        window.removeEventListener("resize", this.handleSize);
      }
    })
  </script>
</body>

</html>