<?php

namespace App\Controllers;

class Admin extends BaseController
{
	public function index()
	{
		if ($_ENV['APP_INSTALLED'] == "true") {
			$security = $this->db->table('sys_settings')->where('key','security')->get()->getRowArray();
			$interface = $this->db->table('sys_settings')->where('key','interface')->get()->getRowArray();

			$data['security'] = json_decode($security['config'],true);
			$data['interface'] = json_decode($interface['config'],true);

			if ($security['value']=='true') {
				if (!isset($_SESSION[$data['security']['fields']['user']])) {
					return view('login',$data);
				}
			}
			return view('theme',$data);
		} else {
			return redirect()->to('Install/install');
		}
	}
	public function finish_installation()
	{
		if ($_ENV['APP_INSTALLED'] == "true") {
			if(command('migrate')){
				command('db:seed AllData');
				return redirect()->to(site_url());
			};
		} else {
			return redirect()->to('Install/install');
		}
	}
}