<?php

namespace App\Controllers;

class External extends BaseController
{
  public function charter($status,$id)
  {
    if ($_REQUEST['token']) {
      $token = $_REQUEST['token'];
      $charter = $this->db->table('charter')->where('id',$token)->get()->getRowArray();
      $customer = $this->db->table('users')->where('id',$id)->get()->getRowArray();
      $yacht = $this->db->table('yachts')->where('id',$charter['yatch_id'])->get()->getRowArray();

      $content = '<p>Hello '.$customer['name'].' '.$customer['lastname'].'.</p>';

      if ($status=="accept") {
        $content = '<p>Your request to charter the yacht '.$yacht['name'].' has been approved.</p>';
        $this->db->table('charter')->set('status','approved')->where('id',$token)->update();
      }

      if ($status=="decline") {
        $content = '<p>Your request to charter the yacht '.$yacht['name'].' has been rejected.</p>';
        $this->db->table('charter')->set('status','declined')->where('id',$token)->update();
      }

      if ($charter['type'] == 'days') {
        $date_start = date('d/m/Y',strtotime($charter['date_start']));
        $date_end = date('d/m/Y',strtotime($charter['date_end']));
        $content .= '<dt>Start</dt><dd>'.$date_start.'</dd>';
        $content .= '<dt>End</dt><dd>'.$date_end.'</dd>';
      }
      if ($charter['type'] == 'hours') {
        $day = date('d/m/Y',strtotime($charter['date_start']));
        $date_start = date('h:m a',strtotime($charter['date_start']));
        $date_end = date('h:m a',strtotime($charter['date_end']));
        $content .= '<dt>Date</dt><dd>'.$day.'</dd>';
        $content .= '<dt>Start</dt><dd>'.$date_start.'</dd>';
        $content .= '<dt>End</dt><dd>'.$date_end.'</dd>';
      }
      $content .= '<dt>Duration</dt><dd>'.$charter['duration'].' '.ucwords($charter['type']).' </dd>';
      $data = [];

      $data['type'] = 'chat';
      $data['sender'] = null;
      $data['receiver'] = $id;
      $data['email_sender'] = 'charter@solankoyachts.com';
      $data['email_receiver'] = $customer['email'];
      $data['reference'] = $id;
      $data['subject'] = "Enquire/Charter";
      $data['content'] = $content;
      $st = $this->db->table('sys_messenger')->set($data)->insert();
      if ($st) {
        $config['mailType'] = 'html';
        $config['wordWrap'] = true;

        $email = service('email');
        $email->initialize($config);

        $email->setFrom('charter@solankoyachts.com', 'Charter Solanko Yachts');
        $email->setTo($data['email_receiver']);

        $email->setSubject($data['subject']);
        $email->setMessage($data['content']);

        if ($email->send()) {
          echo $content;
        };
      }
    }
  }
}