<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Settings extends Migration
{
  public function up()
  {
		$this->forge = \Config\Database::forge();
		$this->forge->addField([
			'key' => [
        'type'           => 'VARCHAR',
        'constraint'     => 100,
				'null' => false
			],
			'icon'=>[
				'type'=>'VARCHAR',
        'constraint' => 50,
				'null' => true
      ],
			'name'=>[
				'type'=>'TEXT',
				'null' => true
      ],
			'value'=>[
				'type'=>'VARCHAR',
        'constraint' => 255,
				'null' => true
      ],
			'config'=>[
				'type'=>'TEXT',
				'null' => true
			]
		]);
		$this->forge->addKey('key',true);
		$this->forge->createTable('sys_settings');
  }

  public function down()
  {
    $this->forge->dropTable('sys_settings');
  }
}
