<?php
  $this->uri = service('uri');
  $pk = '';
  $map_type = [];
  $methods = [];
  $created = [];

  $created[] = 'this.Data()';
  $models['title'] = $response['name'];
  $models['search'] = null;
  $models['loading'] = true;
  $models['to_remove'] = false;
  $models['remove_item'] = null;
  $models['list'] = [];
  $models['headers'] = [];
  $models['export']['headers'] = [];
  $models['query'] = $response['query'];
  $width_action = 11;

  foreach ($response['data'] as $field) {
    $main_table = explode('.',$field['name']);
    $fieldname = str_replace('.','_',$field['name']);
    if ($field['type'] == 'marker') {
      $latlng = $field['name'];
      $map_type[] = [
        'name'=>$field['name'],
        'label'=>$field['label'],
        'field'=>$field['field'],
        'type'=>$field['type']
      ];
    }
    if ($field['type'] == 'polygon') {
      $latlng = $field['name'];
      $map_type[] = [
        'name'=>$field['name'],
        'label'=>$field['label'],
        'field'=>$field['field'],
        'type'=>$field['type']
      ];
    }
    if ($field['type'] == 'file') {
      $models["download_{$fieldname}_file"] = null;
    }

    if ($main_table[0] == $response['table'] and $field['primary_key'] == '1') {
      $pk = $field['name'];
      $models['query']['select'][] = $field['name'];
    }
    if ($field['visible']==true) {
      $pre_width = ($field['width']/12)*100;
      $width = ($pre_width*(100-$width_action))/100;
      $models['headers'][] = [
        'text'=>"{$field['label']}",
        'sortable'=>true,
        'value'=>str_replace('.','_',$field['name'])
      ];
      $models['export']['headers'][] = [
        'title'=>"{$field['label']}",
        'dataKey'=>str_replace('.','_',$field['name']),
        'width'=>"{$width}%"
      ];
      $models['query']['select'][] = $field['name'];
    }
  }
  $models['headers'][] = [
    'text'=>"...",
    'width'=>"{$width_action}%"
  ];

  $props['props'] = [];

  foreach ($response['props'] as $key => $value) {
    $props['props'][] = $key;
  }
?>

Vue.component('<?=$response['codename']?>',{template: `
  <div>
    <v-data-table :headers="headers" :items="list" class="elevation-1" v-show="!loading" :search="search">
      <template v-slot:top>
        <v-toolbar flat>
          <v-toolbar-title>{{ $t('action.view') }}</v-toolbar-title>
          <v-divider class="mx-4" inset vertical></v-divider>
          <v-spacer></v-spacer>
          <v-text-field solo flat outlined dense v-model="search" append-icon="mdi-magnify" label="..." single-line hide-details ></v-text-field>
          <v-divider class="mx-4" inset vertical></v-divider>
          <v-tooltip bottom color="primary">
            <template v-slot:activator="{ on, attrs }">
              <v-btn
                color="primary"
                dark
                v-bind="attrs"
                v-on="on"
                fab
                x-small
                @click="generate()"
              >
                <v-icon>bi-file-earmark-pdf</v-icon>
              </v-btn>
            </template>
            <span>Generar PDF</span>
          </v-tooltip>
        </v-toolbar>
      </template>
      <template v-slot:item="row">
        <tr>
          <?php foreach ($response['data'] as $field): ?>
            <?php if ($field['visible']==true): ?>
              <?php
                $pre_width = ($field['width']/12)*100;
                $width = round($pre_width,0);
                if ($field['filter']==''){
                  $filter = '';
                }elseif($field['filter']==null){
                  $filter = '';
                }else {
                  $filter = " | {$field['filter']}";
                }
              ?>
              <?php if ($field['type']=='checkbox'): ?>
                <td><v-icon :color="row.item.<?=str_replace('.','_',$field['name'])?>==1?'success':'error'" true-value="1">{{row.item.<?=str_replace('.','_',$field['name'])?>==1?'bi bi-check':'bi bi-x'}}</v-icon></td>
              <?php elseif ($field['type']=='image'): ?>
                <td>
                  <v-img :src="row.item.<?=str_replace('.','_',$field['name'])?>?row.item.<?=str_replace('.','_',$field['name'])?>:'public/theme/images/image-default.svg'" max-width="150" contain></v-img>
                </td>
              <?php elseif ($field['type']=='file'): ?>
                <td>
                  <div v-if="Array.isArray(row.item.<?=str_replace('.','_',$field['name'])?>)">
                    <v-btn v-for="(file,f) in row.item.<?=str_replace('.','_',$field['name'])?>" @click="downloadFile(file,'<?=str_replace('.','_',$field['name'])?>')">
                      File {{f+1}}
                    </v-btn>
                  </div>
                  <div v-else-if="typeof row.item.<?=str_replace('.','_',$field['name'])?>=='string'">
                    <v-btn v-for="(file,f) in row.item.<?=str_replace('.','_',$field['name'])?>" @click="downloadFile(file,'<?=str_replace('.','_',$field['name'])?>')">
                      File {{f+1}}
                    </v-btn>
                  </div>
                  <div v-else>
                    <v-btn @click="downloadFile(file,'<?=str_replace('.','_',$field['name'])?>')"></v-btn>
                  </div>
                  {{row.item.<?=str_replace('.','_',$field['name'])?>}}
                </td>
              <?php else: ?>
                <td>{{row.item.<?=str_replace('.','_',$field['name'])?><?=$filter?>}}</td>
              <?php endif ?>
            <?php endif ?>
          <?php endforeach ?>
          <td>
            <v-tooltip bottom color="teal" v-if="view">
              <template v-slot:activator="{ on, attrs }">
                <v-btn
                  @click="$root.Url($root.url.c+'-'+view,row.item.<?=str_replace('.','_',$pk)?>,'page')"
                  color="teal"
                  v-bind="attrs"
                  v-on="on"
                  fab
                  x-small
                  dark
                >
                  <v-icon>bi bi-eye</v-icon>
                </v-btn>
              </template>
              <span>{{$t('action.view')}}</span>
            </v-tooltip>

            <v-tooltip bottom color="indigo" v-if="update">
              <template v-slot:activator="{ on, attrs }">
                <v-btn
                  @click="$root.Url($root.url.c+'-'+update,row.item.<?=str_replace('.','_',$pk)?>,'page')"
                  color="indigo"
                  v-bind="attrs"
                  v-on="on"
                  fab
                  x-small
                  dark
                >
                  <v-icon>bi-pencil-square</v-icon>
                </v-btn>
              </template>
              <span>{{$t('action.update')}}</span>
            </v-tooltip>

            <v-tooltip bottom color="red" v-if="remove">
              <template v-slot:activator="{ on, attrs }">
                <v-btn
                  @click="setUrl('remove',row.item.<?=str_replace('.','_',$pk)?>)"
                  color="red"
                  v-bind="attrs"
                  v-on="on"
                  fab
                  x-small
                  dark
                >
                  <v-icon>bi-trash</v-icon>
                </v-btn>
              </template>
              <span>{{$t('action.delete')}}</span>
            </v-tooltip>
          </td>
        </tr>
      </template>
    </v-data-table>
    <component  v-show="loading" is="loader"></component>
    <v-dialog v-model="to_remove" transition="dialog-bottom-transition" max-width="300" persistent>
      <template v-slot:default="dialog">
        <v-card>
          <v-card-title class="text-center text-h5">
            <v-icon color="red">bi-trash</v-icon><v-divider class="mx-4" inset vertical></v-divider> {{$t('action.delete')}} {{$t('section.record')}}
          </v-card-title>
          <v-card-text>
            {{$t('alert.delete',{el:$t('section.record')})}}
          </v-card-text>
          <v-card-actions class="justify-space-between">
            <v-btn text color="success" @click="Delete()"><v-icon>bi-check</v-icon> {{$t('action.delete')}}</v-btn>
            <v-btn text @click="to_remove=false,remove_item=null"><v-icon>bi-x</v-icon> {{$t('action.close')}}</v-btn>
          </v-card-actions>
        </v-card>
      </template>
    </v-dialog>
  </div>
  `,
  data:()=>{return <?= json_encode($models) ?>},
  props:<?= json_encode($props['props']) ?>,
  methods:{
    Data:function(){
      axios.post('Database/render_<?=$response['template']?>/<?=$response['table']?>',{
        data:this.query,
        props:router.history.current.query
      }).then((response)=>{
        this.list = response.data
        this.loading = false
      })
    },
    setUrl:function(act,id){
      if(act=='remove'){
        this.to_remove = true
        this.remove_item = id
      } else {
        if(this.$root.page.active==null){
          this.$root.GetPage(this.$root.p,act,id,'page')
          console.log('PAGENULL')
        } else {

          this.$root.GetPage(this.$root.p,act,id,'page')
          console.log(id)
        }
      }
    },
    Delete:function(act,id){
      axios.post('Module/delete/<?=$response['table']?>',{
        where:{'<?=$pk?>':this.remove_item}
      }).then((response)=>{
        this.to_remove = false
        this.remove_item = null
        this.Data()
      })
    },
    downloadFile(file,field){
      var split_base = file.split(';')
      var split_data = split_base.split(':')

      var contentType = split_data[1]
      var base64 = split_base[1]

      const fileBlob = this.base64ToBlob(base64,contentType)
      this['download_'+field+'_file'] = URL.createObjectURL(fileBlob)
    },
    base64ToBlob(base64, contentType) {
      const byteCharacters = atob(base64)
      const byteArrays = []
      for (let offset = 0; offset < byteCharacters.length; offset += 512) {
        const slice = byteCharacters.slice(offset, offset + 512)
        const byteNumbers = new Array(slice.length)
        for (let i = 0; i < slice.length; i++) {
          byteNumbers[i] = slice.charCodeAt(i)
        }
        const byteArray = new Uint8Array(byteNumbers)
        byteArrays.push(byteArray)
      }
      const blob = new Blob(byteArrays, { type: contentType })
      return blob
    },
    generate:function(type='pdf'){
      var cols = this.export.headers;
      var doc = new jsPDF({
        orientation:'portrait',
        unit:'in',
        format:'letter'
      });
      doc.setFontSize(16).text(this.title,0.5,1.0);
      doc.setLineWidth(0.01).line(0.5,1.1,8.0,1.1);

      doc.autoTable({
        cols,
        body:this.list,
        margin:{left:0.5,top:1.25}
      });

      doc
        .setFont('times')
        .setFontSize(11)
        .setFontStyle('italic')
        .setTextColor(0,0,255)
        .text("Pie de pagina",0.5,doc.internal.pageSize.height-0.5)
        .save(this.title+'.pdf')
    },
    <?= implode(',', $methods) ?>
  },
  created(){
    document.title = this.title
    <?= implode(',', $created) ?>
  }
})