<?php
  $this->uri = service('uri');
  $attr = [];
  $models['form'] = [];
  $computed['required'] = [];
  $methods = [];
  $created = [];
  $models['title'] = $response['name'];
  $models['formHasErrors'] = false;
  $models['alert'] = false;
  $models['message'] = '';
  $valid['required'] = false;
  $valid['multipart'] = false;

  $props['props'] = [];

  $pk = '';

  foreach($response['data'] as $field){
    if ($field['primary_key']== '1'){
      $pk = $field['name'];
    }
  }
  foreach ($response['props'] as $key => $value) {
    $props['props'][] = $key;
  }
?>

Vue.component('<?=$response['codename']?>',{template: `
  <v-row>
    <v-col cols='12' md='12'>
      <v-card>
        <v-card-title>{{title}}</v-card-title>
        <v-card-text>
          <v-form ref='form' v-on:submit.prevent='Save()' lazy-validation>
            <v-row>
              <?php foreach ($response['data'] as $field): ?>
                <?php if ($field['visible']==true): ?>
                  <?php

                    if (isset($field['default'])) {
                      switch ($field['default']) {
                        case '--date--':
                          $value = date('Y-m-d');
                          break;
                        case '--time--':
                          $value = date('H:i:s');
                          break;
                        case '--datetime--':
                          $value = date('Y-m-d H:i:s');
                          break;

                        default:
                          $value = $field['default'];
                          break;
                      }
                    } else {
                      $value = '';
                    }
                    if (empty($value)) {
                      if (boolval($field['multiple'])) {
                        $value = [];
                      } else {
                        $value = '';
                      }
                    }
                    $models['form'][$field['name']] = $value;
                    if (!empty($field['option']['data']['value'])) {
                      $models['fill'][$field['name']] = is_array($field['option']['data']['value'])?$field['option']['data']['value']:[];
                    }
                    if ($field['required'] == true) {
                      $computed['required'][$field['name']] = "{$field['name']}";
                    }

                    $attr['required'] = (boolval($field['required'])?"required :rules=\"[() => !!form.{$field['name']} || 'El Campo {$field['label']} es obligatorio']\" append-icon='bi-asterisk' color='error'":'');
                    $attr['disabled'] = (boolval($field['disabled'])?"disabled append-icon='bi-lock'":'');
                    $attr['hidden'] = (boolval($field['hidden']) ? 'style="display:none"' : '');
                    //$attr['multiple'] = '';
                    $attr['multiple'] = (boolval($field['multiple'])?'multiple':'');
                    $attr['type'] = 'dense outlined filled';
                    if($field['required']==true){
                      $valid['required'] = false;
                    }
                    if ($field['type']=='image' || $field['type']=='file') {
                      $valid['multipart'] = true;
                    }
                    if ($field['type']=='marker') {
                      $methods[] = "{$field['name'] }_marker:function(e){this.form.{$field['name']} = [e.latlng.lat,e.latlng.lng]}";
                      $methods[] = "ready_{$field['name']}_marker:function(e){this.form.{$field['name']} = [6.795535,-64.379883]}";
                      $created[] = "this.ready_{$field['name']}_marker()";
                    }
                    if ($field['type']=='polygon') {
                      $methods[] = "{$field['name']}_polygon:function(e){this.form.{$field['name']}.push([... [e.latlng.lat,e.latlng.lng] ])}";
                      $methods[] = "ready_{$field['name']}_{$field['type']}:function(e){this.form.{$field['name']} = []}";
                      $created[] = "this.ready_{$field['name']}_{$field['type']}()";
                    }
                    if (!empty($field['option']['data']['value'])) {
                      if (!empty($field['option']['origin'])) {
                        $created[] = "this.Fill(".json_encode($field['option']['origin']).",".json_encode($field['option']['data']['key']).",".json_encode($field['name']).",".json_encode($field['option']['data']['value']).")";
                      } else {
                        $created[] = "this.Fill(null,".json_encode($field['option']['data']['value']).",".json_encode($field['name']).")";
                      }
                    }
                  ?>
                  <?php if ($field['type'] == 'number'): ?>
                    <v-col cols='12' md="<?= $field['width'] ?>">
                      <v-text-field <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> ref='<?= $field['name'] ?>' v-model="form.<?= $field['name'] ?>" type="number" label='<?= $field['label'] ?>'>
                      </v-text-field>
                    </v-col>
                  <?php elseif ($field['type'] == 'text'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <v-text-field <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" label="<?= $field['label'] ?>">
                      </v-text-field>
                    </v-col>
                  <?php elseif ($field['type'] == 'textarea'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <ckeditor <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" counter rows='2' auto-grow label="<?= $field['label'] ?>" :value="form.<?= $field['name'] ?>">
                      </ckeditor>
                    </v-col>
                  <?php elseif ($field['type'] == 'date'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <v-text-field <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" type='date' label="<?= $field['label'] ?>">
                      </v-text-field>
                    </v-col>
                  <?php elseif ($field['type'] == 'time'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <v-text-field <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" type='time' label="<?= $field['label'] ?>"></v-text-field>
                    </v-col>
                  <?php elseif ($field['type'] == 'checkbox'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <v-checkbox <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" label="<?= $field['label'] ?>" true-value='1' false-value='0'></v-checkbox>
                    </v-col>
                  <?php elseif ($field['type'] == 'radio'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <v-radio-group row <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> label="<?= $field['label'] ?>" ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>"><v-radio v-for="item in fill.<?= $field['name'] ?>" <?= $attr['type'] ?> :label='item' :value='item' :key='item'></v-radio></v-radio-group>
                    </v-col>
                  <?php elseif ($field['type'] == 'select'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <v-select <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['multiple'] ?> <?= $attr['disabled'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" :items="fill.<?= $field['name'] ?>" item-text="<?= $field['option']['data']['value'] ?>" item-value="<?= $field['option']['data']['key'] ?>" label="<?= $field['label'] ?>" :return-object="false"></v-select>
                    </v-col>
                  <?php elseif ($field['type'] == 'combobox'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <v-autocomplete <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['multiple'] ?> <?= $attr['disabled'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" :items="fill.<?= $field['name'] ?>" item-text="<?= $field['option']['data']['value'] ?>" item-value="<?= $field['option']['data']['key'] ?>" label="<?= $field['label'] ?>"></v-autocomplete>
                    </v-col>
                  <?php elseif ($field['type'] == 'marker'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <l-map :center="{lat:6.795535,lng:-64.379883}" style='height:350px' :zoom='5' @click="<?= $field['name'] ?>_<?= $field['type'] ?>"><l-tile-layer url='https://mt1.google.com/vt/lyrs=r&x={x}&y={y}&z={z}' ></l-tile-layer><l-marker @ready="ready_<?= $field['name'] ?>_<?= $field['type'] ?>" :lat-lng="form.<?= $field['name'] ?>"></l-marker></l-map>
                    </v-col>
                  <?php elseif ($field['type'] == 'polygon'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <l-map :center="{lat:6.795535,lng:-64.379883}" style='height:350px' :zoom='5' @click="<?= $field['name'] ?>_<?= $field['type'] ?>"><l-tile-layer url='https://mt1.google.com/vt/lyrs=r&x={x}&y={y}&z={z}' ></l-tile-layer><l-polygon @ready="ready_<?= $field['name'] ?>_<?= $field['type'] ?>" :lat-lngs="form.<?= $field['name'] ?>"></l-polygon></l-map>
                    </v-col>
                  <?php elseif ($field['type'] == 'image'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <?php if ($attr['multiple']): ?>
                        <v-row class="mb-2" v-if="form.<?= $field['name'] ?>.length>0">
                          <v-col cols="12" md="4" v-for="(img,i) in form.<?= $field['name'] ?>">
                            <v-card>
                              <v-img :src="img"></v-img>
                              <v-card-actions class="pa-1 d-flex justify-center">
                                <v-btn text @click="$delete(form.<?= $field['name'] ?>,i)">
                                  remove
                                </v-btn>
                              </v-card-actions>
                            </v-card>
                          </v-col>
                        </v-row>
                        <v-file-input <?= $attr['type'] ?> <?= $attr['disabled'] ?> <?= $attr['hidden'] ?> <?= $attr['multiple'] ?> prepend-icon='bi-image' @change="RenderFiles('files_<?= $field['name'] ?>','<?= $field['name'] ?>')" ref="files_<?= $field['name'] ?>" label="<?= $field['label'] ?>" accept="image/*" counter :show-size='1000'></v-file-input>
                      <?php else: ?>
                        <v-row class="mb-2" v-if="form.<?= $field['name'] ?>">
                          <v-col cols="12" md="4">
                            <v-card>
                              <v-img :src="form.<?= $field['name'] ?>">
                              </v-img>
                              <v-card-actions class="pa-1 d-flex justify-center">
                                <v-btn text @click="form.<?= $field['name'] ?>=null">
                                  remove
                                </v-btn>
                              </v-card-actions>
                            </v-card>
                          </v-col>
                        </v-row>
                        <v-file-input <?= $attr['type'] ?> <?= $attr['disabled'] ?> <?= $attr['hidden'] ?> <?= $attr['multiple'] ?> prepend-icon='bi-image' @change="RenderFile('file_<?= $field['name'] ?>','<?= $field['name'] ?>')" ref="file_<?= $field['name'] ?>" label="<?= $field['label'] ?>" accept="image/*" counter :show-size='1000'></v-file-input>
                      <?php endif ?>
                      <input hidden type="text" v-model="form.<?= $field['name'] ?>" <?= $attr['required'] ?> ref="<?= $field['name'] ?>">
                    </v-col>
                  <?php elseif ($field['type'] == 'file'): ?>
                    <v-col cols='12' md='<?= $field['width'] ?>'>
                      <?php if ($attr['multiple']): ?>
                        <v-file-input <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> <?= $attr['multiple'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" label="<?= $field['label'] ?>" color='indigo accent-4' counter :show-size='1000'>
                          <template v-slot:selection="<?=  index, text  ?>">
                            <v-chip v-if='index < 2' color='indigo accent-4' dark label small>
                              {{ text }}
                            </v-chip>
                            <span v-else-if='index === 2' class='text-overline grey--text text--darken-3 mx-2'>
                              +{{ files.length - 2 }} Imagen(es)
                            </span>
                          </template>
                        </v-file-input>
                      <?php else: ?>
                        <v-col cols='12' md="<?= $field['width'] ?>">
                          <v-file-input <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> <?= $attr['multiple'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" label="<?= $field['label'] ?>" color='indigo accent-4' counter :show-size='1000'></v-file-input>
                        </v-col>
                      <?php endif ?>
                    </v-col>
                  <?php else: ?>
                    <v-col cols='12' md="<?= $field['width'] ?>"><v-text-field <?= $attr['type'] ?> <?= $attr['required'] ?> <?= $attr['hidden'] ?> <?= $attr['disabled'] ?> ref="<?= $field['name'] ?>" v-model="form.<?= $field['name'] ?>" label="<?= $field['label'] ?>"></v-text-field></v-col>
                  <?php endif; ?>
                <?php endif ?>
              <?php endforeach ?>
            </v-row>
            <v-snackbar v-model="alert" >{{ $t(message) }}
              <template v-slot:action="{ attrs }">
                <v-btn color="success" text v-bind="attrs" @click="alert = false"> Cerrar</v-btn>
              </template>
            </v-snackbar>
            <v-fab-transition class="m-t-3">
              <v-btn
                type="submit"
                color="success"
                dark
                absolute
                bottom
                right
                fab
              >
                <v-icon>bi bi-cloud-arrow-up</v-icon>
              </v-btn>
            </v-fab-transition>
          </v-form>
        </v-card-text>
      </v-card>
    </v-col>
  </v-row>`,
  data:()=>{return <?= json_encode($models) ?>},
  props:<?= json_encode($props['props']) ?>,
  computed:{
    form_valid(){
      return{
        <?php foreach ($computed['required'] as $key => $value): ?>
          <?= $key ?>:this.form.<?= $value ?>,
        <?php endforeach ?>
      }
    }
  },
  methods:{
    Data:function(){
      axios.post('Database/render_read/<?=$response['table']?>',{
        data:{
          rule:[{'key':'<?=$pk?>','comparator':'=','value':this.$root.url.id,'conector':null,'escape':true}]
        },
        result:'row'
      }).then((response)=>{
        this.form = response.data
      })
    },
    Save:function(){
      this.$refs.form.validate()
      this.formHasErrors = this.$refs.form.validate()
      if(this.formHasErrors){
        axios.post('Database/render_<?=$response['template']?>/<?=$response['table']?>',{
          data:this.form,
          where:{'<?=$pk?>':this.$root.url.id}
        })
        .then((response)=>{
          if(response.status==200){
            if(this.after_send.path !== null){
              route.push({query:{p:this.after_send.path,t:'page'}})
              this.message=this.success_message;
              this.alert=true;
            } else {
              this.message=this.success_message;
              this.alert=true;
              if(this.after_send.key !== null){
                this.$root.Url(this.$root.url.c+'-'+this.after_send.key,null,'page')
              }
            }
          } else{
            this.message=this.error_message;
          }
        })
      } else {
        this.message='Por favor complete los campos solicitados';
        this.alert=true;
      }
    },
    Fill:function(table=null,field=null,input=null,value=null){
      if(table!==null){
        axios.post('Database/render_read/'+table,{
          data:{
            select:[field,value]
          }
        }).then((response)=>{
          if(response.data.status==500){
            this.alert = true;
            this.message = 'Ha ocurrido un error, no se pudo consulta la tabla ['+table+']';
          } else{
            this.$set(this.fill,input,response.data)
          }
        })
      } else {
        this.$set(this.fill,input,field);
      }
    },
    RenderFile(r,f) {
      if (this.$refs[r].lazyValue !== null) {
        const file = this.$refs[r].lazyValue
        const reader = new FileReader()
        reader.onload = (e) => {
          this.form[f] = e.target.result
        }
        reader.readAsDataURL(file)
      } else {
        this.form[f] = null
      }
    },
    RenderFiles(r,f) {
      for(var i=0; i < this.$refs[r].lazyValue.length; i++){
        console.log(this.$refs[r].lazyValue[i])
        if (this.$refs[r].lazyValue[i] !== null) {
          const file = this.$refs[r].lazyValue[i]
          const reader = new FileReader()
          reader.onload = (e) => {
            this.form[f].push(e.target.result)
          }
          reader.readAsDataURL(file)
        }
      }
    },
    <?= implode(',', $methods) ?>
  },
  created(){
    document.title = this.title
    <?= implode(',', $created) ?>
  },
  mounted(){
    document.title = this.title
    this.Data()
  }
})