Vue.component('database',{
  template: `
  <v-sheet fluid>
    <v-toolbar>
      <v-toolbar-title>{{$t(page.title)}}</v-toolbar-title>
      <v-spacer></v-spacer>
      <v-btn fab color="success" small v-if="$root.url.permission.includes('create')" @click="$root.Url('create-'+$root.url.c)">
        <v-icon>bi-plus</v-icon>
      </v-btn>
    </v-toolbar>
    <v-data-iterator :items="tables" :items-per-page="iterator.items_per_page" :page="iterator.page" :search="iterator.search" hide-default-footer>
      <template v-slot:header>
        <v-toolbar class="mb-1" color="primary">
          <v-text-field v-model="iterator.search" clearable flat solo hide-details prepend-inner-icon="bi-search" :label="$t('action.search')"></v-text-field>
        </v-toolbar>
      </template>
      <template v-slot:default="props">
        <v-row>
          <v-col cols="12" sm="6" md="3" v-for="(row,r) in props.items">
            <v-card dense flat outlined>
              <v-card-title>{{row.name}}</v-card-title>
              <v-divider></v-divider>
              <!--v-card-text>
                <v-list dense>
                  <v-subheader>CAMPOS</v-subheader>
                  <v-list-item v-for="field in row.fields" dense>
                    <v-list-item-icon>
                      <v-icon v-if="field.type=='varchar'">ri-text</v-icon>
                      <v-icon v-else-if="field.type=='text' || field.type=='longtext'">ri-file-text-line</v-icon>
                      <v-icon v-else-if="field.type=='int' || field.type=='bigint' || field.type=='tinyint'">bi-sort-numeric-down</v-icon>
                      <v-icon v-else-if="field.type=='date' || field.type=='timestamp'">ri-calendar-event-line</v-icon>
                      <v-icon v-else-if="field.type=='datetime'">bi-calendar-date</v-icon>
                      <v-icon v-else-if="field.type=='decimal'">bi-123</v-icon>
                      <v-icon v-else>{{field.type}}</v-icon>
                    </v-list-item-icon>
                    <v-list-item-title>{{field.name}}</v-list-item-title>
                  </v-list-item>
                </v-list>
              </v-card-text-->
              <v-card-actions class="d-flex justify-space-between">
                <v-btn @click="$root.Url('read-'+$root.url.c,row.name)" color="teal" icon dark x-small>
                  <v-icon>{{'bi bi-eye'}}</v-icon>
                </v-btn>
                <!--v-btn @click="$root.Url('update-'+$root.url.c,row.name)" color="indigo" icon dark x-small>
                  <v-icon>{{'bi bi-pencil-square'}}</v-icon>
                </v-btn-->
                <v-btn v-if="$root.url.permission.includes('delete')" @click="$root.Url('delete-'+$root.url.c,row.name)" color="red" icon dark x-small>
                  <v-icon>{{'bi bi-trash'}}</v-icon>
                </v-btn>
              </v-card-actions>
            </v-card>
          </v-col>
        </v-row>
      </template>
      <template v-slot:footer>
        <v-row class="mt-2" align="center" justify="center">
          <v-spacer></v-spacer>
          <v-menu offset-y>
            <template v-slot:activator="{ on, attrs }">
              <v-btn text color="primary" class="ml-2" v-bind="attrs" v-on="on">
                {{ iterator.items_per_page }}
                <v-icon>mdi-chevron-down</v-icon>
              </v-btn>
            </template>
            <v-list dense>
              <v-list-item v-for="n in 5" :key="n" @click="iterator.items_per_page=(n*iterator.items_per_page)">
                <v-list-item-title>{{ n*iterator.items_per_page }}</v-list-item-title>
              </v-list-item>
            </v-list>
          </v-menu>
          <v-spacer></v-spacer>
          <v-btn fab color="blue darken-3" class="mr-1" @click="prevPage" :disabled="iterator.page>1?false:true">
            <v-icon>bi-chevron-left</v-icon>
          </v-btn>
          <v-btn fab color="blue darken-3" class="mr-1" @click="nextPage" :disabled="iterator.page<number_of_pages?false:true">
            <v-icon>bi-chevron-right</v-icon>
          </v-btn>
          <v-spacer></v-spacer>
        </v-row>
      </template>
    </v-data-iterator>
  </v-sheet>
  `,
  data:()=>{
    return {
      page:{
        title:'module.database'
      },
      iterator:{
        items_per_page:12,
        page:1,
        search:null
      },
      tables:[],
    }
  },
  props:['action'],
  computed:{
    number_of_pages(){
      return Math.ceil(this.tables.length/this.iterator.items_per_page)
    }
  },
  methods:{
    Data:function() {
      this.$emit('loading-screen')
      axios.post(this.$root.url.c+'/get')
      .then((response)=>{
        this.tables = response.data
        this.$emit('loading-screen',false)
      })
    },
    editItem (item) {
      this.editedIndex = this.desserts.indexOf(item)
      this.editedItem = Object.assign({}, item)
      this.dialog = true
    },
    prevPage () {
      if (this.iterator.page-1 >= 1) this.iterator.page -= 1
    },
    nextPage () {
      if (this.iterator.page+1 <= this.number_of_pages) this.iterator.page += 1
    },
  },
  created:function() {
    this.Data();
  }
})
Vue.component('create-database',{
  template: `
  <v-card>
    <v-card-title>{{title}} - Crear tabla "{{form.name}}"</v-card-title>
    <v-card-text>
      <v-form v-on:submit.prevent="Save()">
        <v-row class="mb-2">
          <v-col cols="12" md="12">
            <v-text-field v-model="form.name" label="Nombre de la Tabla"></v-text-field>
          </v-col>
          <v-col cols="12" md="12">
            <v-simple-table>
              <template v-slot:default>
                <thead>
                  <tr>
                    <td colspan="8" class="text-center"><strong>CAMPOS</strong></td>
                  </tr>
                  <tr>
                    <td>Nombre</td>
                    <td>Tipo</td>
                    <td>Longitud</td>
                    <td>Sin Signo</td>
                    <td><i>NULL</i>?</td>
                    <td>Auto-Incrementar</td>
                    <td>Predeterminado</td>
                    <td></td>
                  </tr>
                </thead>
                <tbody>
                  <tr v-for="(field,f) in form.fields">
                    <td><v-text-field v-model="form.fields[f]['name']" dense></v-text-field></td>
                    <td>
                      <v-select v-model="form.fields[f]['type']" :items="option.type" item-text="item" item-value="item" dense></v-select>
                    </td>
                    <td><v-text-field v-model="form.fields[f]['length']" dense></v-text-field></td>
                    <td><v-checkbox v-model="form.fields[f]['unsigned']" dense></v-checkbox></td>
                    <td><v-checkbox v-model="form.fields[f]['nullable']" dense></v-checkbox></td>
                    <td><v-checkbox v-model="form.fields[f]['auto_increment']" dense></v-checkbox></td>
                    <td><v-text-field v-model="form.fields[f]['default']" dense></v-text-field></td>
                    <td></td>
                  </tr>
                </tbody>
                <tfoot>
                  <tr>
                    <td colspan="6" class="text-center"></td>
                    <td colspan="2" class="text-center">
                      <v-btn @click="addField">CAMPOS</v-btn>
                    </td>
                  </tr>
                </tfoot>
              </template>
            </v-simple-table>
          </v-col>
          <v-col cols="12" md="12">
            <v-simple-table>
              <template v-slot:default>
                <thead>
                  <tr>
                    <td colspan="8" class="text-center"><strong>CLAVES PRIMARIAS</strong></td>
                  </tr>
                  <tr>
                    <td width="20%">Indice</td>
                    <td width="80%">Campos</td>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>Primary</td>
                    <td>
                      <v-select v-model="form.index.primary" :items="form.fields" item-text="name" item-value="name" multiple dense small-chips="true" prepend-icon="bi-key" chips color="orange" item-color="orange">
                        <template v-slot:selection="{item}">
                          <v-chip color="orange" small>{{item.name}}</v-chip>
                        </template>
                      </v-select>
                    </td>
                  </tr>
                  <tr>
                    <td>Key</td>
                    <td>
                      <v-select v-model="form.index.key" :items="form.fields" item-text="name" item-value="name" multiple dense small-chips="true" prepend-icon="bi-key" chips color="green" item-color="green">
                        <template v-slot:selection="{item}">
                          <v-chip color="green" small>{{item.name}}</v-chip>
                        </template>
                      </v-select>
                    </td>
                  </tr>
                  <tr>
                    <td>Unique</td>
                    <td>
                      <v-select v-model="form.index.unique" :items="form.fields" item-text="name" item-value="name" multiple dense small-chips="true" prepend-icon="bi-key" chips color="red" item-color="red">
                        <template v-slot:selection="{item}">
                          <v-chip color="red" small>{{item.name}}</v-chip>
                        </template>
                      </v-select>
                    </td>
                  </tr>
                </tbody>
              </template>
            </v-simple-table>
          </v-col>
          <!--v-col cols="12" md="12">
            <v-simple-table>
              <template v-slot:default>
                <thead>
                  <tr>
                    <td colspan="7" class="text-center"><strong>CLAVES FORANEAS</strong></td>
                  </tr>
                  <tr>
                    <td>Campos</td>
                    <td>Referencia</td>
                    <td>Campos foraneos</td>
                    <td>En <strong>UPDATE</strong></td>
                    <td>En <strong>DELETE</strong></td>
                    <td></td>
                  </tr>
                </thead>
                <tbody>
                  <tr v-for="(key,k) in form.keys">
                    <td>{{form.keys[k]['fields']}}</td>
                    <td>{{form.keys[k]['table']}}</td>
                    <td>{{form.keys[k]['foreign_fields']}}</td>
                    <td>{{form.keys[k]['on_update']}}</td>
                    <td>{{form.keys[k]['on_delete']}}</td>
                    <td></td>
                  </tr>
                </tbody>
                <tfoot>
                  <tr>
                    <td><v-select v-model="key.fields" :items="form.fields" item-text="name" item-value="name" small-chips chips multiple dense></v-select></td>
                    <td><v-select v-model="key.table" @change="fillOptions(key.table)" :items="option.tables" item-text="item" item-value="item" dense></v-select></td>
                    <td><v-select v-model="key.foreign_fields" :items="option.fields" item-text="item" item-value="item" multiple dense></v-select></td>
                    <td><v-select v-model="key.on_update" :items="option.on_action" item-text="item" item-value="item" dense></v-select></td>
                    <td><v-select v-model="key.on_delete" :items="option.on_action" item-text="item" item-value="item" dense></v-select></td>
                    <td><v-btn @click="addKey(key)" fab x-small><v-icon>ri-save-3-line</v-icon></v-btn></td>
                  </tr>
                </tfoot>
              </template>
            </v-simple-table>
          </v-col-->
        </v-row>
        <v-card-actions class="text-center">
          <v-btn type="submit" color="success">
            <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
          </v-btn>
        </v-card-actions>
      </v-form>
    </v-card-text>
  </v-card>
  `,
  data:()=>{
    return {
      form:{
        name:'Tabla',
        fields:[],
        index:{
          primary:[],
          key:[],
          unique:[],
        },
        keys:[]
      },
      key:{
        fields:[],
        table:'',
        foreign_fields:[],
        on_update:'RESTRICT',
        on_delete:'RESTRICT'
      },
      option:{
        type:[
          'TINYINT',
          'SMALLINT',
          'MEDIUMINT',
          'INT',
          'BIGINT',
          'BIT',

          'FLOAT',
          'DOUBLE',
          'DECIMAL',

          'VARCHAR',
          'CHAR',
          'TINYTEXT',
          'TEXT',
          'MEDIUMTEXT',
          'LONGTEXT',
          'JSON',

          'DATE',
          'TIME',
          'YEAR',
          'DATETIME',
          'TIMESTAMP'
        ],
        tables:[],
        fields:[],
        on_action:['RESTRICT','CASCADE','SET NULL','NO ACTION']
      }
    }
  },
  props:['title'],
  methods:{
    Save:function() {
      this.$emit('loading-screen')
      axios.post('Database/add',{
        data:this.form
      })
      .then((response)=>{
        var code = response.data.status
        var message = response.data.message
        if (response.data.status==500) {
          this.$root.toast.show({
            message: 'Error:'+response.data.message.code+' - '+response.data.message.message,
            color:'success',
            icon: 'bi-check'
          })
        } else{
          this.$root.Url('database')
        }
        this.$emit('loading-screen',false)
      })
    },
    tableFields:function() {
      axios.post(this.$root.url.c+'/get')
      .then((response)=>{
        this.option.tables = response.data
      })
    },
    fillOptions:function(table=null) {
      axios.post(this.$root.p+'/get_tables/'+this.key.table+'?field=name')
      .then((response)=>{
        this.option.fields = response.data
      })
    },
    addField() {
      var count = this.form.fields.length+1
      this.form.fields.push({...{
        name:'campo_'+count,
        type:'VARCHAR',
        length:'255',
        unsigned:false,
        nullable:true,
        auto_increment:false,
        default:''
      }})
    },
    addKey(data) {
      var count = this.form.keys.length+1
      this.form.keys.push({... data })
      this.key = {
        fields:[],
        table:'',
        foreign_fields:[],
        on_update:'RESTRICT',
        on_delete:'RESTRICT'
      }
    }
  },
  created:function() {
    axios.post('Database/get')
    .then((response)=>{
      this.option.tables = response.data
      this.$emit('loading-screen',false)
    })
  }
})
Vue.component('read-database',{
  template: `
  <v-sheet fluid>
    <v-toolbar>
      <v-toolbar-title>{{table.name}}</v-toolbar-title>
      <v-spacer></v-spacer>

      <v-btn :color="expand?'teal':'red darken-2'" @click="expand.info=!expand.info" fab small>
        <v-icon>bi-info-circle</v-icon>
      </v-btn>
      <v-btn :color="expand?'cyan':'red darken-2'" @click="expand.component=!expand.component" fab small>
        <v-icon>bi-node-plus</v-icon>
      </v-btn>
    </v-toolbar>
    <v-row>
      <v-col cols="12" md="12" v-show="expand.info">
        <v-simple-table>
          <template v-slot:default>
            <thead v-if="table.fields">
              <tr>
                <th v-for="field in Object.keys(table.fields[0])">{{field}}</th>
              <tr>
            </thead>
            <tbody>
              <tr v-for="fields in table.fields">
                <th v-for="field in Object.keys(fields)">{{fields[field]}}</th>
              <tr>
            </tbody>
          </template>
        </v-simple-table>
      </v-col>
      <v-col cols="12" md="12" v-show="expand.component">
        <v-data-table :headers="headers" :items="components" class="elevation-1">
          <template v-slot:top>
            <v-toolbar flat>
              <v-toolbar-title>{{$t('section.component')}} | {{table.name}}</v-toolbar-title>
            </v-toolbar>
          </template>
          <template v-slot:item="row">
            <tr>
              <td>{{row.item.name}}</td>
              <td>{{row.item.codename}}</td>
              <td width="10%">
                <v-btn @click="$root.Url('update-component',row.item.ID)" color="indigo" fab x-small>
                  <v-icon>bi-pencil-square</v-icon>
                </v-btn>
                <v-btn @click="$root.Url('delete-component',row.item.ID)" color="error" fab x-small>
                  <v-icon>bi-trash</v-icon>
                </v-btn>
              </td>
            </tr>
          </template>
        </v-data-table>
      </v-col>
      <v-col cols="12" md="12">
        <v-toolbar>
          <v-toolbar-title>CRUD Builder</v-toolbar-title>
          <v-spacer></v-spacer>
          <v-btn-toggle v-model="crud" rounded multiple mandatory>
            <v-btn value="create" :outlined="crud.includes('create')?true:false" color="teal" small>
              <v-icon>bi-plus</v-icon>
            </v-btn>
            <v-btn value="read" :outlined="crud.includes('read')?true:false" color="blue" small @click="read.form.data==''?getFieldsData([$root.url.id],'read'):null">
              <v-icon>bi-list</v-icon>
            </v-btn>
            <v-btn value="update" :outlined="crud.includes('update')?true:false" color="cyan" small @click="update.form.data==''?getFieldsData($root.url.id,'update'):null">
              <v-icon>bi-pencil-square</v-icon>
            </v-btn>
            <v-btn value="view" :outlined="crud.includes('view')?true:false" color="purple" small @click="view.form.data==''?getFieldsData([$root.url.id],'view'):null">
              <v-icon>bi-eye</v-icon>
            </v-btn>
          </v-btn-toggle>
        </v-toolbar>
      </v-col>
    </v-row>
    <v-form v-on:submit.prevent="Save()" class="card">
      <v-row>
        <v-col cols="12" md="12">
          <v-btn-toggle v-model="crud_active" mandatory>
            <v-btn v-for="(c,i) in crud" :key="'crud-builder-'+c" :color="crud_active==c?'red':'teal'" :value="c">
              <v-icon v-if="c=='create'">bi-plus</v-icon>
              <v-icon v-if="c=='read'">bi-list</v-icon>
              <v-icon v-if="c=='update'">bi-pencil-square</v-icon>
              <v-icon v-if="c=='view'">bi-eye</v-icon>{{$t('action.'+c)}}
            </v-btn>
          </v-btn-toggle>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='create'">
          <v-card>
            <v-card-title>{{$t('action.add')}}&nbsp;<strong v-html="create.form.name?create.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="8">
                  <v-text-field v-model="create.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="4">
                  <v-text-field v-model="create.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="create.form.type" mandatory>
                    <v-btn v-for="(item,i) in create.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <component is="visual-builder" :fields="create.form.data" :template="create.form.template" type="grid" :database="database"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='read'">
          <v-card>
            <v-card-title>{{$t('action.list')}}&nbsp;<strong v-html="read.form.name?read.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="6">
                  <v-text-field v-model="read.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-text-field v-model="read.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-select v-model="read.form.query.from" @change="getFieldsData(read.form.query.from,'read')" label="Tablas de Datos" :items="database.tables" item-text="name" multiple item-value="name"></v-select>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="read.form.type" mandatory>
                    <v-btn v-for="(item,i) in read.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
              <component is="query-builder" :query="read.form.query" :fields="read.form.data"></component>
              <v-subheader>CONFIGURACION DE DATOS</v-subheader>
              <component is="visual-builder" :fields="read.form.data" :template="read.form.template" :type="read.form.type=='basic'?'table':read.form.type" :props="read.form.props"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='update'">
          <v-card>
            <v-card-title>{{$t('action.add')}}&nbsp;<strong v-html="update.form.name?update.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="8">
                  <v-text-field v-model="update.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="4">
                  <v-text-field v-model="update.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="update.form.type" mandatory>
                    <v-btn v-for="(item,i) in update.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <component is="visual-builder" :fields="update.form.data" :template="update.form.template" type="grid" :database="database"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='view'">
          <v-card>
            <v-card-title>{{$t('action.list')}}&nbsp;<strong v-html="view.form.name?view.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="6">
                  <v-text-field v-model="view.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-text-field v-model="view.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-select v-model="view.form.query.from" @change="getFieldsData(view.form.query.from,'view')" label="Tablas de Datos" :items="database.tables" item-text="name" multiple item-value="name"></v-select>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="view.form.type" mandatory>
                    <v-btn v-for="(item,i) in view.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
              <component is="query-builder" :query="view.form.query" :fields="view.form.data"></component>
              <v-subheader>CONFIGURACION DE DATOS</v-subheader>
              <component is="visual-builder" :fields="view.form.data" :template="view.form.template" type="grid"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col>
          <v-btn type="submit">
            <v-icon>bi-cloud-arrow-up</v-icon>&nbsp;{{$t('action.save')}}
          </v-btn>
        </v-col>
      </v-row>
    </v-form>
  </v-sheet>
  `,
  data:()=>{
    return {
      table:[],
      components:[],
      crud:[],
      crud_active:'create',
      expand:{
        info:false,
        component:true
      },
      create:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:'',
          template:'create',
          type:'',
          query:{
            rule:[],
            group:[]
          },
          props:{
            after_send:{
              path:null,
              key:null
            },
            success_message:'form.response.success',
            error_message:'form.response.error',
            btn_text:'action.save'
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      read:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:'',
          template:'read',
          type:'basic',
          query:{
            from:[],
            rule:[],
            group:[]
          },
          props:{
            view:null,
            update:null,
            remove:true,
            md:4,
            maps:{
              center:{lat:6.795535,lng:-64.379883},
              zoom:5,
              layers:['https://mt1.google.com/vt/lyrs=r&x={x}&y={y}&z={z}'],
              geojson:[],
              icons:[]
            }
          }
        },
        type_templates:[
          {
            icon:'bi-table',
            value:'basic',
            text:'Tabla',
          },
          {
            icon:'bi-card-text',
            value:'card',
            text:'Tarjetas',
          },
          {
            icon:'bi-map',
            value:'map',
            text:'Mapa',
          }
        ],
      },
      update:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:'',
          template:'update',
          type:'',
          query:{
            rule:[],
            group:[]
          },
          props:{
            after_send:{
              path:null,
              key:null
            },
            success_message:'form.response.success',
            error_message:'form.response.error',
            btn_text:'action.update'
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      view:{
        form:{
          name:'',
          codename:'',
          data:'',
          table:'',
          template:'view',
          type:'',
          query:{
            from:[],
            rule:[],
            group:[]
          },
          props:{
            update:null,
            remove:true
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      database:{
        tables:[],
        options:[],
        fields:[]
      },
      headers:[
        {
          text:'Componente',
          align:'start',
          sortable:false,
          value:'name'
        },
        {text:'Tag de Componente',value:'codename'},
        {text:'...'}
      ],
    }
  },
  props:['action'],
  methods:{
    Data:function() {
      this.$emit('loading-screen')
      axios.post('Database/get/'+this.$root.url.id)
      .then((response)=>{
        this.table = response.data
      })
      axios.post('Component/get/'+this.$root.url.id,{
        where:{
          table:this.$root.url.id
        }
      })
      .then((response)=>{
        this.components = response.data
        this.$emit('loading-screen',false)
      })
    },
    Save:function() {
      this.$emit('loading-screen')
      var final_form = {}
      for (var i = 0; i < this.crud.length; i++) {
        this.$set(final_form,this.crud[i],this[this.crud[i]].form)
        this.crud[i]
      }
      axios.post('Component/add',final_form)
      .then((response)=>{
        this.table = response.data
        this.$emit('loading-screen',false)
      })
    },
    getFieldsData:function(t,c='create') {
      if (Array.isArray(t)) {
        var tables = [this.$root.url.id]
        for (i = 0; i < t.length; i++) {
          if (t[i]!==this.$root.url.id) {
            tables.push(t[i])
          }
        }
        axios.post('Database/fields',{
          tables:tables
        }).then((response)=>{
          this[c].form.data = response.data
        })
      } else {
        axios.post('Database/fields/'+t).then((response)=>{
          this[c].form.data = response.data
        })
      }
    },
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    }
  },
  mounted:function() {
    this.create.form.codename = this.$root.GenerateID()
    this.read.form.codename = this.$root.GenerateID()
    this.update.form.codename = this.$root.GenerateID()
    this.view.form.codename = this.$root.GenerateID()
    axios.post('Database/get')
    .then((response)=>{
      this.database.tables = response.data

      this.create.form.table = this.$root.url.id;
      this.read.form.table = this.$root.url.id;
      this.update.form.table = this.$root.url.id;
      this.view.form.table = this.$root.url.id;

    })
    this.getFieldsData(this.$root.url.id,'create')
    this.Data();
  }
})
Vue.component('update-component',{
  template: `
  <v-sheet fluid>
    <v-toolbar>
      <v-toolbar-title>{{$t('action.update')}} {{$t('section.component')}}</v-toolbar-title>
      <v-spacer></v-spacer>

      <v-btn color="blue lighten-2" @click="$root.Url('database')" fab small>
        <v-icon>bi-arrow-left-circle</v-icon>
      </v-btn>
    </v-toolbar>
    <v-form v-on:submit.prevent="Save()" class="card">
      <v-row>
        <v-col cols="12" md="12" v-show="crud_active=='create'">
          <v-card>
            <v-card-title>{{$t('action.add')}}&nbsp;<strong v-html="create.form.name?create.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="8">
                  <v-text-field v-model="create.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="4">
                  <v-text-field v-model="create.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="create.form.type" mandatory>
                    <v-btn v-for="(item,i) in create.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <component is="visual-builder" :fields="create.form.data" :template="create.form.template" type="grid" :database="database"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='read'">
          <v-card>
            <v-card-title>{{$t('action.list')}}&nbsp;<strong v-html="read.form.name?read.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="6">
                  <v-text-field v-model="read.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-text-field v-model="read.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-select v-model="read.form.query.from" @change="getFieldsData(read.form.query.from,'read')" label="Tablas de Datos" :items="database.tables" item-text="name" multiple item-value="name"></v-select>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="read.form.type" mandatory>
                    <v-btn v-for="(item,i) in read.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
              <component is="query-builder" :query="read.form.query" :fields="read.form.data"></component>
              <v-subheader>CONFIGURACION DE DATOS</v-subheader>
              <component is="visual-builder" :fields="read.form.data" :template="read.form.template" :type="read.form.type=='basic'?'table':read.form.type" :props="read.form.props"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='update'">
          <v-card>
            <v-card-title>{{$t('action.add')}}&nbsp;<strong v-html="update.form.name?update.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="8">
                  <v-text-field v-model="update.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="4">
                  <v-text-field v-model="update.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="update.form.type" mandatory>
                    <v-btn v-for="(item,i) in update.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <component is="visual-builder" :fields="update.form.data" :template="update.form.template" type="grid" :database="database"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='view'">
          <v-card>
            <v-card-title>{{$t('action.list')}}&nbsp;<strong v-html="view.form.name?view.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="6">
                  <v-text-field v-model="view.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-text-field v-model="view.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-select v-model="view.form.query.from" @change="getFieldsData(view.form.query.from,'view')" label="Tablas de Datos" :items="database.tables" item-text="name" multiple item-value="name"></v-select>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="view.form.type" mandatory>
                    <v-btn v-for="(item,i) in view.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
              <component is="query-builder" :query="view.form.query" :fields="view.form.data"></component>
              <v-subheader>CONFIGURACION DE DATOS</v-subheader>
              <component is="visual-builder" :fields="view.form.data" :template="view.form.template" type="grid"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col>
          <v-btn type="submit" fab color="success">
            <v-icon>bi-cloud-arrow-up</v-icon>
          </v-btn>
        </v-col>
      </v-row>
    </v-form>
  </v-sheet>
  `,
  data:()=>{
    return {
      table:[],
      form:[],
      crud:[],
      crud_active:'',
      expand:{
        info:false,
        component:true
      },
      create:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:{},
          template:'create',
          type:'',
          query:{
            rule:[],
            group:[]
          },
          props:{
            after_send:{
              path:null,
              key:null
            },
            success_message:'form.response.success',
            error_message:'form.response.error',
            btn_text:'action.save'
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      read:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:{},
          template:'read',
          type:'basic',
          query:{
            from:[],
            rule:[],
            group:[]
          },
          props:{
            view:null,
            update:null,
            remove:true,
            md:4,
            maps:{
              center:{lat:6.795535,lng:-64.379883},
              zoom:5,
              layers:['https://mt1.google.com/vt/lyrs=r&x={x}&y={y}&z={z}'],
              geojson:[],
              icons:[]
            }
          }
        },
        type_templates:[
          {
            icon:'bi-table',
            value:'basic',
            text:'Tabla',
          },
          {
            icon:'bi-card-text',
            value:'card',
            text:'Tarjetas',
          },
          {
            icon:'bi-map',
            value:'map',
            text:'Mapa',
          },
          {
            icon:'bx-map',
            value:'merge',
            text:'Capa de Mapa',
          }
        ]
      },
      update:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:[],
          template:'update',
          type:'',
          query:{
            rule:[],
            group:[]
          },
          props:{
            after_send:{
              path:null,
              key:null
            },
            success_message:'form.response.success',
            error_message:'form.response.error',
            btn_text:'action.update'
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      view:{
        form:{
          name:'',
          codename:'',
          data:[],
          table:'',
          template:'view',
          type:'',
          query:{
            from:[],
            rule:[],
            group:[]
          },
          props:{
            update:null,
            remove:true
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      database:{
        tables:[],
        options:[],
        fields:[]
      }
    }
  },
  props:['action'],
  methods:{
    Data:function() {
      this.$emit('loading-screen')
      axios.post('Component/get',{
        where:{
          ID:this.$root.url.id
        },
        result:'row'
      }).then((response)=>{
        this.form = response.data
        this.crud_active = this.form.template
        this[this.form.template].form = this.form
        this.$emit('loading-screen',false)
      })
    },
    Save:function() {
      this.$emit('loading-screen')
      var final_form = this[this.crud_active].form
      axios.post('Component/set/'+this.$root.url.id,final_form)
      .then((response)=>{
        this.table = response.data
        this.$emit('loading-screen',false)
      })
    },
    getFieldsData:function(t,c='create') {
      if (t) {
        if (Array.isArray(t)) {
          var tables = [this[this.crud_active].form.table]
          for (i = 0; i < t.length; i++) {
            if (t[i]!==this[this.crud_active].form.table) {
              tables.push(t[i])
            }
          }
          axios.post('Database/fields',{
            tables:tables
          }).then((response)=>{
            this[c].form.data = response.data
          })
        } else {
          axios.post('Database/fields/'+t).then((response)=>{
            this[c].form.data = response.data
          })
        }
      }
    },
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    }
  },
  mounted:function() {
    axios.post('Database/get')
    .then((response)=>{
      this.database.tables = response.data
    })
    this.Data();
  }
})
Vue.component('merge-database',{
  template: `
  <v-sheet fluid>
    <v-toolbar>
      <v-toolbar-title>{{table.name}}</v-toolbar-title>
      <v-spacer></v-spacer>

      <v-btn :color="expand?'teal':'red darken-2'" @click="expand.info=!expand.info" fab small>
        <v-icon>bi-info-circle</v-icon>
      </v-btn>
      <v-btn :color="expand?'cyan':'red darken-2'" @click="expand.component=!expand.component" fab small>
        <v-icon>bi-node-plus</v-icon>
      </v-btn>
    </v-toolbar>
    <v-row>
      <v-col cols="12" md="12" v-show="expand.info">
        <v-simple-table>
          <template v-slot:default>
            <thead v-if="table.fields">
              <tr>
                <th v-for="field in Object.keys(table.fields[0])">{{field}}</th>
              <tr>
            </thead>
            <tbody>
              <tr v-for="fields in table.fields">
                <th v-for="field in Object.keys(fields)">{{fields[field]}}</th>
              <tr>
            </tbody>
          </template>
        </v-simple-table>
      </v-col>
      <v-col cols="12" md="12" v-show="expand.component">
        <v-data-table :headers="headers" :items="components" class="elevation-1">
          <template v-slot:top>
            <v-toolbar flat>
              <v-toolbar-title>{{$t('section.component')}} | {{table.name}}</v-toolbar-title>
            </v-toolbar>
          </template>
          <template v-slot:item="row">
            <tr>
              <td>{{row.item.name}}</td>
              <td>{{row.item.codename}}</td>
              <td width="10%">
                <v-btn @click="$root.Url('update-component',row.item.ID)" color="indigo" fab x-small>
                  <v-icon>bi-pencil-square</v-icon>
                </v-btn>
                <v-btn @click="$root.Url('delete-component',row.item.ID)" color="error" fab x-small>
                  <v-icon>bi-trash</v-icon>
                </v-btn>
              </td>
            </tr>
          </template>
        </v-data-table>
      </v-col>
      <v-col cols="12" md="12">
        <v-toolbar>
          <v-toolbar-title>CRUD Builder</v-toolbar-title>
          <v-spacer></v-spacer>
          <v-btn-toggle v-model="crud" rounded multiple mandatory>
            <v-btn value="create" :outlined="crud.includes('create')?true:false" color="teal" small>
              <v-icon>bi-plus</v-icon>
            </v-btn>
            <v-btn value="read" :outlined="crud.includes('read')?true:false" color="blue" small @click="read.form.data==''?getFieldsData([$root.url.id],'read'):null">
              <v-icon>bi-list</v-icon>
            </v-btn>
            <v-btn value="update" :outlined="crud.includes('update')?true:false" color="cyan" small @click="update.form.data==''?getFieldsData($root.url.id,'update'):null">
              <v-icon>bi-pencil-square</v-icon>
            </v-btn>
            <v-btn value="view" :outlined="crud.includes('view')?true:false" color="purple" small @click="view.form.data==''?getFieldsData([$root.url.id],'view'):null">
              <v-icon>bi-eye</v-icon>
            </v-btn>
          </v-btn-toggle>
        </v-toolbar>
      </v-col>
    </v-row>
    <v-form v-on:submit.prevent="Save()" class="card">
      <v-row>
        <v-col cols="12" md="12">
          <v-btn-toggle v-model="crud_active" mandatory>
            <v-btn v-for="(c,i) in crud" :key="'crud-builder-'+c" :color="crud_active==c?'red':'teal'" :value="c">
              <v-icon v-if="c=='create'">bi-plus</v-icon>
              <v-icon v-if="c=='read'">bi-list</v-icon>
              <v-icon v-if="c=='update'">bi-pencil-square</v-icon>
              <v-icon v-if="c=='view'">bi-eye</v-icon>{{$t('action.'+c)}}
            </v-btn>
          </v-btn-toggle>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='create'">
          <v-card>
            <v-card-title>{{$t('action.add')}}&nbsp;<strong v-html="create.form.name?create.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="8">
                  <v-text-field v-model="create.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="4">
                  <v-text-field v-model="create.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="create.form.type" mandatory>
                    <v-btn v-for="(item,i) in create.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <component is="visual-builder" :fields="create.form.data" :template="create.form.template" type="grid" :database="database"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='read'">
          <v-card>
            <v-card-title>{{$t('action.list')}}&nbsp;<strong v-html="read.form.name?read.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="6">
                  <v-text-field v-model="read.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-text-field v-model="read.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-select v-model="read.form.query.from" @change="getFieldsData(read.form.query.from,'read')" label="Tablas de Datos" :items="database.tables" item-text="name" multiple item-value="name"></v-select>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="read.form.type" mandatory>
                    <v-btn v-for="(item,i) in read.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
              <component is="query-builder" :query="read.form.query" :fields="read.form.data"></component>
              <v-subheader>CONFIGURACION DE DATOS</v-subheader>
              <component is="visual-builder" :fields="read.form.data" :template="read.form.template" :type="read.form.type=='basic'?'table':read.form.type"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='update'">
          <v-card>
            <v-card-title>{{$t('action.add')}}&nbsp;<strong v-html="update.form.name?update.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="8">
                  <v-text-field v-model="update.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="4">
                  <v-text-field v-model="update.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="update.form.type" mandatory>
                    <v-btn v-for="(item,i) in update.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <component is="visual-builder" :fields="update.form.data" :template="update.form.template" type="grid" :database="database"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col cols="12" md="12" v-show="crud_active=='view'">
          <v-card>
            <v-card-title>{{$t('action.list')}}&nbsp;<strong v-html="view.form.name?view.form.name:'<i>Sin Nombre</i>'"></strong></v-card-title>
            <v-card-text>
              <v-row class="mb-2">
                <v-col cols="12" sm="12" md="6">
                  <v-text-field v-model="view.form.name" label="Nombre del Componente"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-text-field v-model="view.form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
                </v-col>
                <v-col cols="12" sm="12" md="3">
                  <v-select v-model="view.form.query.from" @change="getFieldsData(view.form.query.from,'view')" label="Tablas de Datos" :items="database.tables" item-text="name" multiple item-value="name"></v-select>
                </v-col>
                <v-divider></v-divider>
                <v-col cols="12" sm="12" md="12">
                  <v-btn-toggle v-model="view.form.type" mandatory>
                    <v-btn v-for="(item,i) in view.type_templates" :value="item.value" color="primary" small>
                      <v-icon>{{item.icon}}</v-icon>&nbsp;<strong>{{item.text}}</strong>
                    </v-btn>
                  </v-btn-toggle>
                </v-col>
              </v-row>
              <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
              <component is="query-builder" :query="view.form.query" :fields="view.form.data"></component>
              <v-subheader>CONFIGURACION DE DATOS</v-subheader>
              <component is="visual-builder" :fields="view.form.data" :template="view.form.template" type="grid"></component>
            </v-card-text>
          </v-card>
        </v-col>
        <v-col>
          <v-btn type="submit">
            <v-icon>bi-cloud-arrow-up</v-icon>&nbsp;{{$t('action.save')}}
          </v-btn>
        </v-col>
      </v-row>
    </v-form>
  </v-sheet>
  `,
  data:()=>{
    return {
      table:[],
      components:[],
      crud:[],
      crud_active:'create',
      expand:{
        info:false,
        component:true
      },
      create:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:'',
          template:'create',
          type:'',
          query:{
            rule:[],
            group:[]
          },
          props:{
            after_send:{
              path:null,
              key:null
            },
            success_message:'form.response.success',
            error_message:'form.response.error',
            btn_text:'action.save'
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      read:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:'',
          template:'read',
          type:'basic',
          query:{
            from:[],
            rule:[],
            group:[]
          },
          props:{
            view:null,
            update:null,
            remove:true,
            md:4,
            maps:{
              center:{lat:6.795535,lng:-64.379883},
              zoom:5,
              layers:['https://mt1.google.com/vt/lyrs=r&x={x}&y={y}&z={z}'],
              geojson:[],
              icons:[]
            }
          }
        },
        type_templates:[
          {
            icon:'bi-table',
            value:'basic',
            text:'Tabla',
          },
          {
            icon:'bi-card-text',
            value:'card',
            text:'Tarjetas',
          },
          {
            icon:'bi-map',
            value:'map',
            text:'Mapa',
          }
        ],
      },
      update:{
        form:{
          name:'',
          codename:'',
          table:'',
          data:'',
          template:'update',
          type:'',
          query:{
            rule:[],
            group:[]
          },
          props:{
            after_send:{
              path:null,
              key:null
            },
            success_message:'form.response.success',
            error_message:'form.response.error',
            btn_text:'action.update'
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      view:{
        form:{
          name:'',
          codename:'',
          data:'',
          table:'',
          template:'view',
          type:'',
          query:{
            from:[],
            rule:[],
            group:[]
          },
          props:{
            update:null,
            remove:true
          }
        },
        type_templates:[
          {
            icon:'bi-file-earmark-text',
            value:'basic',
            text:'Formulario Basico',
          }
        ],
      },
      database:{
        tables:[],
        options:[],
        fields:[]
      },
      headers:[
        {
          text:'Componente',
          align:'start',
          sortable:false,
          value:'name'
        },
        {text:'Tag de Componente',value:'codename'},
        {text:'...'}
      ],
    }
  },
  props:['action'],
  methods:{
    Data:function() {
      this.$emit('loading-screen')
      axios.post('Database/get/'+this.$root.url.id)
      .then((response)=>{
        this.table = response.data
      })
      axios.post('Component/get/'+this.$root.url.id,{
        where:{
          table:this.$root.url.id
        }
      })
      .then((response)=>{
        this.components = response.data
        this.$emit('loading-screen',false)
      })
    },
    Save:function() {
      this.$emit('loading-screen')
      var final_form = {}
      for (var i = 0; i < this.crud.length; i++) {
        this.$set(final_form,this.crud[i],this[this.crud[i]].form)
        this.crud[i]
      }
      axios.post('Component/add',final_form)
      .then((response)=>{
        this.table = response.data
        this.$emit('loading-screen',false)
      })
    },
    getFieldsData:function(t,c='create') {
      if (Array.isArray(t)) {
        var tables = [this.$root.url.id]
        for (i = 0; i < t.length; i++) {
          if (t[i]!==this.$root.url.id) {
            tables.push(t[i])
          }
        }
        axios.post('Database/fields',{
          tables:tables
        }).then((response)=>{
          this[c].form.data = response.data
        })
      } else {
        axios.post('Database/fields/'+t).then((response)=>{
          this[c].form.data = response.data
        })
      }
    },
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    }
  },
  mounted:function() {
    this.create.form.codename = this.$root.GenerateID()
    this.read.form.codename = this.$root.GenerateID()
    this.update.form.codename = this.$root.GenerateID()
    this.view.form.codename = this.$root.GenerateID()
    axios.post('Database/get')
    .then((response)=>{
      this.database.tables = response.data

      this.create.form.table = this.$root.url.id;
      this.read.form.table = this.$root.url.id;
      this.update.form.table = this.$root.url.id;
      this.view.form.table = this.$root.url.id;

    })
    this.getFieldsData(this.$root.url.id,'create')
    this.Data();
  }
})