Vue.component('file',{
  template: `
  <div class="page-content">
    <div class="container">
      <div class="row">
        <div v-for="(file,i) in files" @mouseover="extra.hover=i" @mouseleave="extra.hover=null" class="col-4 col-sm-4 col-md-2">
          <div class="card">
            <img v-if="file.encoded==true" :src="file.data" class="card-img-top" :alt="file.caption">
            <img v-else :src="'public/'+file.data" class="card-img" :alt="file.caption">
            <div class="card-body small p-1" v-show="extra.hover==i">
              <p class="card-text">
                {{file.name}} <i v-if="file.encoded==true" class="bi bi-file-earmark-lock2"></i><i v-else class="bi bi-folder-symlink"></i>
                <button type="button" class="btn btn-link text-danger btn-sm">
                  <i class="bi bi-trash"></i>
                </button>
                <br>
                <strong>Peso:</strong> {{file.size | filesize}} 
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  `,
  data:()=>{
    return {
      files:[],
      filter:{
        _like:{
          value:'',
          fields:['name','description','USD','PEN'],
        },
        brand:""
      },
      extra:{
        searching:true,
        brands:[],
        hover:null
      }
    }
  },
  props:[],
  methods:{
    Data:function() {
      axios.post('File/get')
      .then((response)=>{
        this.files = response.data
        this.extra.searching = false
      })
    }
  },
  created:function() {
    this.Data();
  }
})
Vue.component('file-add',{
  template: `
  <main class="main">
    <div class="row">
      <div class="col-md-12">
        <form v-on:submit.prevent="Save()" class="card">
          <div class="card-body">
            <h5 class="card-title">Agregar "{{form.name}}"</h5>
            <div class="row mb-2">
              <div class="col-md-6">
                <label>Nombre</label>
                <input v-model="form.name" class="form-control" type="text">
              </div>
              <div class="col-md-3">
                <label>Carpeta Base</label>
                <select v-model="form.folder" class="form-control">
                  <option value="general">General</option>
                  <option value="product">Productos</option>
                  <option value="post">Publicaciones</option>
                  <option value="system">Sistema</option>
                </select>
              </div>
              <div class="col-md-3">
                <label>Cifrar</label>
                <div class="row">
                  <div class="col-md-6">
                    <input v-model="form.encode" name="encode" class="custom-control-input" :value="true" id="encodeY" type="radio">
                    <label for="encodeY">SI</label>
                  </div>
                  <div class="col-md-6">
                    <input v-model="form.encode" name="encode" class="custom-control-input" :value="false" id="encodeN" type="radio">
                    <label for="encodeN">NO</label>
                  </div>
                </div>
              </div>
            </div>
            <div class="row mb-2">
              <div class="col-md-6">
                <label>Descripcion</label>
                <textarea v-model="form.description" class="form-control" rows="2"></textarea>
              </div>
              <div class="col-md-6">
                <label>Alt</label>
                <textarea v-model="form.caption" class="form-control" rows="2"></textarea>
              </div>
            </div>
            <div class="row mb-2">
              <div class="col-md-12">
                <label>Nombre</label>
                <input ref="file" class="form-control" type="file" multiple accept="image/*">
              </div>
            </div>
          </div>
          <div class="card-footer p-1 d-flex justify-content-between">
            <button type="submit" class="btn btn-success btn-sm">
              <i class="bi bi-cloud-arrow-up"></i> Guardar
            </button>
          </div>
        </form>
      </div>
    </div>
  </main>
  `,
  data:()=>{
    return {
      form:{
        folder:'general',
        name:'',
        description:'',
        caption:'',
        encode:false
      },
      extra:{
        file:[]
      }
    }
  },
  props:[],
  methods:{
    Save:function() {
      this.extra.file = this.$refs.file.files
      var total_files = this.$refs.file.files.length
      let formData = new FormData();

      for (var i=0; i<total_files;i++) {
        formData.append('file[]',this.extra.file[i])
      }
      formData.append('folder',this.form.folder)
      formData.append('name',this.form.name)
      formData.append('description',this.form.description)
      formData.append('caption',this.form.caption)
      formData.append('encode',this.form.encode)

      axios.post('File/upload',formData,{
        headers:{
          'Content-Type': 'multipart/form-data'
        }
      })
      .then((response)=>{
        router.push({query:{p:this.$root.p,a:'List'}})
      })
    }
  }
})