Vue.component('module',{
  template: `
  <div>
    <v-row align="center" justify="space-around">
      <v-col cols="12" md="6">
        <v-card>
          <v-card-title>
            <v-icon class="mr-1">bi-node-plus</v-icon> Componentes
          </v-card-title>
          <v-card-text>
            <v-btn color="success" @click="$root.GetPage('module','addCreate')">
              <v-icon left>bi bi-plus</v-icon>Agregar
            </v-btn>
            <v-btn color="primary" @click="$root.GetPage('module','addRead')">
              <v-icon left>bi bi-list</v-icon>Listar
            </v-btn>
            <v-btn color="info" @click="$root.GetPage('module','addUpdate')">
              <v-icon left>bi bi-pencil-square</v-icon>Actualizar
            </v-btn>
            <v-btn color="secondary" @click="$root.GetPage('module','addView')">
              <v-icon left>bi bi-eye</v-icon>Ver
            </v-btn>
          </v-card-text>
        </v-card>
      </v-col>
      <v-col cols="12" md="6">
        <v-card>
          <v-card-title>
            <v-icon class="mr-1">bi-pie-chart</v-icon> Data Componentes
          </v-card-title>
          <v-card-text>
            <v-btn color="success" @click="$root.GetPage('module','addChart')">
              <v-icon left>bi bi-bar-chart</v-icon> Grafico
            </v-btn>
            <v-btn color="primary" @click="$root.GetPage('module','addCount')">
              <v-icon left>ri-number-8</v-icon> Contador
            </v-btn>
            <v-btn color="primary" @click="$root.GetPage('module','addOption')">
              <v-icon left>ri-list-check-2</v-icon> Lista
            </v-btn>
          </v-card-text>
        </v-card>
      </v-col>
    </v-row>
    <v-row>
      <v-col cols="12" md="12">
        <v-data-table :headers="headers" :items="components" class="elevation-1">
          <template v-slot:top>
            <v-toolbar flat>
              <v-toolbar-title>{{title}}</v-toolbar-title>
            </v-toolbar>
          </template>
          <template v-slot:item="row">
            <tr>
              <td>{{row.item.name}}</td>
              <td>{{row.item.codename}}</td>
              <td width="10%">
                <v-btn v-if="action.includes('read')" @click="$router.push({query:{p:$root.p,a:'read'}})" color="teal" icon dark x-small>
                  <v-icon>{{'bi bi-eye'}}</v-icon>
                </v-btn>
                <v-btn v-if="action.includes('update')" @click="$router.push({query:{p:$root.p,a:'update',pk:row.item.ID}})" color="indigo" icon dark x-small>
                  <v-icon>{{'bi bi-pencil-square'}}</v-icon>
                </v-btn>
                <v-btn v-if="action.includes('delete')" @click="$router.push({query:{p:$root.p,a:'delete',pk:row.item.ID}})" color="red" icon dark x-small>
                  <v-icon>{{'bi bi-trash'}}</v-icon>
                </v-btn>
                <v-btn @click="$root.GetPage(row.item.codename,null,null,'preview')" color="red" icon dark x-small>
                  <v-icon>{{'bi bi-search'}}</v-icon>
                </v-btn>
              </td>
            </tr>
          </template>
        </v-data-table>
      </v-col>
    </v-row>
  </div>
  `,
  data:()=>{
    return {
      components:[],
      dialog:false,
      dialogDelete:false,
      headers:[
        {
          text:'Componente',
          align:'start',
          sortable:false,
          value:'name'
        },
        {text:'Tag de Componente',value:'codename'},
        {text:'...'}
      ],
      pagination:{
        page:1,
        per_page:50,
        total_rows:100
      }
    }
  },
  props:['action','title'],
  methods:{
    Data:function() {
      axios.post('Module/get',{
        pagination:this.pagination,
      })
      .then((response)=>{
        this.components = response.data.results
        this.pagination.per_page = response.data.per_page
        this.pagination.total_rows = Number(response.data.total_rows)
      })
    },
    editItem (item) {
      this.editedIndex = this.desserts.indexOf(item)
      this.editedItem = Object.assign({}, item)
      this.dialog = true
    },
  },
  created:function() {
    document.title = this.title
    this.Data();
  }
})

Vue.component('module-addCreate',{
  template: `
  <v-card>
    <v-card-title>{{title}} "{{form.name}}"</v-card-title>
    <v-card-text>
      <v-form v-on:submit.prevent="Save()" class="card">
        <v-row class="mb-2">
          <v-col cols="12" sm="12" md="4">
            <v-text-field v-model="form.name" label="Nombre del Componente"></v-text-field>
          </v-col>
          <v-col cols="12" sm="12" md="4">
            <v-text-field v-model="form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
          </v-col>
          <v-col cols="12" sm="12" md="4">
            <v-select v-model="form.table" @change="tableFields()" label="Tabla Origen" :items="database.tables" item-text="item" item-value="item"></v-select>
          </v-col>
          <v-col cols="12" sm="12" md="12">
            <label>Tipo de Componente</label>
            <v-radio-group v-model="form.type" row @change="setTemplate(form.template,form.type)">
              <v-radio v-for="(item,i) in type_templates" :label="item.text" :value="item.value" :prepend-icon="item.icon">
                <template v-slot:label>
                  <v-icon color="primary">{{item.icon}}</v-icon> <strong class="primary--text">{{item.text}}</strong>
                </template>
              </v-radio>
            </v-radio-group>
          </v-col>
        </v-row>
        <component is="visual-builder" :fields="form.data" :template="form.template" type="grid" :database="database"></component>
        <v-card-actions>
          <v-btn type="submit" color="success">
            <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
          </v-btn>
        </v-card-actions>
      </v-form>
    </v-card-text>
  </v-card>
  `,
  data:()=>{
    return {
      templates:[
        {value:'create', text:'Guardar Data'},
        {value:'read', text:'Obtener Data'},
        {value:'update', text:'Actualizar Data'},
        {value:'view', text:'Visualizar Data'}
      ],
      type_templates:[
        {
          icon:'bi-file-earmark-text',
          value:'basic',
          text:'Formulario Basico',
        }
      ],
      form:{
        name:'Agregar',
        codename:'',
        table:'',
        data:{},
        template:'create',
        type:'',
        query:{
          rule:[],
          group:[]
        },
        props:{
          after_send:{
            path:null,
            key:null
          },
          success_message:'form.response.success',
          error_message:'form.response.error',
          btn_text:'action.save'
        }
      },
      modules:[],
      database:{
        tables:[],
        options:[],
        fields:[]
      }
    }
  },
  props:['title'],
  methods:{
    /* Saving the data to the database. */
    Save:function() {
      this.form.data = JSON.stringify(this.form.data);
      axios.post(this.$root.p+'/add',{
        data:this.form
      })
      .then((response)=>{
        router.push({query:{p:this.$root.p}})
      })
    },

    
    /* Getting the table fields from the database and putting them in the form.data array. */
    tableFields:function() {
      axios.post(this.$root.p+'/get_tables/'+this.form.table)
      .then((response)=>{
        this.form.name = 'Agregar '+this.form.table
        this.form.data = response.data
      })
    },

    /* Calling the route get_fields and passing the table name and the query. */
    setFieldQuery() {
      axios.post(this.$root.p+'/get_fields/'+this.form.table,{
        data:this.form.query
      })
      .then((response)=>{
        this.database.options = response.data
      })
    },
    /**
     * If the key pressed is a letter, return true, otherwise prevent the default action.
     * @param e - The event object
     * @returns true if the key pressed is a letter, and false if it is not.
     */
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    }
  },
  created:function() {
    this.form.codename = 'C'+this.$root.GenerateID('alpha',8);
    this.form.type = this.type_templates[0].value

    axios.post(this.$root.p+'/get_tables')
    .then((response)=>{
      this.database.tables = response.data
      this.form.table = response.data[0];
      this.form.name += ' '+response.data[0];
      this.tableFields()
    })

    axios.post('Post/get')
    .then((response)=>{
      this.modules = response.data.results
    })
  }
})
Vue.component('module-addRead',{
  template: `
  <v-card>
    <v-card-title>{{title}} "{{form.name}}"</v-card-title>
    <v-divider horizontal></v-divider>
    <v-card-text>
      <v-form v-on:submit.prevent="Save()" class="card">
        <v-window v-model="step">
          <v-window-item :value="1">
            <v-subheader>DATOS DEL COMPONENTE</v-subheader>
            <v-row class="mb-2">
              <v-col cols="12" sm="12" md="3">
                <v-select v-model="form.query.from" @change="tableFields()" label="Tablas de Datos" :items="database.tables" item-text="item" multiple item-value="item"></v-select>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-select v-model="form.table" label="Tabla Principal" :items="form.query.from" item-text="item" item-value="item"></v-select>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-text-field v-model="form.name" label="Nombre del Componente"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-text-field v-model="form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="12">
                <label>Tipo de Componente</label>
                <v-radio-group v-model="form.type" @change="setType()" row >
                  <v-radio v-for="(item,i) in type_templates" :label="item.text" :value="item.value" :prepend-icon="item.icon">
                    <template v-slot:label>
                      <v-icon color="primary">{{item.icon}}</v-icon> <strong class="primary--text ml-1">{{item.text}}</strong>
                    </template>
                  </v-radio>
                </v-radio-group>
              </v-col>
            </v-row>
          </v-window-item>
          <v-window-item :value="2">
            <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
            <component is="query-builder" :query="form.query" :fields="form.data"></component>
          </v-window-item>
          <v-window-item :value="3">
            <v-subheader>CONFIGURACION DE DATOS</v-subheader>
            <component is="visual-builder" :fields="form.data" :template="form.template" :type="type"></component>
            <v-row>
              <v-col cols="12" md="12">
                <v-btn type="submit" color="success">
                  <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
                </v-btn>
              </v-col>
            </v-row>
          </v-window-item>
        </v-window>
        <v-card-actions class="d-flex justify-space-between">
          <v-btn color="info" fab small :disabled="step===1" @click="step--">
            <v-icon>bi bi-arrow-left</v-icon>
          </v-btn>
          <v-btn color="primary" fab small :disabled="step===3" depressed @click="step=step+1">
            <v-icon>bi bi-arrow-right</v-icon>
          </v-btn>
        </v-card-actions>
      </v-form>
    </v-card-text>
  </v-card>
  `,
  data:()=>{
    return {
      step:1,
      type: 'table',
      templates:[
        {value:'create', text:'Guardar Data'},
        {value:'read', text:'Obtener Data'},
        {value:'update', text:'Actualizar Data'},
        {value:'view', text:'Visualizar Data'}
      ],
      type_templates:[
        {
          icon:'bi-table',
          value:'basic',
          text:'Tabla',
        },
        {
          icon:'bi-card-text',
          value:'card',
          text:'Tarjetas',
        },
        {
          icon:'bi-map',
          value:'maps',
          text:'Mapa',
        }
      ],
      form:{
        name:'Listar',
        codename:'',
        data:[],
        table:'',
        template:'read',
        type:'',
        query:{
          from:[],
          rule:[],
          group:[]
        },
        props:{
          view:null,
          update:null,
          remove:true,
          md:4,
          maps:{
            center:{lat:6.795535,lng:-64.379883},
            zoom:5,
            layers:['https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png'],
            geojson:[]
          }
        }
      },
      database:{
        tables:[],
        options:[],
        fields:[]
      }
    }
  },
  props:['title'],
  methods:{
    Save:function() {
      axios.post(this.$root.p+'/add',{
        data:this.form
      })
      .then((response)=>{
        router.push({query:{p:this.$root.p}})
      })
    },
    tableFields:function() {
      axios.post(this.$root.p+'/get_tables?multiple',{
        tables:this.form.query.from
      })
      .then((response)=>{
        this.form.name = 'Listar '+this.form.table
        this.form.data = response.data

      })
    },
    fillOptions:function(table=null) {
      if (table!==null && table!=='') {
        if (this.database.tables.includes(table)) {
          axios.post(this.$root.p+'/get_tables/'+this.form.table+'?field=name')
          .then((response)=>{
            this.database.options = response.data
          })
        } else{
          this.database.options = []
        }
      } else {
        this.database.options = []
      }
    },
    setFieldQuery() {
      axios.post(this.$root.p+'/get_fields/'+this.form.table,{
        data:this.form.query
      })
      .then((response)=>{
        this.database.options = response.data
      })
    },
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    },
    setType() {
      switch(this.form.type){
        case 'basic':
          this.type = 'table';
        break
        case 'card':
          this.type = 'card';
        break
        case 'maps':
          this.type = 'map';
        break
        default:
          this.type = 'grid';
        break
      }
    }
  },
  created:function() {
    this.form.codename = 'C'+this.$root.GenerateID('alpha',8);
    this.form.type = this.type_templates[0].value

    axios.post(this.$root.p+'/get_tables')
    .then((response)=>{
      this.database.tables = response.data
      this.form.query.from = [response.data[0]];
      this.form.table = response.data[0];
      this.form.name += ' '+response.data[0];
      this.tableFields()
    })

    axios.post('Post/get')
    .then((response)=>{
      this.modules = response.data.results
    })
  }
})
Vue.component('module-addUpdate',{
  template: `
  <v-card>
    <v-card-title>{{title}} "{{form.name}}"</v-card-title>
    <v-card-text>
      <v-form v-on:submit.prevent="Save()" class="card">
        <v-row class="mb-2">
          <v-col cols="12" sm="12" md="4">
            <v-text-field v-model="form.name" label="Nombre del Componente"></v-text-field>
          </v-col>
          <v-col cols="12" sm="12" md="4">
            <v-text-field v-model="form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
          </v-col>
          <v-col cols="12" sm="12" md="4">
            <v-select v-model="form.table" @change="tableFields()" label="Tabla Origen" :items="database.tables" item-text="item" item-value="item"></v-select>
          </v-col>
          <v-col cols="12" sm="12" md="12">
            <label>Tipo de Componente</label>
            <v-radio-group v-model="form.type" row @change="setTemplate(form.template,form.type)">
              <v-radio v-for="(item,i) in type_templates" :label="item.text" :value="item.value" :prepend-icon="item.icon">
                <template v-slot:label>
                  <v-icon color="primary">{{item.icon}}</v-icon> <strong class="primary--text">{{item.text}}</strong>
                </template>
              </v-radio>
            </v-radio-group>
          </v-col>
        </v-row>
        <component is="visual-builder" :fields="form.data" :template="form.template" type="grid" :database="database"></component>
        <v-card-actions>
          <v-btn type="submit" color="success">
            <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
          </v-btn>
        </v-card-actions>
      </v-form>
    </v-card-text>
  </v-card>
  `,
  data:()=>{
    return {
      templates:[
        {value:'create', text:'Guardar Data'},
        {value:'read', text:'Obtener Data'},
        {value:'update', text:'Actualizar Data'},
        {value:'view', text:'Visualizar Data'}
      ],
      type_templates:[
        {
          icon:'bi-file-earmark-text',
          value:'basic',
          text:'Formulario Basico',
        }
      ],
      form:{
        name:'Actualizar',
        codename:'',
        table:'',
        data:[],
        template:'update',
        type:'',
        query:{
          rule:[],
          group:[]
        },
        props:{
          after_send:{
            path:null,
            key:null
          },
          success_message:'form.response.success',
          error_message:'form.response.error',
          btn_text:'action.update'
        }
      },
      modules:[],
      database:{
        tables:[],
        options:[],
        fields:[]
      }
    }
  },
  props:['title'],
  methods:{
    Save:function() {
      this.form.data = JSON.stringify(this.form.data);
      axios.post(this.$root.p+'/add',{
        data:this.form
      })
      .then((response)=>{
        router.push({query:{p:this.$root.p}})
      })
    },
    tableFields:function() {
      axios.post(this.$root.p+'/get_tables/'+this.form.table)
      .then((response)=>{
        this.form.name = 'Actualizar '+this.form.table
        this.form.data = response.data

      })
    },
    fillOptions:function(table=null) {
      if (table!==null && table!=='') {
        if (this.database.tables.includes(table)) {
          axios.post(this.$root.p+'/get_tables/'+this.form.table+'?field=name')
          .then((response)=>{
            this.database.options = response.data
          })
        } else{
          this.database.options = []
        }
      } else {
        this.database.options = []
      }
    },
    setFieldQuery() {
      axios.post(this.$root.p+'/get_fields/'+this.form.table,{
        data:this.form.query
      })
      .then((response)=>{
        this.database.options = response.data
      })
    },
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    }
  },
  created:function() {
    this.form.codename = 'C'+this.$root.GenerateID('alpha',8);
    this.form.type = this.type_templates[0].value

    axios.post(this.$root.p+'/get_tables')
    .then((response)=>{
      this.database.tables = response.data
      this.form.table = response.data[0];
      this.form.name += ' '+response.data[0];
      this.tableFields()
    })

    axios.post('Post/get')
    .then((response)=>{
      this.modules = response.data.results
    })
  }
})
Vue.component('module-addView',{
  template: `
  <v-card>
    <v-card-title>{{form.name}}</v-card-title>
    <v-card-subtitle>{{$t('section.component')}}: {{$t('action.view')}}</v-card-subtitle>
    <v-divider horizontal></v-divider>
    <v-card-text>
      <v-form v-on:submit.prevent="Save()" class="card">
        <v-window v-model="step">
          <v-window-item :value="1">
            <v-subheader>DATOS DEL COMPONENTE</v-subheader>
            <v-row class="mb-2">
              <v-col cols="12" sm="12" md="3">
                <v-select v-model="form.query.from" @change="tableFields()" label="Tablas de Datos" :items="database.tables" item-text="item" multiple item-value="item"></v-select>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-select v-model="form.table" label="Tabla Principal" :items="form.query.from" item-text="item" item-value="item"></v-select>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-text-field v-model="form.name" label="Nombre del Componente"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="3">
                <v-text-field v-model="form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="12">
                <label>Tipo de Componente</label>
                <v-radio-group v-model="form.type" row >
                  <v-radio v-for="(item,i) in type_templates" :label="item.text" :value="item.value" :prepend-icon="item.icon">
                    <template v-slot:label>
                      <v-icon color="primary">{{item.icon}}</v-icon> <strong class="primary--text ml-1">{{item.text}}</strong>
                    </template>
                  </v-radio>
                </v-radio-group>
              </v-col>
            </v-row>
          </v-window-item>
          <v-window-item :value="2">
            <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
            <component is="query-builder" :query="form.query" :fields="form.data"></component>
          </v-window-item>
          <v-window-item :value="3">
            <v-subheader>CONFIGURACION DE DATOS</v-subheader>
            <component is="visual-builder" :fields="form.data" :template="form.template" type="grid"></component>
            <v-row>
              <v-col cols="12" md="12">
                <v-btn type="submit" color="success">
                  <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
                </v-btn>
              </v-col>
            </v-row>
          </v-window-item>
        </v-window>
        <v-card-actions class="d-flex justify-space-between">
          <v-btn color="info" fab small :disabled="step===1" @click="step--">
            <v-icon>bi bi-arrow-left</v-icon>
          </v-btn>
          <v-btn color="primary" fab small :disabled="step===3" depressed @click="step=step+1">
            <v-icon>bi bi-arrow-right</v-icon>
          </v-btn>
        </v-card-actions>
      </v-form>
    </v-card-text>
  </v-card>
  `,
  data:()=>{
    return {
      dragging:false,
      step:3,
      search:null,
      type_templates:[
        {
          icon:'bi-layout-sidebar',
          value:'basic',
          text:'Vista basica',
        }
      ],
      form:{
        name:'',
        codename:'',
        data:[],
        table:'',
        template:'view',
        type:'',
        query:{
          from:[],
          rule:[],
          group:[]
        },
        props:{
          update:null,
          remove:true
        }
      },
      modules:[],
      database:{
        tables:[],
        options:[],
        fields:[]
      }
    }
  },
  props:['title'],
  methods:{
    Save:function() {
      this.form.data = JSON.stringify(this.form.data);
      axios.post(this.$root.p+'/add',{
        data:this.form,
        props:router.history.current.query
      })
      .then((response)=>{
        router.push({query:{p:this.$root.p}})
      })
    },
    tableFields:function() {
      axios.post(this.$root.p+'/get_tables?multiple',{
        tables:this.form.query.from
      })
      .then((response)=>{
        this.form.name = this.form.table
        this.form.data = response.data

      })
    },
    fillOptions:function(table=null) {
      if (table!==null && table!=='') {
        if (this.database.tables.includes(table)) {
          axios.post(this.$root.p+'/get_tables/'+this.form.table+'?field=name')
          .then((response)=>{
            this.database.options = response.data
          })
        } else{
          this.database.options = []
        }
      } else {
        this.database.options = []
      }
    },
    setFieldQuery() {
      axios.post(this.$root.p+'/get_fields/'+this.form.table,{
        data:this.form.query
      })
      .then((response)=>{
        this.database.options = response.data
      })
    },
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    },
    toWidth(f) {
      var pre_width = (f/12)*100;
      return (pre_width*90)/100;
    }
  },
  created:function() {
    this.form.codename = 'C'+this.$root.GenerateID('alpha',8);
    this.form.type = this.type_templates[0].value

    axios.post(this.$root.p+'/get_tables')
    .then((response)=>{
      this.database.tables = response.data
      this.form.query.from = [response.data[0]];
      this.form.table = response.data[0];
      this.form.name += ' '+response.data[0];
      this.tableFields()
    })

    axios.post('Post/get')
    .then((response)=>{
      this.modules = response.data.results
    })
  }
})
Vue.component('module-addChart',{
  template: `
  <v-card>
    <v-card-title>{{title}} "{{form.name}}"</v-card-title>
    <v-divider horizontal></v-divider>
    <v-card-text>
      <v-form v-on:submit.prevent="Save()" class="card">
        <v-window v-model="step">
          <v-window-item :value="1">
            <v-subheader>DATOS DEL COMPONENTE</v-subheader>
            <v-row class="mb-2">
              <v-col cols="12" sm="12" md="4">
                <v-text-field v-model="form.name" label="Nombre del Componente"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="4">
                <v-text-field v-model="form.codename" @keypress="isLetter($event)" label="Tag"></v-text-field>
              </v-col>
              <v-col cols="12" sm="12" md="4">
                <v-select v-model="form.type" label="Tipo de Grafico" :items="type_templates" item-text="text" item-value="value"></v-select>
              </v-col>
            </v-row>
          </v-window-item>
          <v-window-item :value="2">
            <v-subheader>CONSTRUCTOR DE CONSULTA</v-subheader>
            <v-row class="mb-2 mt-2">
              <v-col cols="12" md="12">
                <v-btn left color="primary" @click="form.data.push({... dataset})">
                  <v-icon>bi bi-plus</v-icon>Agregar Dataset
                </v-btn>
              </v-col>
            </v-row>
            <v-row class="mb-2 mt-2">
              <v-col cols="12" md="4" v-for="(dataset,d) in form.data">
                <v-row>
                  <v-col cols="12" md="12">
                    <v-text-field dense solo outlined v-model="form.data[d].title" label="Titulo"></v-text-field>
                    <v-textarea dense solo v-model="form.data[d].source" label="Consulta" filled rows="2" outlined></v-textarea>
                  </v-col>
                </v-row>
              </v-col>
            </v-row>
          </v-window-item>
          <v-window-item :value="3">
            <v-subheader>CONFIGURACION DE DATOS</v-subheader>
            <v-row>
              <v-col cols="12" md="6">
                <v-textarea rows="2" label="Formato de Tooltip" v-model="form.attr.tooltip.formatter"></v-textarea>
              </v-col>
              <v-col cols="12" md="6">
                <v-textarea rows="2" label="Formato de Etiqueta" v-model="form.attr.label.formatter"></v-textarea>
              </v-col>
            </v-row>
            <v-row>
              <v-col cols="12" md="4">
                <v-list dense>
                  <v-subheader>CAMPOS <v-icon v-if="dragging">bi-chevron-expand</v-icon></v-subheader>
                  <v-list-item-group color="primary">
                    <draggable :list=form.data @start="dragging=true" @end="dragging=false">
                      <v-list-item v-for="(field,f) in form.data" :key="f">
                        <v-list-item-content @click="getFieldQuery(field.source,f),field_active = f">
                          <v-list-item-title v-text="field.title"></v-list-item-title>
                        </v-list-item-content>
                        <v-list-item-icon>
                          <v-icon :color="field.color">bi-stop-fill</v-icon>
                        </v-list-item-icon>
                      </v-list-item>
                    </draggable>
                  </v-list-item-group>
                </v-list>
              </v-col>
              <v-col cols="12" md="8">
                <v-row v-if="field_active!==null">
                  <v-col cols="12" md="12">
                    <v-color-picker dense hide-canvas hide-mode-switch v-model="form.data[field_active].color" mode="hexa" :swatches="swatches" show-swatches></v-color-picker>
                  </v-col>
                </v-row>
              </v-col>
            </v-row>
          </v-window-item>
        </v-window>
        <v-card-actions class="justify-space-between">
          <v-btn type="submit" color="success">
            <v-icon>bi bi-cloud-arrow-up</v-icon> Guardar
          </v-btn>
          <div class="justify-space-between">
            <v-btn color="info" fab small :disabled="step===1" @click="step--">
              <v-icon>bi bi-arrow-left</v-icon>
            </v-btn>
            <v-btn color="primary" fab small :disabled="step===3" depressed @click="step=step+1">
              <v-icon>bi bi-arrow-right</v-icon>
            </v-btn>
          </div>
        </v-card-actions>
      </v-form>
    </v-card-text>
  </v-card>
  `,
  data:()=>{
    return {
      dragging:false,
      field_active:null,
      num_dataset:1,
      step:1,
      search:null,
      type_templates:[
        {
          value:'pie',
          text:'Pie',
        },
        {
          value:'bar',
          text:'Barras',
        },
        {
          value:'line',
          text:'Linea',
        },
        {
          value:'area',
          text:'Area',
        }
      ],
      swatches: [
        ['#FF0000', '#AA0000', '#550000'],
        ['#FFFF00', '#AAAA00', '#555500'],
        ['#00FF00', '#00AA00', '#005500'],
        ['#00FFFF', '#00AAAA', '#005555'],
        ['#0000FF', '#0000AA', '#000055'],
      ],
      form:{
        name:'Grafico',
        codename:'',
        data:[],
        table:'',
        template:'chart',
        type:'pie',
        query:{
          from:[],
          rule:[],
          group:[],
          sql:""
        },
        attr:{
          tooltip:{
            formatter:'{a} <br/>{b} : {c} ({d}%)'
          },
          label:{
            formatter:'{a} <br/>{b} : {c} ({d}%)'
          }
        }
      },
      modules:[],
      dataset:{
        title: "Dataset ",
        source: "SELECT COUNT(*) AS value, type AS label FROM component GROUP BY label",
        label: "",
        value: "",
        color: "#FF0000FF"
      },
      options:{
        label:[],
        value:[]
      }
    }
  },
  props:['title'],
  methods:{
    Save:function() {
      this.$emit('loading-screen')
      axios.post('Component/add',{
        data:this.form
      })
      .then((response)=>{
        this.$emit('loading-screen',false)
      })
    },
    tableFields:function() {
      axios.post(this.$root.p+'/get_tables?multiple',{
        tables:this.form.query.from
      })
      .then((response)=>{
        this.form.name = 'Listar '+this.form.table
        this.form.data = response.data

      })
    },
    getFieldQuery(query,index) {
      axios.post(this.$root.p+'/get_fields',{
        query:query
      })
      .then((response)=>{
        if (response.status && response.status == 200) {
          this.options.label = response.data
          this.options.value = response.data
        }
      })
    },
    isLetter(e) {
      let char = String.fromCharCode(e.keyCode);
      if (/^[A-Za-z]+$/.test(char)) return true;
      else e.preventDefault();
    },
    toWidth(f) {
      var pre_width = (f/12)*100;
      return (pre_width*90)/100;
    },
    editQuery(r=null,g=null) {
      this.rule_edit = r
      this.group_edit = g
    }
  },
  created:function() {
    this.form.codename = 'C'+this.$root.GenerateID('alpha',8);
    this.$emit('loading-screen',false)
  }
})