/* Creating a Vue component called v-toast. */
Vue.component('v-toast',{
  template: `
  <div>
    <v-snackbar v-if="system" :color="color+' lighten-2'" shaped elevation="24" :timeout="timer" v-model="showSnack" bottom center>
      <v-icon v-if="icon" left>{{icon}}</v-icon> {{message}}
      <template v-slot:action="{ attrs }">
        <v-btn
          :color="color+' darken-2'"
          fab small
          v-bind="attrs"
          @click="showSnack = false"
        >
          <v-icon>ri-close-circle-line</v-icon>
        </v-btn>
      </template>
    </v-snackbar>
    <v-snackbar v-else :color="color+' lighten-2'" :timeout="timer" v-model="showSnack" bottom right>
      <v-icon v-if="icon" left>{{icon}}</v-icon> {{message}}
      <template v-slot:action="{ attrs }">
        <v-btn
          :color="color+' darken-2'"
          fab small
          v-bind="attrs"
          @click="showSnack = false"
        >
          <v-icon>ri-close-circle-line</v-icon>
        </v-btn>
      </template>
    </v-snackbar>
  </div>
  `,
  data: function() {
    return {
      showSnack: false,
      message: 'missing "Message".',
      color: 'success',
      icon: 'mdi-check',
      system: false,
      timer: 3000
    }
  },
  props:['actions'],
  methods:{
    show(data){
      if(data){
        this.message = data.message ? data.message : 'missing "Message".'
        this.color = data.color ? data.color : 'success'
        this.timer = data.timer ? data.timer : 3000
        this.icon = data.icon ? data.icon : 'mdi-check'
        this.system = data.system ? data.system : false
        this.showSnack = true
      } else{
        this.message = 'missing "Message".'
        this.color = 'success'
        this.timer = 3000
        this.icon = 'mdi-check'
        this.system = false
        this.showSnack = true
      }
    }
  }
})

/* A Vue component that is used to create a query. */
Vue.component('rule-block',{
  template: `
  <div>
    <v-row class="mb-2">
      <v-col cols="12" md="4" v-for="(rule,r) in rules" :key="'R'+r">
        <v-card :color="rule.conector?undefined:'blue lighten-5'" :shaped="rule.conector?true:false" outlined>
          <v-card-subtitle>
            <span class="lime--text text--darken-2 mr-1">{{rule.key}}</span>
            <span class="blue--text text--darken-4 mr-1">{{query_exp[rule.comparator]}}</span>
            <span :class="rule.escape?'green--text text--darken-2':'lime--text text--darken-2'">
              {{rule.escape?"'":''}}{{rule.type=='prop'?"{":''}}{{rule.value}}{{rule.type=='prop'?"}":''}}{{rule.escape?"'":''}}
            </span>
            <span class="blue--text text--darken-4 mr-1" v-if="(r+1)!==rules.length">{{rule.conector?'OR':'AND'}}</span>
          </v-card-subtitle>
          <v-card-text class="pa-2" v-if="group_edit==group && rule_edit==r">
            <v-row>
              <v-col cols="12" sm="7">
                <v-select dense solo v-model="rule.key" label="Campo" :items="fields" item-text="name" item-value="name" ></v-select>
              </v-col>
              <v-col cols="12" sm="5">
                <v-select dense solo v-model="rule.comparator" label="Operador" :items="['Igual','No Igual','Menor','Mayor','Menor o Igual','Mayor o Igual','Contiene']" item-text="item" item-value="item" ></v-select>
              </v-col>
              <v-col cols="12" sm="12" class="d-flex justify-space-between align-center">
                <v-btn color="primary" @click="rule.type='field';rule.escape=false" :outlined="rule.type=='field'?false:true" small>
                  DDBB
                </v-btn>
                <v-btn color="success" @click="rule.type='value';rule.escape=true" :outlined="rule.type=='value'?false:true" small>
                  VALOR
                </v-btn>
                <v-btn color="info" @click="rule.type='prop';rule.escape=true" :outlined="rule.type=='prop'?false:true" small>
                  PROP
                </v-btn>
              </v-col>
              <v-col cols="12" sm="12">
                <v-select dense solo v-if="rule.type=='field'" v-model="rule.value" label="Campo" :items="fields" item-text="name" item-value="name" :append-icon="!rule.escape?'bi-exclamation-diamond':'bi-diamond'"></v-select>
                <v-select dense solo v-if="rule.type=='prop'" v-model="rule.value" label="Propiedad" :items="props" item-text="item" item-value="value"  :append-icon="!rule.escape?'bi-exclamation-diamond':'bi-diamond'" @click:append="rule.escape=!rule.escape"></v-select>
                <v-text-field dense solo v-if="rule.type=='value'" v-else v-model="rule.value" label="Valor" :append-icon="!rule.escape?'bi-exclamation-diamond':'bi-diamond'" @click:append="rule.escape=!rule.escape"></v-text-field>                          
              </v-col>
            </v-row>

          </v-card-text>
          <v-card-actions class="justify-space-between">
            <v-btn fab color="info" x-small @click="group_edit==group && rule_edit==r?editQuery():editQuery(r,group)">
              <v-icon>bi-pencil-square</v-icon>
            </v-btn>
            <v-btn fab color="error" x-small @click="DeleteRule(r)">
              <v-icon>bi-trash</v-icon>
            </v-btn>
            <v-btn-toggle v-model="rule.conector" shaped v-if="(r+1)!==rules.length">
              <v-btn color="info" value="OR" small>
                OR
              </v-btn>
            </v-btn-toggle>
          </v-card-actions>
        </v-card>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
      rule_edit:null,
      group_edit:null,
      query_exp:{
        "Igual":"=",
        "No Igual":"!=",
        "Menor":"<",
        "Mayor":">",
        "Menor o Igual":"<=",
        "Mayor o Igual":">=",
        "Contiene":"LIKE",
      },
      props:[
        {item:'Record ID',value:'pk'},
        {item:'Session ID',value:'id'},
        {item:'Session ROLE',value:'role'},
        {item:'Session NAME',value:'name'},
        {item:'Session USER',value:'user'},
        {item:'Session EMAIL',value:'email'}
      ]
    }
  },
  props:['rules','fields','group'],
  methods: {
    DeleteRule(r) {
      this.$delete(this.rules,r)
      this.$root.toast.show({
        message: 'Rule deleted successfully.',
        color:'success',
        icon: 'bi-trash'
      })
    },
    editQuery(r=null,g=null) {
      this.rule_edit = r
      this.group_edit = g
    }
  },
})

/* Creating a component called group-block */
Vue.component('group-block',{
  template: `
  <div>
    <v-row>
      <v-col cols="12" md="12" v-for="(group,g) in groups" :key="'G'+g">
        <v-card :color="group.conector?undefined:'blue lighten-4'" :shaped="group.conector?true:false" outlined>
          <v-card-subtitle>
            <span class="blue--text text--darken-4 mr-1">WHERE (</span>
            <span class="lime--text text--darken-2 mr-1">{{group.rule.length}} Regla{{group.rule.length>1?'s':''}}</span>
            <span class="blue--text text--darken-4 mr-1">)</span>
            <span class="blue--text text--darken-4 mr-1" v-if="(g+1)!==groups.length">{{group.conector?'OR':'AND'}}</span>
          </v-card-subtitle> 
          <v-card-text>
            <v-row>
              <v-col cols="12" md="4">
                <v-btn color="primary" @click="group.rule.push({... {key:fields[0].name,comparator:'Igual',value:'value',conector:null,escape:true,type:'value'}})"> Agregar Regla</v-btn>
                <v-btn fab x-small color="error" @click="$delete(groups,g)"><v-icon>bi bi-trash</v-icon></v-btn>
                <v-btn-toggle v-model="group.conector" shaped v-if="(g+1)!==groups.length">
                  <v-btn color="info" value="OR" small>
                    OR
                  </v-btn>
                </v-btn-toggle>
              </v-col>
            </v-row>
            <component is="rule-block" :fields="fields" :group="g" :rules="group.rule">
          </v-card-text>
        </v-card>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
    }
  },
  props:['fields','groups']
})

/* Creating a component called query-builder. */
Vue.component('query-builder',{
  template: `
  <div>
    <v-row class="mb-2 mt-2">
      <v-col cols="12" md="12" sm="12">
        <v-row>
          <v-col>
            <v-btn color="primary" @click="AddRule()"> Agregar Regla</v-btn>
            <v-btn color="info" @click="AddGroup()"> Agregar Grupo</v-btn>
          </v-col>
        </v-row>
        <component is="rule-block" :rules="query.rule" :fields="fields" :group="null"></component>
        <component is="group-block" :groups="query.group" :fields="fields"></component>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
    }
  },
  props:['query','fields'],
  methods:{
    AddRule(){
      var add = {key:this.fields[0].name,comparator:'Igual',value:'value',conector:null,escape:true,type:'value'}
      this.query.rule.push({... add})
      this.$root.toast.show({
        message:"Rule added successfully",
        color:'cyan'
      })
    },
    AddGroup(){
      var add = {rule:[],conector:null}
      this.query.group.push({... add})
      this.$root.toast.show({
        message:"Group added successfully",
        color:'blue'
      })
    }
  }
})

/* Creating a component called query-builder. */
Vue.component('component-setting',{
  template: `
  <div>
    <div v-if="content.template=='create'">
      <div v-if="content.props.after_send.path==null">
        <v-row>
          <v-col cols="12" md="12" v-if="content.active!==null">
            <v-select v-model="content.props.after_send.key" :items="pages.content" item-text="name" item-value="id" label="Activar Pantalla"></v-select>
          </v-col>
        </v-row>
      </div>
    </div>
    <div v-if="content.template=='read'">
      <div v-if="content.active!==null">
        <v-select v-model="content.props.view" clearable clear-icon="ri-close-circle-line" :items="pages.content" label="Ver" item-text="name" item-value="id"></v-select>
        <v-select v-model="content.props.update" clearable clear-icon="ri-close-circle-line" :items="pages.content" label="Editar" item-text="name" item-value="id"></v-select>
      </div>
      <div v-else>
        <v-select v-model="content.props.view" clearable clear-icon="ri-close-circle-line" :items="modules" label="Ver" item-text="title" item-value="slug"></v-select>
        <v-select v-model="content.props.update" clearable clear-icon="ri-close-circle-line" :items="modules" label="Editar" item-text="title" item-value="slug"></v-select>
      </div>
      <v-btn :color="content.props.remove?'error':'primary'" :outlined="content.props.remove" @click="content.props.remove=!content.props.remove">
        <v-icon>{{content.props.remove?'ri-delete-bin-7-line':'ri-delete-bin-2-line'}}</v-icon>
        {{content.props.remove?'Eliminar Activado':'Eliminar Desactivado'}}
      </v-btn>
      <div v-if="content.type == 'map'">
        <v-row class="mt-2">
          <v-col cols="12" md="4">
            <v-text-field v-model="content.props.maps.center.lat" number label="Centro Lat"></v-text-field>
          </v-col>
          <v-col cols="12" md="4">
            <v-text-field v-model="content.props.maps.center.lng" number label="Centro Lng"></v-text-field>
          </v-col>
          <v-col cols="12" md="4">
            <v-text-field v-model="content.props.maps.zoom" number label="Zoom" min="1"></v-text-field>
          </v-col>
        </v-row>
        <v-row class="mt-2">
          <v-col cols="12" md="12">
            <v-combobox v-model="content.props.maps.layers" :items="content.props.maps.layers" :search-input.sync="add.layers.search" hide-selected label="Add some layers" multiple persistent-hint small-chips>
              <template v-slot:no-data>
                <v-list-item>
                  <v-list-item-content>
                    <v-list-item-title>
                      Press <kbd>enter</kbd> to add "<strong>{{ add.layers.search }}</strong>".
                    </v-list-item-title>
                  </v-list-item-content>
                </v-list-item>
              </template>
              <template v-slot:selection="{ attrs, item, parent, selected }">
                <v-chip v-bind="attrs" color="primary" :input-value="selected" label small >
                  <span class="pr-2">
                    {{ item }}
                  </span>
                  <v-icon small @click="parent.selectItem(item)" >
                    $delete
                  </v-icon>
                </v-chip>
              </template>
            </v-combobox>
          </v-container>
            <v-text-field v-model="content.props.maps.center.lat" number label="Centro Lat"></v-text-field>
          </v-col>
        </v-row>
        <v-row>
          <v-col cols="12" md="6" v-if="content.props.maps.geojson.length>0" v-for="(geo,z) in content.props.maps.geojson">
            <v-card>
              <v-card-title>
                {{geo.path}}
                <v-spacer></v-spacer>
                <v-btn icon @click="$delete(content.props.maps.geojson,z)">
                  <v-icon>ri-delete-bin-7-line</v-icon>
                </v-btn>
              </v-card-title>
              <v-card-subtitle>ID Pantalla: {{geo.id}}</v-card-subtitle>
              <v-card-text>
                <span>Tooltip: {{(geo.tooltip?'Si':'No')}}</span>
                <span>Campo ID: {{(geo.id?geo.id:'No Definido')}}</span>
                <span>Color: {{(geo.color?geo.color:'No Definido')}}</span>
              </v-card-text>
            </v-card>
          </v-col>
        </v-row>
        <v-row>
          <v-col cols="12" md="4">
            <v-text-field v-model="add.geojson.path" name="path" label="Link"></v-text-field>
          </v-col>
          <v-col cols="12" md="4">
            <v-text-field v-model="add.geojson.id" name="id" label="ID"></v-text-field>
          </v-col>
          <v-col cols="12" md="4">
            <v-checkbox v-model="add.geojson.tooltip" name="tooltip" :true-value="true" :false-value="false" label="Tooltip"></v-checkbox>
          </v-col>
          <v-col cols="12" md="4">
            <v-text-field v-model="add.geojson.color" name="color" label="Color"></v-text-field>
          </v-col>
          <v-col cols="12" md="4">
            <v-select v-model="add.geojson.screen" name="screen" :items="pages.content" item-value="id" item-text="name" label="Activar Pantalla"></v-select>
          </v-col>
          <v-col cols="12" md="4">
            <v-btn @click="addGeoJSON(add.geojson)">
              <v-icon>ri-add-fill</v-icon> GeoJSON
            </v-btn>
          </v-col>
        </v-row>
      </div>
    </div>
    <div v-if="content.template=='update'">
      <div v-if="content.props.after_send.path==null">
        <v-row>
          <v-col cols="12" md="12" v-if="content.active!==null">
            <v-select v-model="content.props.after_send.key" :items="pages.content" item-text="name" item-value="id" label="Activar Pantalla"></v-select>
          </v-col>
        </v-row>
      </div>
    </div>
  </div>
  `,
  data: function() {
    return {
      add:{
        layers:{
          search:null
        },
        geojson:{
          path:null,
          id:null,
          tooltip:null,
          color:null,
          screen:null,
        }
      }
    }
  },
  props:['content','template','pages'],
  methods:{
    addGeoJSON(geo){
      this.geo_data = {}
      console.log(geo)
      /*geo.forEach((value,index) => {
        this.$set(this.geo_data,value.$attrs.name,value.lazyValue)
      });*/
      this.content.props.maps.geojson.push(geo)
    },
  }
})

/* Creating a component called query-builder. */
Vue.component('element-setting',{
  template: `
  <div>
    <div v-if="content.template=='carousel'">
      <v-row>
        <v-col cols="12" md="6" v-for="(slider,s) in content.content">
          <v-card>
            <v-img :src="slider.img"></v-img>
            <v-card-text>
              <v-text-field v-model="slider.text" label="Text" outlined dense></v-text-field>
              <v-btn block color="red" @click="$delete(content.content,s)">{{$t('action.delete')}}</v-btn>
            </v-card-text>
          </v-card>
        </v-col>
      </v-row>
      <v-row>
        <v-col cols="12" md="12">
          <v-file-input @change="RenderFile('ref_file_logo')" ref="ref_file_logo" label="Image" accept="image/*"></v-file-input>
        </v-col>
      </v-row>
    </div>
    <div v-if="content.template=='card'">
      <v-row>
        <v-col cols="12" md="12">
          <v-text-field v-model="content.content.title"></v-text-field>
        </v-col>
        <v-col cols="12" md="12">
          <ckeditor v-model="content.content.body" counter rows='2' auto-grow :value="content.content.body"></ckeditor>
        </v-col>
      </v-row>
      <v-row >
        <v-col cols="12" md="6">
          <v-file-input @change="CardFile('ref_file_card')" ref="ref_file_card" label="Image" accept="image/*"></v-file-input>
        </v-col>
        <v-col cols="12" md="3">
          <v-btn fab color="primary" @click="content.attr.inner==true || content.attr.inner=='true'?content.attr.inner=false:content.attr.inner=true">
            <v-icon>{{content.attr.inner==true || content.attr.inner=='true'?'mdi-import':'mdi-export'}}</v-icon>
          </v-btn>
        </v-col>
        <v-col cols="12" md="3">
          <v-img v-if="content.content.image" :src="content.content.image" @click="content.content.image=''"></v-img>
        </v-col>
      </v-row>
      <v-row >
        <v-col cols="12" md="8">
          <v-row no-gutters v-if="content.attr.card">
            <v-col cols="12" md="4" v-for="(item,i) in Object.keys(content.attr.card)">
              <v-text-field v-model="content.attr.card[item]" :label="item" outlined append-icon="mdi-delete-outline" @click:append="Vue.delete(content.attr.card, item);"></v-text-field>
            </v-col>
          </v-row>
        </v-col>
        <v-col cols="12" md="4">
          <v-text-field append-icon="mdi-plus" v-model="helper.card.param.key" @click:append="AddParam()"></v-text-field>
        </v-col>
      </v-row>
    </div>
    <div v-if="content.template=='divider'">
      <v-row>
        <v-col cols="12" md="12">
          <v-text-field v-model="content.content.title" label="Title"></v-text-field>
        </v-col>
        <v-col cols="12" md="12">
          <v-text-field v-model="content.content.color" label="Color"></v-text-field>
        </v-col>
      </v-row>
    </div>
  </div>
  `,
  data: function() {
    return {
      helper:{
        card:{
          param:{
            key:'',
            value:''
          },
        }
      }
    }
  },
  props:['content','template','pages'],
  methods:{
    RenderFile(r){
      if (this.$refs[r].lazyValue!==null || typeof this.$refs[r].lazyValue!=='undefined') {
        const file = this.$refs[r].lazyValue
        const reader = new FileReader()
        reader.onload = (e)=>{
          this.content.content.push({... {img:e.target.result,text:""}})
        }
        reader.readAsDataURL(file)
        this.$refs[r].lazyValue = null
      }
    },
    CardFile(r){
      if (this.$refs[r].lazyValue!==null || typeof this.$refs[r].lazyValue!=='undefined') {
        const file = this.$refs[r].lazyValue
        const reader = new FileReader()
        reader.onload = (e)=>{
          this.content.content.image = e.target.result
        }
        reader.readAsDataURL(file)
        this.$refs[r].lazyValue = null
      }
    },
    AddParam(){
      if (this.content.attr.card == null) {
        this.content.attr.card = {}
      }
      console.log(this.content.attr.card)
      this.$set(this.content.attr.card,this.helper.card.param.key,this.helper.card.param.value)
      this.$root.toast.show({
        message:"Rule added successfully",
        color:'cyan'
      })
      this.helper.card.param.key = ''
      this.helper.card.param.value = ''
    },
    AddGroup(){
      var add = {rule:[],conector:null}
      this.query.group.push({... add})
      this.$root.toast.show({
        message:"Group added successfully",
        color:'blue'
      })
    }
  }
})

/* A Vue component that is used to render a list of fields. */
Vue.component('render-field',{
  template: `
  <div>
    <v-tabs v-model="tab">
      <v-tabs-slider></v-tabs-slider>
      <v-tab v-for="(item,i) in tabs" :href="'#tab-'+(i+1)">{{$t(item)}}</v-tab>
    </v-tabs>
    <v-tabs-items v-model="tab">
      <v-tab-item value="tab-1">
        <v-list dense>
          <v-list-item-group color="success" >
            <v-list-item v-for="(field,f) in fields" v-if="field.visible==true" @click="SelectField(field.name)">
              <v-list-item-icon @click="field.visible = !field.visible">
                <v-icon>bi bi-eye-slash</v-icon>
              </v-list-item-icon>
              <v-list-item-content>
                <v-list-item-title>{{field.label}}</v-list-item-title>
                <v-list-item-subtitle>{{field.name}}</v-list-item-subtitle>
              </v-list-item-content>
            </v-list-item>
          </v-list-item-group>
        </v-list>
      </v-tab-item>
      <v-tab-item value="tab-2">
        <v-list dense>
          <v-list-item-group color="error" >
            <v-list-item v-for="(field,f) in fields" v-if="field.visible==false" @click="SelectField(field.name)">
              <v-list-item-icon @click="field.visible = !field.visible">
                <v-icon>bi bi-eye</v-icon>
              </v-list-item-icon>
              <v-list-item-content>
                <v-list-item-title>{{field.label}}</v-list-item-title>
                <v-list-item-subtitle>{{field.name}}</v-list-item-subtitle>
              </v-list-item-content>
            </v-list-item>
          </v-list-item-group>
        </v-list>
      </v-tab-item>
    </v-tab-items>
  </div>
  `,
  data: function() {
    return {
      tab:null,
      tabs:['status.active','status.inactive']
    }
  },
  props:['fields'],
  methods:{
    SelectField(id){
      this.$emit('select',id)
    }
  }
})

/* A Vue component that is used to create a form. */
Vue.component('render-option-create',{
  template: `
  <div>
    <v-row v-if="selected">
      <v-col cols="12" md="12">
        <v-row v-for="(field,f) in fields" :key="field.name" v-if="field.name==selected">
          <v-col cols="12" md="12">
            <v-slider  v-model="field.width" :label="'Tamaño: '+field.width" min="3" max="12"></v-slider>
          </v-col>
          <v-col cols="12" md="6">
            <v-text-field  v-model="field.label" label="Etiqueta"></v-text-field>
          </v-col>
          <v-col cols="12" md="6">
            <v-select  v-model="field.type" :items="fields_type" item-text="text" item-value="value" label="Tipo de Campo"></v-select>
          </v-col>
          <v-col cols="12" md="6">
            <v-text-field  v-model="field.helper" label="Texto Ayuda"></v-text-field>
          </v-col>
          <v-col cols="12" md="6">
            <v-combobox  v-model="field.default" :items="default_value" label="Valor por defecto"></v-combobox>
          </v-col>
          <v-col cols="12" md="6">
            <v-checkbox  v-model="field.hidden" label="Ocultar" :true-value='true' :false-value='false'></v-checkbox>
          </v-col>
          <v-col cols="12" md="6">
            <v-checkbox  v-model="field.disabled" label="Desactivar" :true-value='true' :false-value='false'></v-checkbox>
          </v-col>
          <v-col cols="12" md="6">
            <v-checkbox  v-model="field.required" label="Obligatorio" :disabled="!field.nullable" :true-value='true' :false-value='false'></v-checkbox>
          </v-col>
          <v-col cols="12" md="6" v-if="field.type=='select' || field.type=='combobox' || field.type=='file' || field.type=='image'">
            <v-checkbox  v-model="field.multiple" label="Multiples" :true-value='true' :false-value='false'></v-checkbox>
          </v-col>
          <v-col cols="12" md="12" v-if="field.type=='select' || field.type=='combobox' || field.type=='radio'">
            <v-select  v-model="field.option.origin" @input="fillOptions(field.option.origin,f)" :items="database.tables" label="Extraer de tabla" item-text="name" item-text="name" clearable></v-select>
          </v-col>
          <v-col cols="12" md="12" v-if="field.type=='select' || field.type=='combobox' || field.type=='radio'">
            <v-combobox  v-model="field.option.data.value" :search-input.sync="search" small-chips clearable v-if="field.option.origin=='' || field.option.origin==null"  multiple hiden-selected label="Opciones">
              <template v-slot:no-data>
                <v-list-item>
                  <v-list-item-content>
                    <v-list-item-title>
                      Pulsa <kbd>Enter</kbd> para agregar {{search}}
                    </v-list-item-title>
                  </v-list-item-content>
                </v-list-item>
              </template>
              <template v-slot:selection="data">
                <v-chip
                  :key="JSON.stringify(data.item)"
                  v-bind="data.attrs"
                  :input-value="data.selected"
                  :disabled="data.disabled"
                  @click:close="data.parent.selectItem(data.item)"
                >
                  <v-avatar
                    class="accent white--text"
                    left
                    v-text="data.item.slice(0, 1).toUpperCase()"
                  ></v-avatar>
                  {{ data.item }}
                  <v-icon
                    small
                    @click="data.parent.selectItem(data.item)"
                  >
                    $delete
                  </v-icon>
                </v-chip>
              </template>
            </v-combobox>
            <div v-else>
              <v-select  v-model="field.option.data.key" :items="database.options" item-text="name" clearable item-value="name" label="Valor"></v-select>
              <v-select  v-model="field.option.data.value" :items="database.options" item-text="name" clearable item-value="name" label="Etiqueta"></v-select>
            </div>
          </v-col>
        </v-row>
      </v-col>
    </v-row>
    <p v-else>
      Select a field
    </p>
  </div>
  `,
  data: function() {
    return {
      search:null,
      default_value:[
        '--date--',
        '--time--',
        '--datetime--'
      ],
      fields_type:[
        {text:'Texto',value:'text'},
        {text:'Texto Enriquecido',value:'textarea'},
        {text:'Archivo',value:'file'},
        {text:'Imagen',value:'image'},
        {text:'Numero',value:'number'},
        {text:'Fecha',value:'date'},
        {text:'Hora',value:'time'},
        {text:'Boleano',value:'checkbox'},
        {text:'Lista desplegable',value:'select'},
        {text:'Autocompletado',value:'combobox'},
        {text:'Radio',value:'radio'},
        {text:'Marcador (Mapa)',value:'marker'},
        {text:'Poligono (Mapa)',value:'polygon'}
      ],
    }
  },
  props:['fields','database','selected'],
  methods: {
    fillOptions:function(table=null,index=null) {
      this.fields[index].option.data.key = ''
      this.fields[index].option.data.value = ''
      if (table!==null && table!=='') {
        axios.post('Database/fields/'+table)
        .then((response)=>{
          this.database.options = response.data
        })
      } else {
        this.database.options = []
      }
    },
  },
})

/* A Vue component that is used to render the options of a field. */
Vue.component('render-option-read',{
  template: `
  <div>
    <v-row v-if="selected">
      <v-col cols="12" md="12">
        <v-row v-for="(field,f) in fields" :key="field.name" v-if="field.name==selected">
          <v-col cols="12" md="12">
            <v-row>
              <v-col cols="12" md="12">
                <v-slider  v-model="field.width" :label="'Tamaño: '+field.width" min="3" max="12"></v-slider>
              </v-col>
              <v-col cols="12" md="12">
                <v-text-field  v-model="field.label" label="Etiqueta"></v-text-field>
              </v-col>
              <v-col cols="12" md="6">
                <v-select  v-model="field.type" :items="render_fields" item-text="text" item-value="value" label="Tipo de Campo"></v-select>
              </v-col>
              <v-col cols="12" md="6">
                <v-combobox  v-model="field.filter" :items="filter_value" label="Formato"></v-combobox>
              </v-col>
              <v-col cols="12" md="12">
                <v-checkbox v-model="field.hidden" label="Oculto"></v-checkbox>
              </v-col>
            </v-row>
          </v-col>
          <!--div v-if="type == 'merge'">
            <v-row v-for="(icon, mi) in form.content[active[0]].content[active[1]].content[active[2]].props.maps.icons">
              <v-col cols="12" md="3">
                <v-select v-model="form.content[active[0]].content[active[1]].content[active[2]].props.maps.icons[mi].field" :items="form.content[active[0]].content[active[1]].content[active[2]].data" label="Campo" item-value="name" item-text="label"></v-select>
              </v-col>
              <v-col cols="12" md="3">
                <v-text-field v-model="form.content[active[0]].content[active[1]].content[active[2]].props.maps.icons[mi].value" label="Valor"></v-text-field>
              </v-col>
              <v-col cols="12" md="3">
                <v-file-input @change="RenderFile('ref_file_',[active[0],active[1],active[2],mi])" :ref="'ref_file_'+mi" label="Icono"></v-file-input>
              </v-col>
              <v-col cols="12" md="3">
                <v-img :src="form.content[active[0]].content[active[1]].content[active[2]].props.maps.icons[mi].icon"></v-img>
              </v-col>
            </v-row>
            <v-row>
              <v-col cols="12" md="12">
                <v-btn x-small @click="form.content[active[0]].content[active[1]].content[active[2]].props.maps.icons.push({...{field:'',value:'',icon:''}})">Agregar Icono</v-btn>
              </v-col>
            </v-row>
          </div-->
        </v-row>
      </v-col>
    </v-row>
    <p v-else>
      Select a field
    </p>
  </div>
  `,
  data: function() {
    return {
      search:null,
      default_value:[
        '--date--',
        '--time--',
        '--datetime--'
      ],
      render_fields:[
        {text:'Imagen',value:'image'},
        {text:'Archivo',value:'file'},
        {text:'Checkbox',value:'checkbox'},
        {text:'Marcador (Mapa)',value:'marker'},
        {text:'Poligono (Mapa)',value:'polygon'}
      ],
      filter_value:[
        'capitalize',
        'decimals',
        'date',
        "truncate(100,'...')"
      ]
    }
  },
  props:['fields','database','type','selected','props'],
  methods: {
    fillOptions:function(table=null,index=null) {
      this.fields[index].option.data.key = ''
      this.fields[index].option.data.value = ''
      if (table!==null && table!=='') {
        if (this.database.tables.includes(table)) {
          axios.post(this.$root.p+'/get_tables/'+table+'?field')
          .then((response)=>{
            this.database.options = response.data
          })
        } else{
          this.database.options = []
        }
      } else {
        this.database.options = []
      }
    },
  },
})

/* Creating a component called render-option-view. */
Vue.component('render-option-view',{
  template: `
  <div>
    <v-row v-if="selected">
      <v-col cols="12" md="12">
        <v-row v-for="field in fields" :key="field.name" v-if="field.name==selected">
          <v-col cols="12" md="12">
            <v-slider v-model="field.width" :label="'Tamaño: '+field.width" min="3" max="12"></v-slider>
          </v-col>
          <v-col cols="12" md="6">
            <v-text-field  v-model="field.label" label="Etiqueta"></v-text-field>
          </v-col>
          <v-col cols="12" md="6">
            <v-select  v-model="field.type" :items="render_fields" item-text="text" item-value="value" label="Tipo de Campo"></v-select>
          </v-col>
        </v-row>
      </v-col>
    </v-row>
    <p v-else>
      Select a field
    </p>
  </div>
  `,
  data: function() {
    return {
      render_fields:[
        {text:'Imagen',value:'image'},
        {text:'Archivo',value:'file'},
        {text:'Checkbox',value:'checkbox'},
        {text:'Marcador (Mapa)',value:'marker'},
        {text:'Poligono (Mapa)',value:'polygon'}
      ]
    }
  },
  props:['fields','selected']
})

/* Creating a component called grid-builder. */
Vue.component('grid-builder',{
  template: `
  <div>
    <v-row>
      <v-col cols="12" md="12">
        <draggable class="row" :list="fields">
          <v-col v-for="(field,f) in fields" :key="field.name" v-if="field.visible==true" cols="12" :md="field.width">
            <v-card elevation="2" :shaped="selected==field.name?false:true" :color="selected==field.name?'blue-grey lighten-3':'blue-grey lighten-5'" light @click="SelectField(field.name)">
              <v-card-subtitle>
                {{field.name}} <v-chip color="red" x-small v-if="field.nullable==false">NOT NULL</v-chip>
              </v-card-subtitle>
            </v-card>
          </v-col>
        </draggable>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
    }
  },
  props:['fields','selected'],
  methods:{
    SelectField(id){
      this.$emit('select',id)
    }
  }
})

/* Creating a component called card-builder. */
Vue.component('card-builder',{
  template: `
  <div>
    <v-row>
      <v-col cols="12" md="4" v-for="c in 3">
        <v-card>
          <v-card-text>
            <draggable :list="fields" class="row">
              <v-col cols="12" :md="field.width" v-for="(field,f) in fields" v-if="field.visible" class="pa-0" @click="SelectField(field.name)">
                <v-card outlined>
                  <v-card-text class="pa-1">
                    <dt><strong>{{field.label}}</strong></dt>
                    <dd><small>{{field.name}}</small></dd>
                  </v-card-text>
                </v-card>
              </v-col>
            </draggable>
          </v-card-text>
        </v-card>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
    }
  },
  props:['fields','selected'],
  methods:{
    SelectField(id){
      this.$emit('select',id)
    }
  }
})

/* Creating a component called map-builder. */
Vue.component('map-builder',{
  template: `
  <div>
    <v-row>
      <v-col cols="12" md="12"  :style="'height:'+(windowHeight/2)+'px'">
        <l-map :center="{lat:6.795535,lng:-64.379883}" zoom="5">
          <l-tile-layer url="https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png" ></l-tile-layer>
          <l-marker :lat-lng="{lat:6.795535,lng:-64.379883}" v-for="c in 1">
            <l-popup :options="popup">
              <v-row>
                <v-col cols="12" md="12">
                  Popup Example
                </v-col>
              </v-row>
              <draggable :list="fields" class="row">
                <v-col cols="12" :md="field.width" v-for="(field,f) in fields" v-if="field.visible && !field.hidden" class="pa-0" @click="SelectField(field.name)">
                  <v-card flat outlined>
                    <v-card-text class="pa-1">
                      <dt><strong>{{field.label}}</strong></dt>
                      <dd><small>{{field.name}}</small></dd>
                    </v-card-text>
                  </v-card>
                </v-col>
              </draggable>
            </l-popup>
          </l-marker>
        </l-map>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
      windowWidth:window.innerWidth,
      windowHeight:window.innerHeight,
      popup:{
        minWidth: null,
        maxWidth: null
      }
    }
  },
  props:['fields','selected'],
  methods:{
    SelectField(id){
      this.$emit('select',id)
    }
  },
  created() {
    this.mapWidth = this.windowWidth/2
    this.popup.maxWidth = this.mapWidth/1.5
    this.popup.minWidth = this.mapWidth/2
  },
})

/* Creating a component called map-builder. */
Vue.component('merge-builder',{
  template: `
  <div>
    <v-row>
      <v-col cols="12" md="12"  :style="'height:'+(windowHeight/2)+'px'">
        <l-map :center="{lat:6.795535,lng:-64.379883}" zoom="5">
          <l-tile-layer url="https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png" ></l-tile-layer>
          <l-marker :lat-lng="{lat:6.795535,lng:-64.379883}" v-for="c in 1">
            <l-popup :options="popup">
              <v-row>
                <v-col cols="12" md="12">
                  Popup Example
                </v-col>
              </v-row>
              <draggable :list="fields" class="row">
                <v-col cols="12" :md="field.width" v-for="(field,f) in fields" v-if="field.visible && !field.hidden" class="pa-0" @click="SelectField(field.name)">
                  <v-card flat outlined>
                    <v-card-text class="pa-1">
                      <dt><strong>{{field.label}}</strong></dt>
                      <dd><small>{{field.name}}</small></dd>
                    </v-card-text>
                  </v-card>
                </v-col>
              </draggable>
            </l-popup>
          </l-marker>
        </l-map>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
      windowWidth:window.innerWidth,
      windowHeight:window.innerHeight,
      popup:{
        minWidth: null,
        maxWidth: null
      }
    }
  },
  props:['fields','selected'],
  methods:{
    SelectField(id){
      this.$emit('select',id)
    }
  },
  created() {
    this.mapWidth = this.windowWidth/2
    this.popup.maxWidth = this.mapWidth/1.5
    this.popup.minWidth = this.mapWidth/2
  },
})

/* Creating a component called table-builder. */
Vue.component('table-builder',{
  template: `
  <div>
    <v-simple-table dense>
      <template v-slot:default>
        <thead>
          <draggable tag="tr" :list="fields">
            <th v-for="(field,f) in fields" :key="'TH'+field.name" v-if="field.visible==true" :width="toWidth(field.width)+'%'" class="text-center" @click="SelectField(field.name)">
              <v-icon small>ri-drag-drop-line</v-icon> {{field.label}}
            </th>
            <th width="10%" class="text-center">Action</th>
          </draggable>
        </thead>
        <tbody>
          <tr>
            <td v-for="(field,f) in fields" :key="'FO'+f" v-if="field.visible==true" :width="toWidth(field.width)+'%'" class="text-center" @click="SelectField(field.name)">
              {{field.name}}
            </td>
            <td class="text-center">...</td>
          </tr>
        </tbody>
      </template>
    </v-simple-table>
  </div>
  `,
  data: function() {
    return {
    }
  },
  props:['fields','selected'],
  methods:{
    SelectField(id){
      this.$emit('select',id)
    },
    toWidth(f) {
      var pre_width = (f/12)*100;
      return (pre_width*89)/100;
    }
  }
})

/* Creating a component called visual-builder. This component is a wrapper for the other components. It
is also the component that is used in the HTML. */
Vue.component('visual-builder',{
  template: `
  <div>
    <v-row>
      <v-col cols="12" md="3">
        <component is="render-field" :fields="fields" @select="SelectField"></component>
      </v-col>
      <v-col cols="12" :md="selected || type=='merge'?6:9">
        <component :is="type+'-builder'" :fields="fields" @select="SelectField" :selected="selected"></component>
      </v-col>
      <v-col cols="12" md="3" v-if="type=='merge'">
        <div>
          <v-row v-for="(icon, mi) in props.maps.icons">
            <v-col cols="12" md="3">
              <v-select v-model="props.maps.icons[mi].field" :items="fields" label="Campo" item-value="name" item-text="label"></v-select>
            </v-col>
            <v-col cols="12" md="3">
              <v-text-field v-model="props.maps.icons[mi].value" label="Valor"></v-text-field>
            </v-col>
            <v-col cols="12" md="3">
              <v-file-input @change="RenderFile('ref_file_',mi)" :ref="'ref_file_'+mi" label="Icono"></v-file-input>
            </v-col>
            <v-col cols="12" md="3">
              <v-img :src="props.maps.icons[mi].icon"></v-img>
            </v-col>
          </v-row>
          <v-row>
            <v-col cols="12" md="12">
              <v-btn x-small @click="props.maps.icons.push({...{field:'',value:'',icon:''}})">Agregar Icono</v-btn>
            </v-col>
          </v-row>
        </div>
        <component :is="'render-option-'+template_selected" :fields="fields" :selected="selected" :database="database?database:null" :type="type?type:null" :props="props?props:null"></component>
      </v-col>
      <v-col cols="12" md="3" v-if="selected && type!=='merge'">
        <component :is="'render-option-'+template_selected" :fields="fields" :selected="selected" :database="database?database:null" :type="type?type:null" :props="props?props:null"></component>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
      selected:null,
      template_selected:null
    }
  },
  props:['fields','database','template','type','props'],
  methods:{
    SelectField(id){
      if (id==this.selected){
        this.selected = null
        this.$root.toast.show({
          message:id+" Deselected",
          color:'cyan'
        })
      } else {
        this.selected = id
        this.$root.toast.show({
          message:id+" Selected",
          color:'cyan'
        })
      }
    },
    RenderFile(r,i){
      if (this.$refs[r+i][0].lazyValue!==null) {
        const file = this.$refs[r+i][0].lazyValue
        const reader = new FileReader()
        reader.onload = (e)=>{
          this.props.maps.icons[i].icon = e.target.result
        }
        reader.readAsDataURL(file)
      } else {
        this.props.maps.icons[i].icon = null
      }
    }
  },
  created() {
    switch(this.template){
      case 'create':
        this.template_selected = 'create'
      break
      case 'update':
        this.template_selected = 'create'
      break
      default:
        this.template_selected = this.template
      break
    }
  },
})

/* Creating a component called loader. */
Vue.component('loader',{
  template: `
  <div>
    <v-row>
      <v-col cols="12">
        <v-skeleton-loader type="card-avatar, article, actions"></v-skeleton-loader>
      </v-col>
    </v-row>
  </div>
  `,
  data: function() {
    return {
    }
  }
})

Vue.component('page-title',{
  template: `
  <v-banner>
    {{title}}
  </v-banner>
  `,
  data: function() {
    return {
    }
  },
  props:['title']
})