<?php

namespace App\Controllers;

class API extends BaseController
{
  public function get($table = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);

    $qry = $this->db->table("{$table}");
    if ($form) {
      foreach ($form as $key => $val) {
        if ($key == "select" and !empty($val)) {
          $qry->select($val);
        }
        if ($key == "inner_join" and !empty($val)) {
          if ($val) {
            foreach ($val as $k => $v) {
              $qry->join($k,$v,"inner");
            }
          }
        }
        if ($key == "left_join" and !empty($val)) {
          if ($val) {
            foreach ($val as $k => $v) {
              $qry->join($k,$v,"left");
            }
          }
        }
        if ($key == "limit") {
          $qry->limit($val);
        }
        if ($key == "group_by" and !empty($val)) {
          $qry->groupBy($val);
        }
        if ($key == "where" and !empty($val)) {
          foreach ($val as $key => $value) {
            if (is_array($value)) {
              foreach ($value as $k => $v) {
                if ($k==0) {
                  $qry->where($key,$v);
                } else {
                  $qry->orWhere($key,$v);
                }
              }
            } else {
              $qry->where($key,$val);
            }
          }
        }
        if ($key == "orwhere" and !empty($val)) {
          $qry->orWhere($val);
        }
        if ($key == "like" and !empty($val)) {
          $qry->like($val);
        }
      }
    }

    $exec = $qry->get()->getResultArray();
    #$exec = $qry->get();
    #echo $this->db->getLastQuery();
    echo json($exec);
  }

  public function put($table)
  {
    if (isset($_REQUEST['multipart']) and $_REQUEST['multipart'] == true) {
      $form['data'] = [];
      $data = $this->db->table('sys_component')->where(['ID' => $_REQUEST['sys_component']])->get()->getRowArray();
      foreach (json_decode($data['data'], true) as $field) {
        if ($field['visible'] == true) {
          if ($field['type'] == 'file' || $field['type'] == 'image') {
            if (boolval($field['multiple'])) {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : []);
            } else {
              $form['data'][$field['name']] = !empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : null;
            }
          } else {
            $form['data'][$field['name']] = is_array($_REQUEST[$field['name']])?json_encode($_REQUEST[$field['name']]):$_REQUEST[$field['name']];
          }
        }
      }
    } else {
      $data = json_decode(file_get_contents('php://input'), true);
      $form['data'] = [];
      foreach ($data as $key => $value) {
        $form['data'][$key] = is_array($value) ? json_encode($value) : $value;
      }
    }
    if ($this->db->table($table)->set($form['data'])->insert()) {
      $last_id = $this->db->insertID();
      $response['status'] = 200;
      $response['ID'] = $last_id;
    } else {
      $response['status'] = 500;
      $response['message'] = $this->db->error();
    }
    echo json_encode($response);
  }

  public function delete($table)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    unset($form['data']['']);
    if ($this->db->table($table)->where($form['where'])->delete()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }
}