<?php

namespace App\Controllers;

class Component extends BaseController
{
  public function get($id = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);

    $sttm = $this->db->table('sys_component');
    $array = true;
    if (isset($form['where'])) {
      foreach ($form['where'] as $key => $value) {
        $sttm->where($key,$value);
      } 
    }
    $results = $sttm->get()->getResultArray();

    $response = $results;
    if (isset($form['result']) && $form['result']=='row') {
      $array = false;
      $response = $results[0];
    }

    echo json($response,true,$array);
  }
  public function add()
  {
    $form = json_decode(file_get_contents('php://input'), true);
    foreach ($form as $key => $value) {
      $data = [];
      foreach ($value as $k => $v) {
        $data[$k] = is_array($v)?json_encode($v):$v;
      }
      $st = $this->component->set($data)->insert();
    }
  }
  public function set($id)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $data = [];
    foreach ($form as $k => $v) {
      $data[$k] = is_array($v)?json_encode($v):$v;
    }
    $where['ID'] = $id;
    $st = $this->component->set($data)->where($where)->update();
  }
  public function renders($id)
  {
    $where['ID'] = $id;
    $response = $this->db->table('sys_component')->where($where)->get()->getRowArray();
    $response['data'] = json_decode($response['data'], true);
    $response['props'] = json_decode($response['props'], true);
    $response['attr'] = json_decode($response['attr'], true);
    $response['query'] = json_decode($response['query'], true);
    $data['response'] = $response;
    return view("render/{$response['template']}/{$response['type']}", $data);
  }
  public function list($id = null)
  {
    if ($id == null) {
      $input = json_decode(file_get_contents('php://input'), true);
      if (isset($input['q'])) {
        $q = array_filter($input['q']);
      } else {
        $q = [];
      }

      if (isset($input['pagination']) and $input['pagination']['per_page'] !== 0) {
        $pagination['per_page'] = $input['pagination']['per_page'];
        $pagination['page'] = $input['pagination']['page'];
        $pagination['page_firts_result'] = round(($pagination['page'] - 1) * $pagination['per_page']);
      } else {
        $pagination = null;
      }

      $response = $this->component->select('name,codename,type,props,template')->findAll();
      for ($i = 0; $i < count($response); $i++) {
        $response[$i]['props'] = json_decode($response[$i]['props'], true);
        $response[$i]['action'] = json_decode($response[$i]['action'], true);
        $response[$i]['width'] = 12;
        $response[$i]['id'] = 0;
        $response[$i]['keyname'] = random_string('alpha', 5);
        switch ($response[$i]['template']) {
          case 'create':
            $response[$i]['default']['color'] = 'success';
            $response[$i]['default']['icon'] = 'bi bi-plus';
            break;
          case 'read':
            $response[$i]['default']['color'] = 'primary';
            $response[$i]['default']['icon'] = 'bi bi-eye';
            break;
          case 'update':
            $response[$i]['default']['color'] = 'info';
            $response[$i]['default']['icon'] = 'bi bi-pencil-square';
            break;
          case 'delete':
            $response[$i]['default']['color'] = 'error';
            $response[$i]['default']['icon'] = 'bi bi-trash';
            break;

          default:
            $response[$i]['default']['color'] = 'pink';
            $response[$i]['default']['icon'] = 'bi bi-hand-index-thumb';
            break;
        }

      }
      $results = $this->component->GetCountAll($q);
    } else {
      $pagination = null;
      $response = $this->component->where('ID', $id)->first();
      $response['data'] = json_decode($response['data']);
      $response['props'] = json_decode($response['props'], true);
      $response['action'] = json_decode($response['action'], true);
      $response['width'] = 12;
      $response['id'] = 0;
      $response['keyname'] = random_string('alpha', 5);
    }

    //echo $this->db->getLastQuery();
    if ($pagination !== null) {
      echo json_encode(['results' => $response, 'page' => $pagination['page'], 'per_page' => $pagination['per_page'], 'total_rows' => intval($results['total'])]);
    } else {
      echo json_encode(['results' => $response, 'page' => 1, 'per_page' => 1, 'total_rows' => 0]);
    }
  }
  public function get_tables($table = null)
  {
    if (!empty($table)) {
      $tables = $this->db->getFieldData($table);
      if (isset($_REQUEST['field'])) {
        $response = [];
        for ($i = 0; $i < count($tables); $i++) {
          $response[$i] = $tables[$i]->name;
        }
        $tables = $response;
      } else {
        for ($i = 0; $i < count($tables); $i++) {
          switch ($tables[$i]->type) {
            case 'int':
              $tables[$i]->type = 'number';
              break;
            case 'varchar':
              $tables[$i]->type = 'text';
              break;
            case 'text':
              $tables[$i]->type = 'textarea';
              break;
            case 'date':
              $tables[$i]->type = 'date';
              break;
            case 'time':
              $tables[$i]->type = 'time';
              break;

            default:
              $tables[$i]->type = 'text';
              break;
          }
          $tables[$i]->option = [
            'origin' => null,
            'data' => ['key' => null, 'value' => null]
          ];
          $tables[$i]->label = $tables[$i]->name;
          $tables[$i]->width = 6;
          $tables[$i]->visible = true;
          $tables[$i]->helper = null;
          $tables[$i]->filter = null;
          $tables[$i]->hidden = false;
          $tables[$i]->disabled = false;
          $tables[$i]->required = ($tables[$i]->nullable == false) ? true : false;
          $tables[$i]->multiple = false;
        }
      }
    } else {
      if (isset($_GET['multiple'])) {
        $input = json_decode(file_get_contents('php://input'), true);
        $tables = [];
        foreach ($input['tables'] as $table) {
          $get_tables = $this->db->getFieldData($table);
          for ($i = 0; $i < count($get_tables); $i++) {
            switch ($get_tables[$i]->type) {
              case 'int':
                $ff['type'] = 'number';
                break;
              case 'varchar':
                $ff['type'] = 'text';
                break;
              case 'text':
                $ff['type'] = 'textarea';
                break;
              case 'date':
                $ff['type'] = 'date';
                break;
              case 'time':
                $ff['type'] = 'time';
                break;

              default:
                $ff['type'] = 'text';
                break;

            }
            $ff['option'] = [
              'origin' => null,
              'data' => ['key' => null, 'value' => null]
            ];
            $ff['name'] = $table . "." . $get_tables[$i]->name;
            $ff['label'] = str_replace(["_"], ' ', $get_tables[$i]->name);
            $ff['primary_key'] = $get_tables[$i]->primary_key;
            $ff['nullable'] = $get_tables[$i]->nullable;
            $ff['width'] = 6;
            $ff['visible'] = true;
            $ff['helper'] = null;
            $ff['filter'] = null;
            $ff['hidden'] = false;
            $ff['disabled'] = false;
            $ff['required'] = ($ff['nullable'] == false) ? true : false;
            $ff['multiple'] = false;
            array_push($tables, $ff);
          }
        }
      } else {
        $tables = $this->db->listTables();
        $tables = array_merge(array_diff($tables, ['sys_component', 'sys_menu', 'sys_modules', 'sys_settings', 'sys_admin', 'sys_post', 'sys_element', 'migrations']));
      }
    }
    echo json_encode($tables);
  }
  public function get_fields()
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $query = $this->db->query($form['query']);
    $response = $query->getFieldNames();
    echo json_encode($response);
  }
  public function create($table)
  {
    if (isset($_REQUEST['multipart']) and $_REQUEST['multipart'] == true) {
      $form['data'] = [];
      $data = $this->db->table('sys_component')->where(['ID' => $_REQUEST['sys_component']])->get()->getRowArray();
      foreach (json_decode($data['data'], true) as $field) {
        if ($field['visible'] == true) {
          if ($field['type'] == 'file' || $field['type'] == 'image') {
            if (boolval($field['multiple'])) {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : []);
            } else {
              $form['data'][$field['name']] = json_encode(!empty($_FILES[$field['name']]) ? save_file($_FILES[$field['name']]) : '{}');
            }
          } else {
            $form['data'][$field['name']] = $_REQUEST[$field['name']];
          }
        }
      }
    } else {
      $form = json_decode(file_get_contents('php://input'), true);
      $tables = $this->db->getFieldData($table);
      foreach ($tables as $field) {
        if (isset($form['data'][$field->name])) {
          $form['data'][$field->name] = is_array($form['data'][$field->name]) ? json_encode($form['data'][$field->name]) : $form['data'][$field->name];
        }
      }
    }
    if ($this->db->table($table)->set($form['data'])->insert()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }
  public function read($table = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $tables = [];
    if (isset($form['data']['from']) and !empty($form['data']['from'])) {
      $query = $this->db->table($form['data']['from'][0]);
      unset($form['data']['from'][0]);
      foreach (array_values($form['data']['from']) as $table) {
        $tables[] = $table;
        $query->from($table);
      }
    } else {
      $tables[] = $table;
      $query = $this->db->table($table);
    }
    if (isset($form['data']['select']) and !empty($form['data']['select'])) {
      foreach ($form['data']['select'] as $value) {
        $query->select("{$value} AS " . str_replace('.', '_', $value));
      }
    }
    if (isset($form['data']['rule']) and count($form['data']['rule']) > 0) {
      foreach ($form['data']['rule'] as $field) {
        switch ($field['comparator']) {
          case 'Igual':
            $operator = '=';
            break;
          case 'No Igual':
            $operator = '!=';
            break;
          case 'Menor':
            $operator = '<';
            break;
          case 'Mayor':
            $operator = '>';
            break;
          case 'Menor o Igual':
            $operator = '<=';
            break;
          case 'Mayor o Igual':
            $operator = '>=';
            break;
          case 'Contiene':
            $operator = 'LIKE';
            break;

          case '=':
            $operator = '=';
            break;
          case '!=':
            $operator = '!=';
            break;
          case '<':
            $operator = '<';
            break;
          case '>':
            $operator = '>';
            break;
          case '<=':
            $operator = '<=';
            break;
          case '>=':
            $operator = '>=';
            break;
          case 'LIKE':
            $operator = 'LIKE';
            break;

          default:
            $operator = '=';
            break;
        }

        switch ($field['value']) {
          case '':
            $value = null;
            break;

          default:
            $value = (isset($field['type']) && $field['type']=='prop')?$form['props'][$field['value']]:$field['value'];
            break;
        }
        if ($operator == 'LIKE') {
          if ($field['conector'] == 'OR') {
            $query->orLike($field['key'], $value, 'both', false);
          } else {
            $query->like($field['key'], $value, 'both', false);
          }
        } else {
          if ($field['conector'] == 'OR') {
            $query->orWhere("{$field['key']} {$operator}", $value, $field['escape']);
          } else {
            $query->where("{$field['key']} {$operator}", $value, $field['escape']);
          }
        }
      }
    }
    if (isset($form['data']['group'])) {
      foreach ($form['data']['group'] as $item) {
        $query->groupStart();
        foreach ($item['rule'] as $field) {
          switch ($field['comparator']) {
            case 'Igual':
              $operator = '=';
              break;
            case 'No Igual':
              $operator = '!=';
              break;
            case 'Menor':
              $operator = '<';
              break;
            case 'Mayor':
              $operator = '>';
              break;
            case 'Menor o Igual':
              $operator = '<=';
              break;
            case 'Mayor o Igual':
              $operator = '>=';
              break;
            case 'Contiene':
              $operator = 'LIKE';
              break;

            default:
              $operator = '=';
              break;
          }
          switch ($field['value']) {
            case '':
              $value = null;
              break;

            default:
              $value = $field['value'];
              break;
          }
          if ($operator == 'LIKE') {
            if ($field['conector'] == 'OR') {
              $query->orLike($field['key'], $value, 'both', false);
            } else {
              $query->like($field['key'], $value, 'both', false);
            }
          } else {
            if ($field['conector'] == 'OR') {
              $query->orWhere("{$field['key']} {$operator}", $value);
            } else {
              $query->where("{$field['key']} {$operator}", $value);
            }
          }
        }
        $query->groupEnd();
      }
    }
    $response = $query->get()->getResultArray();
    $query_fields = $this->db->query($this->db->getLastQuery());
    if (isset($form['result']) and $form['result'] == 'row') {
      foreach ($query_fields->getFieldNames() as $field) {
        $decode = json_decode($response[0][$field->name]);
        $response[0][$field] = !is_array($decode) ? $response[0][$field] : json_decode($response[0][$field]);
      }
    } else {
      foreach ($response as $key => $value) {
        foreach ($query_fields->getFieldNames() as $field) {
          $decode = json_decode($response[$key][$field], true);
          $response[$key][$field] = !is_array($decode) ? $response[$key][$field] : json_decode($response[$key][$field], true);
        }
      }
    }
    if (isset($form['result']) and $form['result'] == 'row') {
      echo json_encode($response[0]);
    } else {
      echo json_encode($response);
    }
  }
  public function update($table)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    unset($form['data']['']);
    foreach ($form['data'] as $key => $value) {
      if (!empty($key)) {
        $convert = json_decode($form['data'][$key], true);
        $form['data'][$key] = !is_array($convert) ? $value : json_encode($form['data'][$key]);
      }
    }
    if ($this->db->table($table)->set($form['data'])->where($form['where'])->update()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }
  public function delete($table)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    unset($form['data']['']);
    if ($this->db->table($table)->where($form['where'])->delete()) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
    }
    echo json_encode($response);
  }
  public function view($table = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];
    $tables = [];
    if (isset($form['data']['from']) and !empty($form['data']['from'])) {
      $query = $this->db->table($form['data']['from'][0]);
      unset($form['data']['from'][0]);
      foreach (array_values($form['data']['from']) as $table) {
        $tables[] = $table;
        $query->from($table);
      }
    } else {
      $tables[] = $table;
      $query = $this->db->table($table);
    }
    if (isset($form['data']['select']) and !empty($form['data']['select'])) {
      foreach ($form['data']['select'] as $value) {
        $query->select("{$value} AS " . str_replace('.', '_', $value));
      }
    }
    if (isset($form['data']['rule']) and count($form['data']['rule']) > 0) {
      foreach ($form['data']['rule'] as $field) {
        switch ($field['comparator']) {
          case 'Igual':
            $operator = '=';
            break;
          case 'No Igual':
            $operator = '!=';
            break;
          case 'Menor':
            $operator = '<';
            break;
          case 'Mayor':
            $operator = '>';
            break;
          case 'Menor o Igual':
            $operator = '<=';
            break;
          case 'Mayor o Igual':
            $operator = '>=';
            break;
          case 'Contiene':
            $operator = 'LIKE';
            break;

          case '=':
            $operator = '=';
            break;
          case '!=':
            $operator = '!=';
            break;
          case '<':
            $operator = '<';
            break;
          case '>':
            $operator = '>';
            break;
          case '<=':
            $operator = '<=';
            break;
          case '>=':
            $operator = '>=';
            break;
          case 'LIKE':
            $operator = 'LIKE';
            break;

          default:
            $operator = '=';
            break;
        }

        switch ($field['value']) {
          case '':
            $value = null;
            break;

          default:
            $value = $field['value'];
            break;
        }
        if ($operator == 'LIKE') {
          if ($field['conector'] == 'OR') {
            $query->orLike($field['key'], $value, 'both', false);
          } else {
            $query->like($field['key'], $value, 'both', false);
          }
        } else {
          if ($field['conector'] == 'OR') {
            $query->orWhere("{$field['key']} {$operator}", $value, $field['escape']);
          } else {
            $query->where("{$field['key']} {$operator}", $value, $field['escape']);
          }
        }
      }
    }
    if (isset($form['data']['group'])) {
      foreach ($form['data']['group'] as $item) {
        $query->groupStart();
        foreach ($item['rule'] as $field) {
          switch ($field['comparator']) {
            case 'Igual':
              $operator = '=';
              break;
            case 'No Igual':
              $operator = '!=';
              break;
            case 'Menor':
              $operator = '<';
              break;
            case 'Mayor':
              $operator = '>';
              break;
            case 'Menor o Igual':
              $operator = '<=';
              break;
            case 'Mayor o Igual':
              $operator = '>=';
              break;
            case 'Contiene':
              $operator = 'LIKE';
              break;

            default:
              $operator = '=';
              break;
          }
          switch ($field['value']) {
            case '':
              $value = null;
              break;

            default:
              $value = $field['value'];
              break;
          }
          if ($operator == 'LIKE') {
            if ($field['conector'] == 'OR') {
              $query->orLike($field['key'], $value, 'both', false);
            } else {
              $query->like($field['key'], $value, 'both', false);
            }
          } else {
            if ($field['conector'] == 'OR') {
              $query->orWhere("{$field['key']} {$operator}", $value);
            } else {
              $query->where("{$field['key']} {$operator}", $value);
            }
          }
        }
        $query->groupEnd();
      }
    }
    $query->where($form['main']);
    $response = $query->get()->getResultArray();
    $query_fields = $this->db->query($this->db->getLastQuery());
    if (isset($form['result']) and $form['result'] == 'row') {
      foreach ($query_fields->getFieldNames() as $field) {
        $decode = json_decode($response[0][$field->name]);
        $response[0][$field] = !is_array($decode) ? $response[0][$field] : json_decode($response[0][$field]);
      }
    } else {
      foreach ($response as $key => $value) {
        foreach ($query_fields->getFieldNames() as $field) {
          $decode = json_decode($response[$key][$field], true);
          $response[$key][$field] = !is_array($decode) ? $response[$key][$field] : json_decode($response[$key][$field], true);
        }
      }
    }
    if (isset($form['result']) and $form['result'] == 'row') {
      echo json_encode($response[0]);
    } else {
      echo json_encode($response);
    }
  }
}