<?php

namespace App\Controllers;

class Settings extends BaseController
{
  public function get($key = null)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    if (!empty($key)) {
      $response = $this->db->table('sys_settings')->where('key', $key)->get()->getRowArray();
      foreach ($response as $key => $value) {
        $decode = json_decode($value, true);
        $response[$key] = is_array($decode) || is_bool($decode) ? $decode : $value;
      }
    } else {
      $response = $this->db->table('sys_settings')->get()->getResultArray();
      foreach ($response as $key => $value) {
        foreach ($value as $k => $v) {
          $decode = json_decode($v, true);
          $response[$key][$k] = is_array($decode) || is_bool($decode) ? $decode : $v;
        }
      }
    }
    echo json_encode($response);
  }
  public function set($key)
  {
    $form = json_decode(file_get_contents('php://input'), true);
    $response = [];

    $sql = $this->db->table('sys_settings')
      ->set(['value' => ($form['data']['value']?'true':'false'), 'config' => is_array($form['data']['config'])?json_encode($form['data']['config']):$form['data']['config']])
      ->where('key', $key)
      ->update();

    if ($sql) {
      $response['status'] = 200;
    } else {
      $response['status'] = 500;
      $response['message'] = $this->db->error();
    }
    echo json_encode($response);
  }
}