<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Posts extends Migration
{
	public function up()
	{
		$this->forge = \Config\Database::forge();
		$this->forge->addField([
			'ID' => [
				'type' => 'INT',
				'constraint' => 11,
				'auto_increment' => true,
				'null' => false
			],
			'type' => [
				'type' => 'VARCHAR',
				'constraint' => 50,
				'null' => true
			],
			'slug' => [
				'type' => 'VARCHAR',
				'constraint' => 100,
				'null' => true
			],
			'cover' => [
				'type' => 'MEDIUMTEXT',
				'null' => true
			],
			'title' => [
				'type' => 'TEXT',
				'null' => true
			],
			'description' => [
				'type' => 'TEXT',
				'null' => true
			],
			'content' => [
				'type' => 'LONGTEXT',
				'null' => true
			],
			'variable' => [
				'type' => 'TEXT',
				'null' => true
			],
			'active' => [
				'type' => 'VARCHAR',
				'constraint' => 50,
				'null' => true
			],
			'is_visible' => [
				'type' => 'INT',
				'constraint' => 1,
				'null' => false,
				'default' => 1
			],
			'is_system' => [
				'type' => 'INT',
				'constraint' => 1,
				'null' => false,
				'default' => 0
			]
		]);
		$this->forge->addKey('ID', true);
		$this->forge->createTable('sys_post');
	}

	public function down()
	{
		$this->forge->dropTable('sys_post');
	}
}