<?php
if (! function_exists('array_to_html')) {
  function array_to_html(array $list, $attributes = ''): string
  {
      return _list('ul', $list, $attributes);
  }
}
if (! function_exists('_list')) {
  function _list(string $type = 'div', $list = [], $attributes = '', int $depth = 0): string
  {
    $out = str_repeat(' ', $depth)
    . '<' . $type . stringify_attributes($attributes) . ">\n";

        // Cycle through the list elements.  If an array is
        // encountered we will recursively call _list()

    foreach ($list as $key => $val) {
      $out .= str_repeat(' ', $depth + 2) . '<li>';

      if (! is_array($val)) {
        $out .= $val;
      } else {
        $out .= $key
        . "\n"
        . _list($type, $val, '', $depth + 4)
        . str_repeat(' ', $depth + 2);
      }

      $out .= "</li>\n";
    }

        // Set the indentation for the closing tag and apply it
    return $out . str_repeat(' ', $depth) . '</' . $type . ">\n";
  }
}
if (! function_exists('json')) {
  function json($j=[],$e=true,$m=true){
    $result = [];
    if (!empty($j)) {
      if ($m==true) {
        $result = array_reduce($j,function($res,$item){
          foreach ($item as $key => $value) {
            $dec = is_array($value)?$value:json_decode($value,true);
            $val = is_array($dec)?$dec:$value;
            $item[$key] = $val;
          }
          $res[] = $item;
          return $res;
        },[]);
      } else {
        foreach ($j as $key => $value) {
          $dec = is_array($value)?$value:json_decode($value,true);
          $val = is_array($dec)?$dec:$value;
          $j[$key] = $val;
        }
        $result = $j;
      }
    }
    if ($e==true) {
      return json_encode($result);
    }else{
      return $result;
    }
  }
}
?>