<?php
  $this->uri = service('uri');
  $pk = '';
  $map_type = [];
  $methods = [];
  $created = [];

  $created[] = 'this.Data()';
  $models['title'] = $response['name'];
  $models['to_remove'] = false;
  $models['remove_item'] = null;
  $models['item'] = [];
  $main = null;
  $models['query'] = $response['query'];
  $width_action = 10;

  foreach ($response['data'] as $field) {
    $fieldname = str_replace('.','_',$field['name']);
    $main_table = explode('.',$field['name']);
    if ($field['type'] == 'marker') {
      $latlng = $field['name'];
      $map_type[] = [
        'name'=>$field['name'],
        'label'=>$field['label'],
        'field'=>$field['field'],
        'type'=>$field['type']
      ];
    }
    if ($field['type'] == 'polygon') {
      $latlng = $field['name'];
      $map_type[] = [
        'name'=>$field['name'],
        'label'=>$field['label'],
        'field'=>$field['field'],
        'type'=>$field['type']
      ];
    }
    if ($field['type'] == 'image') {
      $models["slider_image_{$fieldname}"] = null;
    }
    if ($field['type'] == 'file') {
      $models["slider_file_{$fieldname}"] = null;
    }

    if ($main_table[0] == $response['table'] and $field['primary_key'] == '1') {
      $pk = $field['name'];
      $models['query']['select'][] = $field['name'];
      $main = $pk;
    }
    if ($field['visible']==true) {
      $pre_width = ($field['width']/12)*100;
      $width = ($pre_width*(100-$width_action))/100;
      $models['headers'][] = [
        'text'=>"{$field['label']}",
        'sortable'=>true,
        'value'=>str_replace('.','_',$field['name'])
      ];
      $models['export']['headers'][] = [
        'title'=>"{$field['label']}",
        'dataKey'=>str_replace('.','_',$field['name']),
        'width'=>"{$width}%"
      ];
      $models['query']['select'][] = $field['name'];
    }
  }
  $models['headers'][] = [
    'text'=>"...",
    'width'=>"{$width_action}%"
  ];

  $props['props'] = [];

  foreach ($response['props'] as $key => $value) {
    $props['props'][] = $key;
  }
?>

Vue.component('<?=$response['codename']?>',{template: `
  <div>
    <v-card>
      <v-card-title>
        <?=$response['name']?>
      </v-card-title>
      <v-card-text>
        <v-row>
          <?php foreach($response['data'] as $field):?>
            <?php if ($field['visible']==true): ?>
              <?php
                $pre_width = ($field['width']/12)*100;
                $width = round($pre_width,0);
                $fieldname = str_replace('.','_',$field['name']);
                if ($field['filter']==''){
                  $filter = '';
                }elseif($field['filter']==null){
                  $filter = '';
                }else {
                  $filter = " | {$field['filter']}";
                }
              ?>
              <v-col cols="12" md="<?= $field['width'] ?>">
                <?php if ($field['type']=='checkbox'): ?>
                  <v-icon :color="item.<?=$fieldname?>==1?'success':'error'" true-value="1">{{item.<?=$fieldname?>==1?'bi bi-check':'bi bi-x'}}</v-icon>
                <?php elseif ($field['type']=='image'): ?>
                  <v-slide-group v-model="<?= "slider_image_{$fieldname}"?>" class="pa-4" show-arrows v-if="typeof item.<?=$fieldname?> == 'object'">
                    <v-slide-item v-for="img in item.<?=$fieldname?>">
                      <v-img :src="img" :aspect-ratio="1/1" contain></v-img>
                    </v-slide-item>
                  </v-slide-group>
                  <v-img v-else-if="typeof item.<?=$fieldname?> == 'string'" :src="item.<?=$fieldname?>?item.<?=$fieldname?>:item.<?=$fieldname?>" width="100%" contain></v-img>
                <?php elseif ($field['type']=='file'): ?>
                  <v-icon :color="item.<?=$fieldname?>==1?'success':'error'" true-value="1">{{item.<?=$fieldname?>==1?'bi bi-check':'bi bi-x'}}</v-icon>
                <?php else: ?>
                  <dt class="text-h6"><?=$field['label']?></dt>
                  <dd class="text-caption">{{item.<?=$fieldname?>}}</dd>
                <?php endif ?>
              </v-col>
            <?php endif ?>
          <?php endforeach?>
        </v-row>
      </v-card-text>
    </v-card>
    <v-dialog v-model="to_remove" transition="dialog-bottom-transition" max-width="300" persistent>
      <template v-slot:default="dialog">
        <v-card>
          <v-card-title class="text-center text-h5">
            <v-icon color="red">bi-trash</v-icon><v-divider class="mx-4" inset vertical></v-divider> {{$t('action.delete')}} {{$t('section.record')}}
          </v-card-title>
          <v-card-text>
            {{$t('alert.delete',{el:$t('section.record')})}}
          </v-card-text>
          <v-card-actions class="justify-space-between">
            <v-btn text color="success" @click="Delete()"><v-icon>bi-check</v-icon> {{$t('action.delete')}}</v-btn>
            <v-btn text @click="to_remove=false,remove_item=null"><v-icon>bi-x</v-icon> {{$t('action.close')}}</v-btn>
          </v-card-actions>
        </v-card>
      </template>
    </v-dialog>
  </div>
  `,
  data:()=>{return <?= json_encode($models) ?>},
  props:<?= json_encode($props['props']) ?>,
  methods:{
    Data:function(){
      axios.post('Database/render_<?=$response['template']?>/<?=$response['table']?>',{
        data:this.query,
        main:{
          '<?=$main?>':this.$root.url.id
        },
        result:'row'
      }).then((response)=>{
        this.item = response.data
        this.$emit('loading-screen','<?=$response['codename']?>')
      })
    },
    setUrl:function(act,id){
      if(act=='remove'){
        this.to_remove = true
        this.remove_item = id
      } else {
        if(this.$root.page.active==null){
          this.$root.GetPage(this.$root.p,act,id,'page')
          console.log('PAGENULL')
        } else {

          this.$root.GetPage(this.$root.p,act,id,'page')
          console.log(id)
        }
      }
    },
    Delete:function(act,id){
      axios.post('Module/delete/<?=$response['table']?>',{
        where:{'<?=$pk?>':this.remove_item}
      }).then((response)=>{
        this.to_remove = false
        this.remove_item = null
        this.Data()
      })
    },
    generate:function(type='pdf'){
      var cols = this.export.headers;
      var doc = new jsPDF({
        orientation:'portrait',
        unit:'in',
        format:'letter'
      });
      doc.setFontSize(16).text(this.title,0.5,1.0);
      doc.setLineWidth(0.01).line(0.5,1.1,8.0,1.1);

      doc.autoTable({
        cols,
        body:this.list,
        margin:{left:0.5,top:1.25}
      });

      doc
        .setFont('times')
        .setFontSize(11)
        .setFontStyle('italic')
        .setTextColor(0,0,255)
        .text("Pie de pagina",0.5,doc.internal.pageSize.height-0.5)
        .save(this.title+'.pdf')
    },
    <?= implode(',', $methods) ?>
  },
  created(){
    document.title = this.title
    <?= implode(',', $created) ?>
  }
})