<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Welcome to CodeIgniter 4!</title>
	<meta name="description" content="The small framework with powerful features">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="shortcut icon" type="image/png" href="/favicon.ico"/>
  <!-- Favicons -->
  <link href="<?= base_url('public/theme') ?>/assets/img/favicon.png" rel="icon">
  <link href="<?= base_url('public/theme') ?>/assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <link rel="stylesheet" href="<?= base_url('public/ui') ?>/assets/vendor/line-awesome/line-awesome/line-awesome/css/line-awesome.min.css">
  <!-- Plugins CSS File -->
  <link rel="stylesheet" href="<?= base_url('public/ui') ?>/assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?= base_url('public/ui') ?>/assets/css/plugins/owl-carousel/owl.carousel.css">
  <link rel="stylesheet" href="<?= base_url('public/ui') ?>/assets/css/plugins/magnific-popup/magnific-popup.css">
  <link rel="stylesheet" href="<?= base_url('public/ui') ?>/assets/css/plugins/jquery.countdown.css">
  <!-- Main CSS File -->
  <link rel="stylesheet" href="<?= base_url('public/ui') ?>/assets/css/style.css">
  <link rel="stylesheet" href="<?= base_url('public/ui') ?>/assets/css/skins/skin-demo-4.css">
  <link rel="stylesheet" href="<?= base_url('public/ui') ?>/assets/css/demos/demo-4.css">
  <style>
  	.zoom-on-hover {
  	  position: relative;
  	  overflow: hidden;
  	}
  	.zoom-on-hover .normal {
  	  width: 100%;
  	}
  	.zoom-on-hover .zoom {
  	  position: absolute;
  	  opacity: 0;
  	  transform-origin: top left;
  	}
  	.zoom-on-hover.zoomed .zoom {
  	  opacity: 1;
  	}
  	.zoom-on-hover.zoomed .normal {
  	  opacity: 0;
  	}

  	/* The Modal (background) */
  	.custom-modal {
  	  display: block; /* Hidden by default */
  	  position: fixed; /* Stay in place */
  	  z-index: 1; /* Sit on top */
  	  padding-top: 5px; /* Location of the box */
  	  left: 0;
  	  top: 0;
  	  width: 100%; /* Full width */
  	  height: 100%; /* Full height */
  	  overflow: auto; /* Enable scroll if needed */
  	  background-color: rgb(0,0,0); /* Fallback color */
  	  background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
  	}

  	/* Modal Content */
  	.custom-modal-content {
  	  position: relative;
  	  background-color: #fefefe;
  	  margin: auto;
  	  padding: 0;
  	  border: 1px solid #888;
  	  width: 95%;
  	  box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2),0 6px 20px 0 rgba(0,0,0,0.19);
  	  -webkit-animation-name: animatetop;
  	  -webkit-animation-duration: 0.4s;
  	  animation-name: animatetop;
  	  animation-duration: 0.4s
  	}

  	/* Add Animation */
  	@-webkit-keyframes animatetop {
  	  from {top:-300px; opacity:0} 
  	  to {top:0; opacity:1}
  	}

  	@keyframes animatetop {
  	  from {top:-300px; opacity:0}
  	  to {top:0; opacity:1}
  	}

  	/* The Close Button */
  	.close {
  	  color: gray;
  	  float: right;
  	  font-size: 28px;
  	  font-weight: bold;
  	}

  	.close:hover,
  	.close:focus {
  	  color: #000;
  	  text-decoration: none;
  	  cursor: pointer;
  	}

  	.custom-modal-header {
  	  padding: 0px 5px;
  	}

  	.custom-modal-body {padding: 2px 16px;}

  	.custom-modal-footer {
  	  padding: 0px 5px;
  	}
  </style>
  <script src="<?= base_url('public/theme/vue/vue.js') ?>"></script>
  <script src="<?= base_url('public/theme/vue/axios.min.js') ?>"></script>
  <script src="<?= base_url('public/theme/vue/vue-router.js') ?>"></script>
  <script src="<?= base_url('public/theme/vue/vue-google-maps.js') ?>"></script>
  <script src="<?= base_url('public/theme/vue/vue-grid-layout.umd.min.js') ?>"></script>
  <!-- <script src="https://maps.googleapis.com/maps/api/js?libraries=places&key=AIzaSyAb0HPDY2-MrV4K_CtjvIfBkAfBldMPdJE"></script> -->
  <!--script src="https://maps.googleapis.com/maps/api/js?libraries=places&key=AIzaSyAb0HPDY2-MrV4K_CtjvIfBkAfBldMPdJE"></script-->
  <script>
    const router = new VueRouter({
      mode: 'history',
      base: '',
      routes: []
    })
  </script>
  <?php
    $components_folder = FCPATH."/public/components";
    $files = array_diff(scandir($components_folder),array('.','..'));
  ?>
  <?php foreach ($files as $filename): ?>
    <script src="<?= base_url("public/components/{$filename}") ?>"></script>
  <?php endforeach ?>
</head>
<body>
	<div id="App">
		<div class="page-wrapper">
		  <NavMenu :menu="menu"></NavMenu>
		  <!-- End .header -->
		  <!--component :is="p"></component-->
		  <section v-if="p">
		  	<component v-if="page_content.data==null" :is="a?p+'-'+a:p"></component>
		  	<div v-else>
		  		<div class="row mb" v-for="(row,r) in page_content.data">
		  			<div v-for="(component,c) in row" :class="'col-md-'+component.w">
		  				<component :is="component.name"></component>
		  			</div>
		  		</div>
		  	</div>
		  </section>
		  <!--Suggestion v-else-if="p=='Suggestion'"></Suggestion-->
		  <!-- End .main -->
		  <footer class="footer">
		    <div v-for="(widget,i) in widgets" v-if="widget.key=='SUBSCRIBE'" class="cta bg-image bg-dark pt-4 pb-5 mb-0" style="background-image: url(<?= base_url('public/ui') ?>/assets/images/demos/demo-4/bg-5.jpg);">
		      <div class="container">
		        <div class="row justify-content-center">
		          <div class="col-sm-10 col-md-8 col-lg-6">
		            <div class="cta-heading text-center">
		              <h3 class="cta-title text-white">{{widget.value.title}}</h3>
		              <!-- End .cta-title -->
		              <p class="cta-desc text-white">{{widget.value.subtitle}}</p>
		              <!-- End .cta-desc -->
		            </div>
		            <!-- End .text-center -->
		            <form action="#">
		              <div class="input-group input-group-round">
		                <input type="email" class="form-control form-control-white" :placeholder="widget.value.placeholder" aria-label="Email Adress" required>
		                <div class="input-group-append">
		                  <button class="btn btn-primary" type="submit"><span>{{widget.value.button}}</span><i class="icon-long-arrow-right"></i></button>
		                </div>
		                <!-- .End .input-group-append -->
		              </div>
		              <!-- .End .input-group -->
		            </form>
		          </div>
		          <!-- End .col-sm-10 col-md-8 col-lg-6 -->
		        </div>
		        <!-- End .row -->
		      </div>
		      <!-- End .container -->
		    </div>
		    <!-- End .cta -->
		    <div v-for="(widget,i) in widgets" v-if="widget.key=='FOOTER'" class="footer-middle">
		      <div class="container">
		        <div v-for="row in widget.value" class="row">
		          <div v-for="item in row" :class="'col-md '+item.class">
		          	<div class="widget">
		          	  <h4 v-if="item.title!==null || item.title!==''" class="widget-title">{{item.title}}</h4>
		          	  <p v-html="item.content"></p>
		          	</div>
		          </div>
		        </div>
		        <!-- End .row -->
		      </div>
		      <!-- End .container -->
		    </div>
		  </footer>
		  <!-- End .footer -->
		</div>
		<!-- End .page-wrapper -->
		<button id="scroll-top" title="Back to Top"><i class="icon-arrow-up"></i></button>
		<!-- Mobile Menu -->
		<div class="mobile-menu-overlay"></div>
		<!-- End .mobil-menu-overlay -->
		<Navbar-Mobile :menu="menu"></Navbar-Mobile>
		<!-- End .mobile-menu-container -->
		<!-- Sign in / Register Modal -->
		<div class="modal fade" id="signin-modal" tabindex="-1" role="dialog" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
		      <div class="modal-body">
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true"><i class="icon-close"></i></span></button>
		        <div class="form-box">
		          <div class="form-tab">
		            <ul class="nav nav-pills nav-fill nav-border-anim" role="tablist">
		              <li class="nav-item">
		              	<a class="nav-link active" id="signin-tab" data-toggle="tab" href="#signin" aria-selected="true">Iniciar Sesión</a>
		              </li>
		              <li class="nav-item">
		              	<a class="nav-link" id="register-tab" data-toggle="tab" href="#register" aria-selected="false">Crear Cuenta</a>
		              </li>
		            </ul>
		            <div class="tab-content" id="tab-content-5">
		              <div class="tab-pane fade show active" id="signin" role="tabpanel" aria-labelledby="signin-tab">
		                <form v-on:submit.prevent="Login()">
		                  <div class="form-group">
		                    <label for="model-user">Usuario o Correo</label>
		                    <input type="text" v-model="login.user" class="form-control" id="model-user" required>
		                  </div>
		                  <!-- End .form-group -->
		                  <div class="form-group">
		                    <label for="model-password">Contraseña</label>
		                    <input type="password" v-model="login.password" class="form-control" id="model-password" required>
		                  </div>
		                  <!-- End .form-group -->
		                  <div class="form-footer">
		                    <button type="submit" class="btn btn-outline-primary-2"><span>ENTRAR</span><i class="icon-long-arrow-right"></i></button>
		                  </div>
		                  <!-- End .form-footer -->
		                </form>
		              </div>
		              <!-- .End .tab-pane -->
		              <div class="tab-pane fade" id="register" role="tabpanel" aria-labelledby="register-tab">
		                <form v-on:submit.prevent="Register('admin')" @change="validForm()">
		                	<div class="row">
			                  <div class="col-md-6">
			                    <label>Nombre *</label>
			                    <input type="text" class="form-control" v-model="signup.name">
			                  </div>
			                  <div class="col-md-6">
			                    <label>Apellido *</label>
			                    <input type="text" class="form-control" v-model="signup.lastname">
			                  </div>
		                	</div>

		                	<div class="row">
			                  <div class="col-md-6">
			                    <label>Telefono *</label>
			                    <input type="tel" class="form-control" v-model="signup.phone">
			                  </div>
			                  <div class="col-md-6">
			                    <label>Correo *</label>
			                    <input type="email" class="form-control" v-model="signup.email">
			                  </div>
		                	</div>
		                	<label>Usuario *</label>
		                	<input type="text" class="form-control" v-model="signup.user">
		                	<div class="row">
			                  <div class="col-md-6">
			                    <label>Contraseña</label>
			                    <input type="password" class="form-control" v-model="signup.password">
			                  </div>
			                  <div class="col-md-6">
			                    <label>Repetir Contraseña</label>
			                    <input type="password" class="form-control" v-model="valid.password">
			                  </div>
		                	</div>

		                  <div class="form-footer">
		                    <button role="submit" v-if="valid.errors==false && valid.password==signup.password" href="javascript:void(0)" class="btn btn-outline-primary">
		                    	<span>CREAR CUENTA</span><i class="icon-long-arrow-right"></i>
		                    </button>
		                    <button role="button" v-else href="javascript:void(0)" class="btn btn-outline-danger">
		                    	<span>Llene todos los campos</span>
		                    </button>
		                    {{signup}}
		                    <!-- End .custom-checkbox -->
		                  </div>
		                  <!-- End .form-footer -->
		                </form>
		                <!-- End .form-choice -->
		              </div>
		              <!-- .End .tab-pane -->
		            </div>
		            <!-- End .tab-content -->
		          </div>
		          <!-- End .form-tab -->
		        </div>
		        <!-- End .form-box -->
		      </div>
		      <!-- End .modal-body -->
		    </div>
		    <!-- End .modal-content -->
		  </div>
		  <!-- End .modal-dialog -->
		</div>
		<!-- End .modal -->
		<!--div class="container newsletter-popup-container mfp-hide" id="newsletter-popup-form">
		  <div class="row justify-content-center">
		    <div class="col-10">
		      <div class="row no-gutters bg-white newsletter-popup-content">
		        <div class="col-xl-3-5col col-lg-7 banner-content-wrap">
		          <div class="banner-content text-center"><img src="<?= base_url('public/ui') ?>/assets/images/popup/newsletter/logo.png" class="logo" alt="logo" width="60" height="15">
		            <h2 class="banner-title">get <span>25undefined % </span> offundefined</h2>
		            <p>Subscribe to the Molla eCommerce newsletter to receive timely updates from your favorite products.</p>
		            <form action="#">
		              <div class="input-group input-group-round">
		                <input type="email" class="form-control form-control-white" placeholder="Your Email Address" aria-label="Email Adress" required>
		                <div class="input-group-append">
		                  <button class="btn" type="submit"><span>go</span></button>
		                </div>
		              </div>
		            </form>
		            <div class="custom-control custom-checkbox">
		              <input type="checkbox" class="custom-control-input" id="register-policy-2" required>
		              <label class="custom-control-label" for="register-policy-2">Do not show this popup again</label>
		            </div>
		          </div>
		        </div>
		        <div class="col-xl-2-5col col-lg-5 "><img src="public/ui/assets/images/popup/newsletter/img-1.jpg" class="newsletter-img" alt="newsletter"></div>
		      </div>
		    </div>
		  </div>
		</div-->
	</div>
  <!-- Plugins JS File -->
  <script src="<?= base_url('public/ui') ?>/assets/js/jquery.min.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/bootstrap.bundle.min.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/jquery.hoverIntent.min.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/jquery.waypoints.min.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/superfish.min.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/owl.carousel.min.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/bootstrap-input-spinner.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/jquery.plugin.min.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/jquery.magnific-popup.min.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/jquery.countdown.min.js"></script>
  <!-- Main JS File -->
  <script src="<?= base_url('public/ui') ?>/assets/js/main.js"></script>
  <script src="<?= base_url('public/ui') ?>/assets/js/demos/demo-4.js"></script>
  	<script>
  		Vue.filter('capitalize', function (value) {
  		  if (!value) return ''
  		  value = value.toString()
  		  return value.charAt(0).toUpperCase() + value.slice(1)
  		})
  		Vue.filter('decimals', function (value) {
  		  if (!value) return ''
  		  return Number(value).toFixed(2)
  		})
  		Vue.filter('date', function (value) {
  		  if (!value) return ''
  		  let date_time = value.split(' ');
  			let date = date_time[0]
  			let time = date_time[1]
  			let new_date = date.split('-')
  		  return new_date[2]+'/'+new_date[1]+'/'+new_date[0]
  		})


  		Vue.use(VueGoogleMaps,{
  			load:{
  				region:'PE',
  				language: 'es',
  				key: 'AIzaSyAb0HPDY2-MrV4K_CtjvIfBkAfBldMPdJE',
  				libraries: 'places'
  			}
  		})
  	  var App = new Vue({
  	  	router,
  	    el: "#App",
  	    data: {
  	      title: "KEINES COMPUTER",
  	      page_content:{
  	      	data:null
  	      },
  	      menu: [],
  	      session: '',
  	      cart: [],
  	      widgets:[],
  	      popular:{
  	      	categories:[],
  	      	products:[]
  	    	},
  	      config:{
  	      	THEME:{
  	      		logo:[],
  	      		slogan:''
  	      	}
  	      },
  	      p: '',
  	      a: '',
  	      pk: '',
  	      signup:{
  	      	name:'',
  	      	lastname:'',
  	      	phone:'',
  	      	email:'',
  	      	user:'',
  	      	password:''
  	      },
  	      login:{
  	      	user:'',
  	      	password:''
  	      },
  	      valid:{
        		password:'',
        		errors:true
  	      }
  	    },
  	    watch:{
  	    	$route(to,from){
  	    		if (to.query.p!==undefined) {
  	    			this.p = to.query.p
  	    		}else{
  	    			this.p = 'home'
  	    		}
  	    		if (to.query.a!==undefined) {
  	    			this.a = to.query.a
  	    		}else{
  	    			this.a = null
  	    		}
  	    		if (to.query.pk!==undefined) {
  	    			this.pk = to.query.pk
  	    		}else{
  	    			this.pk = null
  	    		}
  	    		this.GetPage(this.p,this.a,this.pk)
  	    	}
  	    },
  	    methods:{
  	      GetSession: function(){
  	        axios.post('Session')
  	        .then((response)=>{
  	          App.session = response.data
  	        })
  	      },
  	      AddToCart: function(id){
  	        axios.post('Purchase/add_cart',{
  	        	'data':{
  	        		'ID':id
  	        	}
  	        })
  	        .then((response)=>{
  	          this.GetCart()
  	        })
  	      },
  	      Register: function(type){
  	        axios.post('Session/AddUser/'+type,{
  	        	data:this.signup
  	        })
  	        .then((response)=>{
  	          router.push({query:{p:'Message',a:response.data.route}})
  	        })
  	      },
  	      Login: function(type){
  	        axios.post('Session/LogIn',{
  	        	data:this.login
  	        })
  	        .then((response)=>{
  	        	if (response.data.success==true) {
  	        		this.GetSession()
  	        		if (this.session.role == 'admin') {
  	          		router.push({path:'Admin',query:{p:'Dashboard'}})
  	          		router.go()
  	        		}
  	        		if (this.session.role == 'customer') {
  	          		router.push({query:{p:'Home'}})
  	        		}
  	        	}
  	        })
  	      },
  	      GetCart: function(){
  	        axios.post('Purchase/get')
  	        .then((response)=>{
  	        	if (response.data) {
  	          	App.cart = JSON.parse(response.data.content)
  	        	}else{
  	        		App.cart = []
  	        	}
  	        })
  	      },
  	      GetWidget: function(){
  	        axios.post('Widget/get')
  	        .then((response)=>{
  	        	if (response.data) {
  	          	App.widgets = response.data
  	        	}else{
  	        		App.widgets = []
  	        	}
  	        })
  	        axios.post('Widget/popular')
  	        .then((response)=>{
  	        	if (response.data) {
  	          	App.popular = response.data
  	        	}else{
  	        		App.popular = []
  	        	}
  	        })
  	      },
  	      GetConfig: function(){
  	        axios.post('Config/get/STORE')
  	        .then((response)=>{
          		App.config.STORE = response.data
  	        })
  	        axios.post('Config/get/THEME')
  	        .then((response)=>{
            	App.config.THEME.logo = response.data.value.render_logo
            	App.config.THEME.slogan = response.data.value.slogan
            	App.config.THEME.width = response.data.value.width
            	App.config.THEME.height = response.data.value.height
  	        })
  	      },
  	      GetPage: function(page="home",action=null,id=null){
  	      	var path_init = '{'
  	      	if(page!==null){
  	      		path_init+='"p":"'+page+'"'
	      		}
  	      	if(action!==null){
  	      		path_init+=',"a":"'+action+'"'
	      		}
  	      	if(id!==null){
  	      		path_init+=',"pk":"'+id+'"'
	      		}
	      		path_init +='}'
	      		router.push({query:JSON.parse(path_init)}).catch(() => {})

  	        axios.post('Post/getPage/'+page)
  	        .then((response)=>{
  	        	this.p = page
          		App.page_content = response.data
  	        })
  	      },
  	      validForm: function() {
  	        if(
  	          this.signup.name == '' ||
  	          this.signup.lastname == '' ||
  	          this.signup.email == '' ||
  	          this.signup.phone == '' ||
  	          this.signup.password == '' ||
  	          this.signup.user == ''
  	        ){
  	          this.valid.errors = true
  	        } else {
  	          this.valid.errors = false
  	        }
  	      }
  	    },
  	    created: function() {
  	      var to = this.$route;
  	      if (to.query.p!==undefined) {
  	      	this.p = to.query.p
  	      }else{
  	      	this.p = 'home'
  	      }
  	      if (to.query.a!==undefined) {
  	      	this.a = to.query.a
  	      }else{
  	      	this.a = null
  	      }
  	      if (to.query.pk!==undefined) {
  	      	this.pk = to.query.pk
  	      }else{
  	      	this.pk = null
  	      }
  	      this.GetPage(this.p,this.a,this.pk)
  	      this.GetSession()
  	      this.GetCart()
  	      this.GetWidget()
  	      this.GetConfig()
  	      axios.post('Session/Menu/nav/shop')
  	      .then((response)=>{
  	        this.menu = response.data
  	      })
  	    }
  	  })
  	</script>
</body>
</html>
