Vue.component('home',{
  template: `
  <v-sheet fluid>
    <page-title :title="page.title"></page-title>
    <div v-if="render">
      <v-row>
        <v-col cols="12" v-for="section in render" :md="section.props.md?section.props.md:false">
          <v-sheet v-for="node in section.content">
            <component :is="node.codename" v-bind="$router.history.current.query" :key="'CHART-'+node.id+'-'+$root.t_key" v-if="node.template=='chart'"></component>
            <component :is="node.codename" v-bind="node.props" v-else></component>
          </v-sheet>
        </v-col>
      </v-row>
    </div>
  </v-sheet>
  `,
  data:()=>{
    return {
      page:{
        title:'Home'
      },
      render:null
    }
  },
  props:[],
  methods:{
  },
  mounted(){
    document.title = this.page.title
    axios.post('Settings/get/main-screen').then((response)=>{
      if (response.data.config) {
        this.render = response.data.config
      } else {
        this.render = null
      }
      this.$emit('loading-screen',false)
    })
  }
})
Vue.component('navbar-mobile',{
  template: `
  <div class="mobile-menu-container mobile-menu-light">
    <div class="mobile-menu-wrapper"><span class="mobile-menu-close"><i class="icon-close"></i></span>
      <form action="#" method="get" class="mobile-search">
        <label for="mobile-search" class="sr-only">Search</label>
        <input type="search" class="form-control" name="mobile-search" id="mobile-search" placeholder="Search in..." required>
        <button class="btn btn-primary" type="submit"><i class="icon-search"></i></button>
      </form>
      <ul class="nav nav-pills-mobile nav-border-anim" role="tablist">
        <li class="nav-item"><a class="nav-link active" id="mobile-menu-link" data-toggle="tab" href="#mobile-menu-tab" role="tab" aria-controls="mobile-menu-tab" aria-selected="true">Menu</a></li>
        <li class="nav-item"><a class="nav-link" id="mobile-cats-link" data-toggle="tab" href="#mobile-cats-tab" role="tab" aria-controls="mobile-cats-tab" aria-selected="false">Categories</a></li>
      </ul>
      <div class="tab-content">
        <div class="tab-pane fade show active" id="mobile-menu-tab" role="tabpanel" aria-labelledby="mobile-menu-link">
          <nav class="mobile-nav">
            <ul class="mobile-menu">
              <li v-for="item in menu">
                <a href="javascript:void(0)" @click="$router.push({query:{p:item.controller}});this.App.t=item.name">{{item.name}}</a>
              </li>
            </ul>
          </nav>
          <!-- End .mobile-nav -->
        </div>
        <!-- .End .tab-pane -->
        <div class="tab-pane fade" id="mobile-cats-tab" role="tabpanel" aria-labelledby="mobile-cats-link">
          <nav class="mobile-cats-nav">
            <ul class="mobile-cats-menu">
              <li><a class="mobile-cats-lead" href="#">Daily offers</a></li>
              <li><a class="mobile-cats-lead" href="#">Gift Ideas</a></li>
              <li><a href="#">Beds</a></li>
              <li><a href="#">Lighting</a></li>
              <li><a href="#">Sofas & Sleeper sofas</a></li>
              <li><a href="#">Storage</a></li>
              <li><a href="#">Armchairs & Chaises</a></li>
              <li><a href="#">Decoration </a></li>
              <li><a href="#">Kitchen Cabinets</a></li>
              <li><a href="#">Coffee & Tables</a></li>
              <li><a href="#">Outdoor Furniture </a></li>
            </ul>
            <!-- End .mobile-cats-menu -->
          </nav>
          <!-- End .mobile-cats-nav -->
        </div>
        <!-- .End .tab-pane -->
      </div>
      <!-- End .tab-content -->
      <div class="social-icons"><a href="#" class="social-icon" target="_blank" title="Facebook"><i class="icon-facebook-f"></i></a><a href="#" class="social-icon" target="_blank" title="Twitter"><i class="icon-twitter"></i></a><a href="#" class="social-icon" target="_blank" title="Instagram"><i class="icon-instagram"></i></a><a href="#" class="social-icon" target="_blank" title="Youtube"><i class="icon-youtube"></i></a></div>
      <!-- End .social-icons -->
    </div>
    <!-- End .mobile-menu-wrapper -->
  </div>
  `,
  data:()=>{
    return {
      data:[],
      menu:[]
    }
  },
  props:[],
  methods:{
    Data:function() {
      axios.post('Session/Menu/nav')
      .then((response)=>{
        this.menu = response.data
      })
    },
    LogOut:function() {
      var c = confirm('¿Desea cerrar sesión?');
      if (c==true) {
        axios.post('Session/LogOut')
        .then((response)=>{
          //App.GetSession()
        })
      }
    }
  },
  created:function() {
    this.Data()
  }
})
Vue.component('navbar-admin',{
  template: `
    <nav class="navbar navbar-expand-lg " color-on-scroll="500">
      <div v-if="role=='admin'" class="container-fluid">
        <a class="navbar-brand" href="javascript:void(0)">{{data.name}}</a>
        <button href="" class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" aria-controls="navigation-index" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-bar burger-lines"></span>
          <span class="navbar-toggler-bar burger-lines"></span>
          <span class="navbar-toggler-bar burger-lines"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-end" id="navigation">
          <ul class="nav navbar-nav mr-auto">
            <li class="nav-item">
              <a href="javascript:void(0)" @click="$router.push({query:{p:'Dashboard'}})" class="nav-link" data-toggle="dropdown">
                <i class="nc-icon nc-chart-bar-32">&nbsp;</i>
                <span class="d-lg-block">Tablero</span>
              </a>
            </li>
            <li class="dropdown nav-item">
              <a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
                <i class="nc-icon nc-planet"></i>
                <span class="notification">5</span>
                <span class="d-lg-none">Notification</span>
              </a>
              <ul class="dropdown-menu">
                <a class="dropdown-item" href="#">Notification 1</a>
                <a class="dropdown-item" href="#">Notification 2</a>
                <a class="dropdown-item" href="#">Notification 3</a>
                <a class="dropdown-item" href="#">Notification 4</a>
                <a class="dropdown-item" href="#">Another notification</a>
              </ul>
            </li>
            <li class="nav-item">
              <a href="#" class="nav-link">
                <i class="nc-icon nc-zoom-split"></i>
                <span class="d-lg-block">&nbsp;Search</span>
              </a>
            </li>
          </ul>
          <ul class="navbar-nav ml-auto">
            <li class="nav-item" v-for="item in menu">
              <a class="nav-link" href="javascript:void(0)" @click="$router.push({query:{p:item.controller}});this.App.t=item.name">
                <i :class="item.icon">&nbsp;</i>
                <span class="no-icon">{{item.name}}</span>
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="javascript:void(0)" @click="LogOut()">
                <span class="no-icon">Salir</span>
              </a>
            </li>
          </ul>
        </div>
      </div>
      <div v-else-if="role=='business'" class="container-fluid">
        <a class="navbar-brand" href="javascript:void(0)">{{data.name}}</a>
        <button href="" class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" aria-controls="navigation-index" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-bar burger-lines"></span>
          <span class="navbar-toggler-bar burger-lines"></span>
          <span class="navbar-toggler-bar burger-lines"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-end" id="navigation">
          <ul class="nav navbar-nav mr-auto">
            <li class="nav-item">
              <a href="javascript:void(0)" @click="$router.push({query:{p:'Dashboard'}})" class="nav-link" data-toggle="dropdown">
                <i class="nc-icon nc-chart-bar-32">&nbsp;</i>
                <span class="d-lg-block">Tablero</span>
              </a>
            </li>
          </ul>
          <ul class="navbar-nav ml-auto">
            <li class="nav-item" v-for="item in menu" @mouseover="$root.helpText=item.hotkey" @mouseleave="$root.helpText=null">
              <a class="nav-link" href="javascript:void(0)" @click="$router.push({query:{p:item.controller}});this.App.t=item.name">
                <i :class="item.icon">&nbsp;</i>
                <span class="no-icon">{{item.name}}</span>
              </a>
            </li>
            <!--li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="http://example.com" id="navbarDropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="no-icon">Dropdown</span>
              </a>
              <div class="dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                <a class="dropdown-item" href="#">Action</a>
                <a class="dropdown-item" href="#">Another action</a>
                <a class="dropdown-item" href="#">Something</a>
                <a class="dropdown-item" href="#">Something else here</a>
                <div class="divider"></div>
                <a class="dropdown-item" href="#">Separated link</a>
              </div>
            </li-->
            <li class="nav-item">
              <a class="nav-link" href="javascript:void(0)" @click="LogOut()">
                <span class="no-icon">Salir</span>
              </a>
            </li>
          </ul>
        </div>
      </div>
      <div v-else class="container-fluid">
        <a class="navbar-brand" href="javascript:void(0)">Propietario</a>
        <button href="" class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" aria-controls="navigation-index" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-bar burger-lines"></span>
          <span class="navbar-toggler-bar burger-lines"></span>
          <span class="navbar-toggler-bar burger-lines"></span>
        </button>
        <div class="collapse navbar-collapse justify-content-end" id="navigation">
          <ul class="nav navbar-nav mr-auto">
            <li class="nav-item">
              <a href="javascript:void(0)" @click="$router.push({query:{p:'Dashboard'}})" class="nav-link" data-toggle="dropdown">
                <i class="nc-icon nc-chart-bar-32">&nbsp;</i>
                <span class="d-lg-block">Tablero</span>
              </a>
            </li>
            <li class="dropdown nav-item">
              <a href="#" class="dropdown-toggle nav-link" data-toggle="dropdown">
                <i class="nc-icon nc-planet"></i>
                <span class="notification">5</span>
                <span class="d-lg-none">Notification</span>
              </a>
              <ul class="dropdown-menu">
                <a class="dropdown-item" href="#">Notification 1</a>
                <a class="dropdown-item" href="#">Notification 2</a>
                <a class="dropdown-item" href="#">Notification 3</a>
                <a class="dropdown-item" href="#">Notification 4</a>
                <a class="dropdown-item" href="#">Another notification</a>
              </ul>
            </li>
            <li class="nav-item">
              <a href="#" class="nav-link">
                <i class="nc-icon nc-zoom-split"></i>
                <span class="d-lg-block">&nbsp;Search</span>
              </a>
            </li>
          </ul>
          <ul class="navbar-nav ml-auto">
            <li class="nav-item" v-for="item in menu" @mouseover="$root.helpText = item.hotkey">
              <a class="nav-link" href="javascript:void(0)" @click="$router.push({query:{p:item.controller}});this.App.t=item.name">
                <i :class="item.icon">&nbsp;</i>
                <span class="no-icon">{{item.name}}</span>
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="javascript:void(0)" @click="LogOut()">
                <span class="no-icon">Salir</span>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </nav>
  `,
  data:()=>{
    return {
      data:[],
      menu:[]
    }
  },
  props:["role"],
  methods:{
    Data:function() {
      this.data = App.session
      axios.post('Session/Menu/nav')
      .then((response)=>{
        this.menu = response.data
        var keys = []
        var accKey = []
        var addKey = []
        for (var i = 0; i < response.data.length; i++) {
          accKey.push(response.data[i].hotkey)
          addKey.push("shift+"+response.data[i].hotkey)
          keys[response.data[i].hotkey] = {
            name:response.data[i].name,
            controller:response.data[i].controller
          }
          keys["shift+"+response.data[i].hotkey] = {
            name:response.data[i].name,
            controller:response.data[i].controller
          }
        }
        hotkeys(accKey.join(','), function(event, handler,key = keys){
          event.preventDefault()
          router.push({query:{p:key[handler.key].controller}});
          App.t=key[handler.key].name
        });
        hotkeys(addKey.join(','), function(event, handler,key = keys){
          event.preventDefault()
          router.push({query:{p:key[handler.key].controller,a:"add"}});
          App.t=key[handler.key].name
        });
      })
    },
    LogOut:function() {
      var c = confirm('Â¿Desea cerrar sesiÃ³n?');
      if (c==true) {
        axios.post('Session/LogOut')
        .then((response)=>{
          App.GetSession()
        })
      }
    }
  },
  created:function() {
    this.Data()
  }
})
Vue.component('sidebar',{
  template: `
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">
      <li v-for="item in menu" :class="(this.App.p==item.controller)?'nav-item active':'nav-item'">
        <a class="nav-link" href="javascript:void(0)" @click="$router.push({query:{p:item.controller}});this.App.t=item.name">
          <i :class="item.icon"></i>
          <span>{{item.name}}</span>
        </a>
      </li>
    </ul>
  </aside>
  `,
  data:()=>{
    return {
      data:[],
      menu:[],
    }
  },
  props:[],
  methods:{
    Data:function() {
      this.data = App.session
      axios.post('Session/Menu')
      .then((response)=>{
        this.menu = response.data
      })
    },
    LogOut:function() {
      var c = confirm('¿Desea cerrar sesión?');
      if (c==true) {
        axios.post('Session/LogOut')
        .then((response)=>{
          App.GetSession()
        })
      }
    }
  },
  created:function() {
    this.Data()
  }
})
Vue.component('menu-add',{
  template: `
  <form>
    <div class="row mb-3">
      <div class="col-md-6">
        <label>Rol</label>
        <select v-if="$root.session.role=='admin'" class="form-control" v-model="form.role">
          <option value="business">Negocio</option>
        </select>
        <select v-else class="form-control" v-model="form.role">
          <option v-for="item in list.roles" :value="item.ID">{{item.role}}</option>
        </select>
      </div>
      <div class="col-md-6">
        <label>Tipo</label>
        <select class="form-control" v-model="form.type">
          <option value="nav">Menu Superior</option>
          <option value="left">Menu Lateral</option>
          <option value="foot">Menu Footer</option>
        </select>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-12">
        <div class="table-responsive">
          <table class="table table-striped table-sm">
            <thead>
              <tr>
                <th scope="col">Modulo</th>
                <th scope="col">Controller</th>
                <th scope="col"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="module in val.modules">
                <th scope="row">{{module.name}}</th>
                <td>{{module.controller}}</td>
                <td><input type="checkbox" v-model="form.modules" :value="module.controller"></td></td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <button type="button" class="btn btn-info btn-fill pull-right text-uppercase" @click="Save()">
      <i class="nc-icon nc-cloud-upload-94"></i> Guardar
    </button>
    <div class="clearfix"></div>
  </form>
  `,
  data:()=>{
    return {
      form:{
        role:'owner',
        type:'nav',
        modules:[]
      },
      val:{
        modules:[]
      },
      list:{
        roles:[]
      }
    }
  },
  methods:{
    Save:function() {
      axios.post('Menu/Add',{
        data:this.form
      })
      .then((response)=>{
        if (response.data==true) {
          router.push({query:{p:App.p,a:'list'}})
        }else{
          alert('Los datos no pudieron ser guardados, intente mas tarde.')
        }
      })
    }
  },
  created:function() {
    axios.post('Module')
    .then((response)=>{
      this.val.modules = response.data
    })
    axios.post('Role')
    .then((response)=>{
      this.list.roles = response.data
    })
  }
})
Vue.component('menu-edit',{
  template: `
  <form>
    <div class="row mb-3">
      <div class="col-md-6">
        <label>Rol</label>
        <select class="form-control" v-model="form.role">
          <option value="owner">Propietario</option>
          <option value="building">Administrador</option>
          <option value="admin">Sys Admin</option>
        </select>
      </div>
      <div class="col-md-6">
        <label>Tipo</label>
        <select class="form-control" v-model="form.type">
          <option value="nav">Menu Superior</option>
          <option value="left">Menu Lateral</option>
          <option value="foot">Menu Footer</option>
        </select>
      </div>
    </div>
    <div class="row mb-3">
      <div class="col-md-12">
        <div class="table-responsive">
          <table class="table table-striped table-sm">
            <thead>
              <tr>
                <th scope="col">Modulo</th>
                <th scope="col">Controller</th>
                <th scope="col"></th>
              </tr>
            </thead>
            <tbody>
              <tr v-for="module in val.modules">
                <th scope="row">{{module.name}}</th>
                <td>{{module.controller}}</td>
                <td><input type="checkbox" v-model="form.modules" :value="module.controller"></td></td>
              </tr>
            </tbody>
          </table>
        </div>
        {{form}}
      </div>
    </div>
    <button type="button" class="btn btn-info btn-fill pull-right text-uppercase" @click="Save()">
      <i class="nc-icon nc-cloud-upload-94"></i> Guardar
    </button>
    <div class="clearfix"></div>
  </form>
  `,
  data:()=>{
    return {
      form:{
        role:'owner',
        type:'nav',
        modules:[]
      },
      val:{
        modules:[]
      }
    }
  },
  props:["pk"],
  methods:{
    Save:function() {
      axios.post('Menu/Update/'+this.pk,{
        data:this.form
      })
      .then((response)=>{
        if (response.data==true) {
          router.push({query:{p:App.p,a:'list'}})
          router.go()
        }else{
          alert('Los datos no pudieron ser guardados, intente mas tarde.')
        }
      })
    }
  },
  created:function() {
    axios.post('Module')
    .then((response)=>{
      this.val.modules = response.data
    })
    axios.post('Menu/index/'+this.pk)
    .then((response)=>{
      this.form.role = response.data.role
      this.form.type = response.data.type
      this.form.modules = response.data.modules
    })
  }
})
Vue.component('menu-list',{
  template: `
  <table class="table table-hover table-striped">
    <thead>
      <tr>
        <th>Rol</th>
        <th>Tipo</th>
        <th>Modulos</th>
        <th width="5%"><i class="nc-icon nc-stre-down"></i></th>
      </tr>
    </thead>
    <tbody>
      <tr v-for="item in data">
        <th class="font-weigth-bold text-danger">{{item.role}}</th>
        <td>{{item.type}}</td>
        <td>
          <span v-for="span in item.modules" class="badge badge-pill badge-info">{{span}}</span>
        </td>
        <td>
          <button type="button" class="btn btn-info btn-sm" @click="$router.push({query:{p:this.App.p,a:'edit',pk:item.ID}})">
            <i class="nc-icon nc-ruler-pencil"></i>
          </button>
        </td>
      </tr>
    </tbody>
  </table>
  `,
  data:()=>{
    return {
      data:[]
    }
  },
  methods:{
    Load:function() {
      axios.post('Menu')
      .then((response)=>{
        this.data = response.data
      })
    }
  },
  created:function() {
    this.Load()
  }
})